/*
 * Decompiled with CFR 0.152.
 */
package Transitions;

import Services.CFile;
import Services.CRect;
import Transitions.CTransitionData;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class CTrans {
    public static final int LEFT_RIGHT = 0;
    public static final int RIGHT_LEFT = 1;
    public static final int TOP_BOTTOM = 2;
    public static final int BOTTOM_TOP = 3;
    public static final int CENTER_LEFTRIGHT = 0;
    public static final int LEFTRIGHT_CENTER = 1;
    public static final int CENTER_TOPBOTTOM = 2;
    public static final int TOPBOTTOM_CENTER = 3;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int CENTER = 4;
    public static final int DIR_HORZ = 0;
    public static final int DIR_VERT = 1;
    public static final int TRFLAG_FADEIN = 1;
    public static final int TRFLAG_FADEOUT = 2;
    public long m_initTime;
    public long m_currentTime;
    public long m_endTime;
    public int m_duration;
    public boolean m_overflow;
    public boolean m_running;
    public boolean m_starting;
    public BufferedImage source1;
    public BufferedImage source2;
    public BufferedImage dest;
    public Graphics2D g2Dest;

    public void start(CTransitionData cTransitionData, BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3) {
        this.dest = bufferedImage;
        this.g2Dest = this.dest.createGraphics();
        this.source1 = bufferedImage2;
        this.source2 = bufferedImage3;
        this.m_initTime = System.currentTimeMillis();
        this.m_duration = cTransitionData.transDuration;
        if (this.m_duration == 0) {
            this.m_duration = 1;
        }
        this.m_currentTime = this.m_initTime;
        this.m_endTime = this.m_initTime + (long)this.m_duration;
        this.m_running = true;
        this.m_starting = true;
    }

    public void finish() {
        this.g2Dest.dispose();
    }

    public boolean isCompleted() {
        if (this.m_running) {
            return System.currentTimeMillis() >= this.m_endTime;
        }
        return true;
    }

    public int getDeltaTime() {
        this.m_currentTime = System.currentTimeMillis();
        if (this.m_currentTime > this.m_endTime) {
            this.m_currentTime = this.m_endTime;
        }
        return (int)(this.m_currentTime - this.m_initTime);
    }

    public int getTimePos() {
        return (int)(this.m_currentTime - this.m_initTime);
    }

    public void setTimePos(int n) {
        this.m_initTime = this.m_currentTime - (long)n;
        this.m_endTime = this.m_initTime + (long)this.m_duration;
    }

    public void blit(Image image) {
        this.g2Dest.drawImage(image, 0, 0, null);
    }

    public void blit(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0 && n6 > 0) {
            this.g2Dest.drawImage(image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, null);
        }
    }

    public void stretch(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 > 0 && n4 > 0 && n7 > 0 && n8 > 0) {
            this.g2Dest.drawImage(image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, null);
        }
    }

    public abstract void init(CTransitionData var1, CFile var2, BufferedImage var3, BufferedImage var4, BufferedImage var5) throws IOException;

    public abstract CRect[] stepDraw(int var1);

    public abstract void end();
}

