/*
 * Decompiled with CFR 0.152.
 */
package Sprites;

import Banks.CImage;
import Banks.CImageBank;
import Objects.CObject;
import Services.CRect;
import Sprites.CMask;
import Sprites.IDrawable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class CSprite {
    public static final int SF_RAMBO = 1;
    public static final int SF_RECALCSURF = 2;
    public static final int SF_PRIVATE = 4;
    public static final int SF_INACTIF = 8;
    public static final int SF_TOHIDE = 16;
    public static final int SF_TOKILL = 32;
    public static final int SF_REAF = 64;
    public static final int SF_HIDDEN = 128;
    public static final int SF_COLBOX = 256;
    public static final int SF_NOSAVE = 512;
    public static final int SF_FILLBACK = 1024;
    public static final int SF_DISABLED = 2048;
    public static final int SF_REAFINT = 4096;
    public static final int SF_OWNERDRAW = 8192;
    public static final int SF_OWNERSAVE = 16384;
    public static final int SF_FADE = 32768;
    public static final int SF_OBSTACLE = 65536;
    public static final int SF_PLATFORM = 131072;
    public static final int SF_BACKGROUND = 524288;
    public static final int SF_SCALE_RESAMPLE = 0x100000;
    public static final int SF_ROTATE_ANTIA = 0x200000;
    public static final int SF_NOHOTSPOT = 0x400000;
    public static final int SF_OWNERCOLMASK = 0x800000;
    public static final int SF_UPDATECOLLIST = 0x10000000;
    public static final int EFFECTFLAG_TRANSPARENT = 0x10000000;
    public static final int EFFECTFLAG_ANTIALIAS = 0x20000000;
    public static final int EFFECT_SEMITRANSP = 1;
    public CSprite objPrev = null;
    public CSprite objNext = null;
    CImageBank bank;
    public int sprFlags;
    public short sprLayer;
    public short sprAngle;
    public int sprZOrder;
    public int sprX;
    public int sprY;
    public int sprX1;
    public int sprY1;
    public int sprX2;
    public int sprY2;
    public int sprXnew;
    public int sprYnew;
    public int sprX1new;
    public int sprY1new;
    public int sprX2new;
    public int sprY2new;
    public int sprX1z;
    public int sprY1z;
    public int sprX2z;
    public int sprY2z;
    public float sprScaleX;
    public float sprScaleY;
    public short sprTempImg;
    public short sprTempAngle;
    public float sprTempScaleX;
    public float sprTempScaleY;
    public short sprImg;
    public short sprImgNew;
    public IDrawable sprRout;
    public int sprEffect;
    public int sprEffectParam;
    public int sprBackColor;
    byte[] sprBackSurf = null;
    public Image sprSf = null;
    public CMask sprColMask = null;
    public Image sprTempSf = null;
    public CMask sprTempColMask = null;
    public CObject sprExtraInfo;
    ArrayList<CSprite> sprCollisList;

    public CSprite() {
    }

    public CSprite(CImageBank cImageBank) {
        this.bank = cImageBank;
        this.sprCollisList = new ArrayList();
    }

    public int getSpriteLayer() {
        return this.sprLayer / 2;
    }

    public int getSpriteFlags() {
        return this.sprFlags;
    }

    public int setSpriteFlags(int n) {
        int n2 = this.sprFlags;
        this.sprFlags = n;
        return n2;
    }

    public int setSpriteColFlag(int n) {
        int n2 = this.sprFlags & 1;
        this.sprFlags = this.sprFlags & 0xFFFFFFFE | n;
        return n2;
    }

    public void killSpriteZone() {
        this.sprBackSurf = null;
    }

    public float getSpriteScaleX() {
        return this.sprScaleX;
    }

    public float getSpriteScaleY() {
        return this.sprScaleY;
    }

    public boolean getSpriteScaleResample() {
        return (this.sprFlags & 0x100000) != 0;
    }

    public int getSpriteAngle() {
        return this.sprAngle;
    }

    public boolean getSpriteAngleAntiA() {
        return (this.sprFlags & 0x200000) != 0;
    }

    public CRect getSpriteRect() {
        CRect cRect = new CRect();
        cRect.left = this.sprX1new;
        cRect.right = this.sprX2new;
        cRect.top = this.sprY1new;
        cRect.bottom = this.sprY2new;
        return cRect;
    }

    public void updateBoundingBox() {
        CImage cImage = this.bank.getImageFromHandle(this.sprImgNew);
        if (cImage == null) {
            this.sprX1new = this.sprXnew;
            this.sprX2new = this.sprXnew + 1;
            this.sprY1new = this.sprYnew;
            this.sprY2new = this.sprYnew + 1;
            return;
        }
        int n = cImage.width;
        int n2 = cImage.height;
        int n3 = 0;
        int n4 = 0;
        if ((this.sprFlags & 0x400000) == 0) {
            n4 = cImage.ySpot;
            n3 = cImage.xSpot;
        }
        if (this.sprAngle == 0) {
            if (this.sprScaleX == 1.0f) {
                this.sprX1new = this.sprXnew - n3;
                this.sprX2new = this.sprX1new + n;
            } else {
                this.sprX1new = this.sprXnew - (int)((float)n3 * this.sprScaleX);
                this.sprX2new = this.sprX1new + (int)((float)n * this.sprScaleX);
            }
            if (this.sprScaleY == 1.0f) {
                this.sprY1new = this.sprYnew - n4;
                this.sprY2new = this.sprY1new + n2;
            } else {
                this.sprY1new = this.sprYnew - (int)((float)n4 * this.sprScaleY);
                this.sprY2new = this.sprY1new + (int)((float)n2 * this.sprScaleY);
            }
        } else {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (this.sprScaleX != 1.0f) {
                n3 = (int)((float)n3 * this.sprScaleX);
                n = (int)((float)n * this.sprScaleX);
            }
            if (this.sprScaleY != 1.0f) {
                n4 = (int)((float)n4 * this.sprScaleY);
                n2 = (int)((float)n2 * this.sprScaleY);
            }
            --n;
            --n2;
            if (this.sprAngle == 90) {
                n10 = n2;
                n9 = -n;
                n8 = 0;
                n7 = 0;
                n6 = n4;
                n5 = -n3;
            } else if (this.sprAngle == 180) {
                n10 = 0;
                n9 = 0;
                n8 = -n2;
                n7 = -n;
                n6 = -n3;
                n5 = -n4;
            } else if (this.sprAngle == 270) {
                n10 = -n2;
                n9 = n;
                n8 = 0;
                n7 = 0;
                n6 = -n4;
                n5 = n3;
            } else {
                double d = (double)this.sprAngle * Math.PI / 180.0;
                float f = (float)Math.cos(d);
                float f2 = (float)Math.sin(d);
                n6 = (int)((float)n3 * f + (float)n4 * f2);
                n5 = (int)((float)n4 * f - (float)n3 * f2);
                n10 = (int)((float)n2 * f2);
                n9 = -((int)((float)n * f2));
                n8 = (int)((float)n2 * f);
                n7 = (int)((float)n * f);
            }
            int n11 = n10 + n7;
            int n12 = n8 + n9;
            int n13 = this.sprXnew - n6;
            int n14 = this.sprYnew - n5;
            n8 += this.sprYnew - n5;
            n12 += this.sprYnew - n5;
            n9 += this.sprYnew - n5;
            this.sprX1new = Math.min(n13, n10 += this.sprXnew - n6);
            this.sprX1new = Math.min(this.sprX1new, n11 += this.sprXnew - n6);
            this.sprX1new = Math.min(this.sprX1new, n7 += this.sprXnew - n6);
            this.sprX2new = Math.max(n13, n10);
            this.sprX2new = Math.max(this.sprX2new, n11);
            this.sprX2new = Math.max(this.sprX2new, n7);
            ++this.sprX2new;
            this.sprY1new = Math.min(n14, n8);
            this.sprY1new = Math.min(this.sprY1new, n12);
            this.sprY1new = Math.min(this.sprY1new, n9);
            this.sprY2new = Math.max(n14, n8);
            this.sprY2new = Math.max(this.sprY2new, n12);
            this.sprY2new = Math.max(this.sprY2new, n9);
            ++this.sprY2new;
        }
    }

    public void calcBoundingBox(short s, int n, int n2, int n3, float f, float f2, CRect cRect) {
        cRect.bottom = 0;
        cRect.right = 0;
        cRect.top = 0;
        cRect.left = 0;
        CImage cImage = this.bank.getImageFromHandle(s);
        if (cImage == null) {
            return;
        }
        int n4 = cImage.width;
        int n5 = cImage.height;
        int n6 = 0;
        int n7 = 0;
        if ((this.sprFlags & 0x400000) == 0) {
            n7 = cImage.ySpot;
            n6 = cImage.xSpot;
        }
        if (n3 == 0) {
            if (f == 1.0f) {
                cRect.left = n - n6;
                cRect.right = cRect.left + n4;
            } else {
                cRect.left = n - (int)((float)n6 * f);
                cRect.right = cRect.left + (int)((float)n4 * f);
            }
            if (f2 == 1.0f) {
                cRect.top = n2 - n7;
                cRect.bottom = cRect.top + n5;
            } else {
                cRect.top = n2 - (int)((float)n7 * f2);
                cRect.bottom = cRect.top + (int)((float)n5 * f2);
            }
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            if (f != 1.0f) {
                n6 = (int)((float)n6 * f);
                n4 = (int)((float)n4 * f);
            }
            if (f2 != 1.0f) {
                n7 = (int)((float)n7 * f2);
                n5 = (int)((float)n5 * f2);
            }
            --n4;
            --n5;
            if (n3 == 90) {
                n13 = n5;
                n12 = -n4;
                n11 = 0;
                n10 = 0;
                n9 = n7;
                n8 = -n6;
            } else if (n3 == 180) {
                n13 = 0;
                n12 = 0;
                n11 = -n5;
                n10 = -n4;
                n9 = -n6;
                n8 = -n7;
            } else if (n3 == 270) {
                n13 = -n5;
                n12 = n4;
                n11 = 0;
                n10 = 0;
                n9 = -n7;
                n8 = n6;
            } else {
                double d = (double)n3 * Math.PI / 180.0;
                float f3 = (float)Math.cos(d);
                float f4 = (float)Math.sin(d);
                n9 = (int)((float)n6 * f3 + (float)n7 * f4);
                n8 = (int)((float)n7 * f3 - (float)n6 * f4);
                n13 = (int)((float)n5 * f4);
                n12 = -((int)((float)n4 * f4));
                n11 = (int)((float)n5 * f3);
                n10 = (int)((float)n4 * f3);
            }
            int n14 = n13 + n10;
            int n15 = n11 + n12;
            int n16 = n - n9;
            int n17 = n2 - n8;
            n11 += n2 - n8;
            n15 += n2 - n8;
            n12 += n2 - n8;
            cRect.left = Math.min(n16, n13 += n - n9);
            cRect.left = Math.min(cRect.left, n14 += n - n9);
            cRect.left = Math.min(cRect.left, n10 += n - n9);
            cRect.right = Math.max(n16, n13);
            cRect.right = Math.max(cRect.right, n14);
            cRect.right = Math.max(cRect.right, n10);
            ++cRect.right;
            cRect.top = Math.min(n17, n11);
            cRect.top = Math.min(cRect.top, n15);
            cRect.top = Math.min(cRect.top, n12);
            cRect.bottom = Math.max(n17, n11);
            cRect.bottom = Math.max(cRect.bottom, n15);
            cRect.bottom = Math.max(cRect.bottom, n12);
            ++cRect.bottom;
        }
    }

    public void draw(Graphics2D graphics2D) {
        if (this.sprSf != null) {
            graphics2D.drawImage(this.sprSf, this.sprX1, this.sprY1, null);
        } else {
            CImage cImage = this.bank.getImageFromHandle(this.sprImg);
            if (cImage != null) {
                graphics2D.drawImage(cImage.img, this.sprX1, this.sprY1, null);
            }
        }
    }
}

