/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Services.CFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CRect {
    public int left = 0;
    public int top = 0;
    public int right = 0;
    public int bottom = 0;

    public void load(CFile cFile) throws IOException {
        this.left = cFile.readAInt();
        this.top = cFile.readAInt();
        this.right = cFile.readAInt();
        this.bottom = cFile.readAInt();
    }

    public void copyRect(CRect cRect) {
        this.left = cRect.left;
        this.right = cRect.right;
        this.top = cRect.top;
        this.bottom = cRect.bottom;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.left);
        dataOutputStream.writeInt(this.top);
        dataOutputStream.writeInt(this.right);
        dataOutputStream.writeInt(this.bottom);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.left = dataInputStream.readInt();
        this.top = dataInputStream.readInt();
        this.right = dataInputStream.readInt();
        this.bottom = dataInputStream.readInt();
    }

    public boolean ptInRect(int n, int n2) {
        return n >= this.left && n < this.right && n2 >= this.top && n2 < this.bottom;
    }

    public boolean intersectRect(CRect cRect) {
        return (this.left >= cRect.left && this.left < cRect.right || this.right >= cRect.left && this.right < cRect.right || cRect.left >= this.left && cRect.left < this.right || cRect.right >= this.left && cRect.right < this.right) && (this.top >= cRect.top && this.top < cRect.bottom || this.bottom >= cRect.top && this.bottom < cRect.bottom || cRect.top >= this.top && cRect.top < this.bottom || cRect.bottom >= this.top && cRect.bottom < this.bottom);
    }
}

