/*
 * Decompiled with CFR 0.152.
 */
package Services;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CFile {
    RandomAccessFile file = null;
    byte[] data = null;
    public int pointer = 0;
    public boolean bUnicode;

    public CFile(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
    }

    public CFile(byte[] byArray) {
        this.data = byArray;
        this.pointer = 0;
    }

    public void setUnicode(boolean bl) {
        this.bUnicode = bl;
    }

    public byte readAByte() throws IOException {
        if (this.file != null) {
            return this.file.readByte();
        }
        return this.data[this.pointer++];
    }

    public short readAShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n2 * 256 + n);
    }

    public char readAChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)(n2 * 256 + n);
    }

    public void readAChar(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            int n = this.readUnsignedByte();
            int n2 = this.readUnsignedByte();
            cArray[i] = (char)(n2 * 256 + n);
        }
    }

    public int readAInt() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        return n4 * 0x1000000 + n3 * 65536 + n2 * 256 + n;
    }

    public int readAColor() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        this.readUnsignedByte();
        return n * 65536 + n2 * 256 + n3;
    }

    public float readAFloat() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = n4 * 0x1000000 + n3 * 65536 + n2 * 256 + n;
        return (float)n5 / 65536.0f;
    }

    public double readADouble() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = this.readUnsignedByte();
        int n6 = this.readUnsignedByte();
        int n7 = this.readUnsignedByte();
        int n8 = this.readUnsignedByte();
        long l = (long)n4 * 0x1000000L + (long)n3 * 65536L + (long)n2 * 256L + (long)n;
        long l2 = (long)n8 * 0x1000000L + (long)n7 * 65536L + (long)n6 * 256L + (long)n5;
        long l3 = l2 << 32 | l;
        double d = (double)l3 / 65536.0;
        return d / 65536.0;
    }

    public String readAString(int n) throws IOException {
        int n2;
        if (!this.bUnicode) {
            int n3;
            byte[] byArray = new byte[n];
            this.read(byArray);
            for (n3 = 0; n3 < n && byArray[n3] != 0; ++n3) {
            }
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = byArray[i];
            }
            return new String(byArray2);
        }
        char[] cArray = new char[n];
        this.readAChar(cArray);
        for (n2 = 0; n2 < n && cArray[n2] != '\u0000'; ++n2) {
        }
        char[] cArray2 = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[i];
        }
        return new String(cArray2);
    }

    public String readAString() throws IOException {
        String string = "";
        long l = this.getFilePointer();
        if (!this.bUnicode) {
            int n;
            while ((n = this.readUnsignedByte()) != 0) {
            }
            long l2 = this.getFilePointer();
            this.seek(l);
            if (l2 > l + 1L) {
                byte[] byArray = new byte[(int)(l2 - l - 1L)];
                this.read(byArray);
                string = new String(byArray);
            }
            this.skipBytes(1);
        } else {
            char c;
            while ((c = this.readAChar()) != '\u0000') {
            }
            long l3 = this.getFilePointer();
            this.seek(l);
            if (l3 > l + 2L) {
                int n = (int)(l3 - l - 1L) / 2;
                char[] cArray = new char[n];
                this.readAChar(cArray);
                string = new String(cArray);
            }
            this.skipBytes(2);
        }
        return string;
    }

    public String readAStringEOL() throws IOException {
        long l = this.getFilePointer();
        String string = "";
        if (!this.bUnicode) {
            int n = this.readUnsignedByte();
            try {
                while (n != 10 && n != 13) {
                    n = this.readUnsignedByte();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            long l2 = this.getFilePointer();
            this.seek(l);
            int n2 = 1;
            if (n != 10 && n != 13) {
                n2 = 0;
            }
            if (l2 > l + (long)n2) {
                byte[] byArray = new byte[(int)(l2 - l - (long)n2)];
                this.read(byArray);
                string = new String(byArray);
            }
            try {
                if (n == 10 || n == 13) {
                    this.skipBytes(1);
                    int n3 = this.readUnsignedByte();
                    if (n == 10 && n3 != 13) {
                        this.skipBack(1);
                    }
                    if (n == 13 && n3 != 10) {
                        this.skipBack(1);
                    }
                }
            }
            catch (IOException iOException) {}
        } else {
            int n;
            char c = this.readAChar();
            try {
                while (c != '\n' && c != '\r') {
                    c = this.readAChar();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            long l3 = this.getFilePointer();
            this.seek(l);
            int n4 = 2;
            if (c != '\n' && c != '\r') {
                n4 = 0;
            }
            if (l3 > l + (long)n4) {
                n = (int)(l3 - l - (long)n4) / 2;
                char[] cArray = new char[n];
                this.readAChar(cArray);
                string = new String(cArray);
            }
            try {
                if (c == '\n' || c == '\r') {
                    this.skipBytes(2);
                    n = this.readAChar();
                    if (c == '\n' && n != 13) {
                        this.skipBack(1);
                    }
                    if (c == '\r' && n != 10) {
                        this.skipBack(1);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public void skipAString() throws IOException {
        if (!this.bUnicode) {
            int n;
            while ((n = this.readUnsignedByte()) != 0) {
            }
        } else {
            short s;
            while ((s = this.readShort()) != 0) {
            }
        }
    }

    public String readAUnicodeString() throws IOException {
        short s;
        long l = this.getFilePointer();
        while ((s = this.readShort()) != 0) {
        }
        long l2 = this.getFilePointer();
        this.seek(l);
        int n = (int)(l2 - l) / 2 - 1;
        char[] cArray = new char[n];
        this.readAChar(cArray);
        this.skipBytes(2);
        return new String(cArray);
    }

    public long getFilePointer() throws IOException {
        if (this.file != null) {
            return this.file.getFilePointer();
        }
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (this.file != null) {
            this.file.seek(l);
        } else {
            if (l >= (long)this.data.length) {
                l = this.data.length;
            }
            this.pointer = (int)l;
        }
    }

    public void skipBack(int n) throws IOException {
        long l = this.getFilePointer();
        if ((l -= (long)n) < 0L) {
            l = 0L;
        }
        this.seek(l);
    }

    public void skipBytes(int n) throws IOException {
        if (this.file != null) {
            this.file.skipBytes(n);
        } else {
            if (this.pointer + n >= this.data.length) {
                n = this.data.length - this.pointer;
            }
            this.pointer += n;
        }
    }

    public byte[] readBuffer(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray);
        return byArray;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.file != null) {
            return this.file.read(byArray);
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = this.data[this.pointer++];
        }
        return n;
    }

    public int read(byte[] byArray, int n) throws IOException {
        int n2;
        if (this.file != null) {
            return this.file.read(byArray, 0, n);
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.data[this.pointer++];
        }
        return n2;
    }

    public byte[] readArray(int n) throws IOException {
        if (this.file == null) {
            if (n < 0) {
                n = this.data.length;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.data[this.pointer++];
            }
            return byArray;
        }
        if (n < 0) {
            n = (int)this.file.length();
        }
        byte[] byArray = new byte[n];
        this.file.read(byArray);
        return byArray;
    }

    public int readUnsignedByte() throws IOException {
        if (this.file != null) {
            return this.file.readUnsignedByte();
        }
        if (this.pointer >= this.data.length) {
            throw new EOFException();
        }
        return this.data[this.pointer++] & 0xFF;
    }

    public short readShort() throws IOException {
        if (this.file != null) {
            return this.file.readShort();
        }
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n << 8 | n2);
    }

    public byte readByte() throws IOException {
        if (this.file != null) {
            return this.file.readByte();
        }
        if (this.pointer >= this.data.length) {
            throw new EOFException();
        }
        return this.data[this.pointer++];
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        } else {
            this.data = null;
        }
    }
}

