/*
 * Decompiled with CFR 0.152.
 */
package RunLoop;

import Animations.CRAni;
import Application.CRunApp;
import Application.CRunFrame;
import Application.CSysEvent;
import Banks.CImage;
import Events.CEvent;
import Events.CEventGroup;
import Events.CEventProgram;
import Events.CQualToOiList;
import Expressions.CExp;
import Expressions.CValue;
import Expressions.EXP_END;
import Extensions.CExtStorage;
import Frame.CLO;
import Frame.CLayer;
import Movements.CMove;
import Movements.CMoveBall;
import Movements.CMoveBullet;
import Movements.CMoveDef;
import Movements.CMoveExtension;
import Movements.CMoveGeneric;
import Movements.CMoveMouse;
import Movements.CMovePath;
import Movements.CMovePlatform;
import Movements.CMoveRace;
import Movements.CRMvt;
import OI.COCBackground;
import OI.COCQBackdrop;
import OI.COI;
import OI.CObjectCommon;
import Objects.CActive;
import Objects.CCCA;
import Objects.CCounter;
import Objects.CExtension;
import Objects.CLives;
import Objects.CObject;
import Objects.CQuestion;
import Objects.CRCom;
import Objects.CRtf;
import Objects.CScore;
import Objects.CText;
import Params.CParamExpression;
import Params.CPositionInfo;
import Params.PARAM_CREATE;
import RunLoop.CBackDraw;
import RunLoop.CBackDrawPaste;
import RunLoop.CBkd2;
import RunLoop.CCreateObjectInfo;
import RunLoop.CDemoRecord;
import RunLoop.CObjInfo;
import RunLoop.CSaveFilter;
import RunLoop.CSaveGlobal;
import RunLoop.CSaveGlobalCounter;
import RunLoop.CSaveGlobalText;
import RunLoop.CSaveGlobalValues;
import Services.CFontInfo;
import Services.CMessageBox;
import Services.CRect;
import Services.CResources;
import Services.CServices;
import Sprites.CColMask;
import Sprites.CMask;
import Sprites.CRSpr;
import Sprites.CSprite;
import Sprites.CSpriteGen;
import Values.CRVal;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRun {
    public static final short GAMEFLAGS_VBLINDEP = 2;
    public static final short GAMEFLAGS_LIMITEDSCROLL = 4;
    public static final short GAMEFLAGS_FIRSTLOOPFADEIN = 16;
    public static final short GAMEFLAGS_LOADONCALL = 32;
    public static final short GAMEFLAGS_REALGAME = 64;
    public static final short GAMEFLAGS_PLAY = 128;
    public static final short GAMEFLAGS_INITIALISING = 512;
    public static final short DLF_DONTUPDATE = 2;
    public static final short DLF_DRAWOBJECTS = 4;
    public static final short DLF_RESTARTLEVEL = 8;
    public static final short DLF_DONTUPDATECOLMASK = 16;
    public static final short DLF_COLMASKCLIPPED = 32;
    public static final short DLF_SKIPLAYER0 = 64;
    public static final short DLF_REDRAWLAYER = 128;
    public static final short DLF_STARTLEVEL = 256;
    public static final short GAME_XBORDER = 480;
    public static final short GAME_YBORDER = 300;
    public static final short COLMASK_XMARGIN = 64;
    public static final short COLMASK_YMARGIN = 16;
    public static final int WRAP_X = 1;
    public static final int WRAP_Y = 2;
    public static final int WRAP_XY = 4;
    public static final byte[][] plMasks = new byte[][]{{0, 0, 0, 0}, {-1, 0, 0, 0}, {-1, -1, 0, 0}, {-1, -1, -1, 0}, {-1, -1, -1, -1}};
    public static final int RH3SCROLLING_SCROLL = 1;
    public static final int RH3SCROLLING_REDRAWLAYERS = 2;
    public static final int RH3SCROLLING_REDRAWALL = 4;
    public static final int RH3SCROLLING_REDRAWTOTALCOLMASK = 8;
    public static final int OBSTACLE_NONE = 0;
    public static final int OBSTACLE_SOLID = 1;
    public static final int OBSTACLE_PLATFORM = 2;
    public static final int OBSTACLE_LADDER = 3;
    public static final int OBSTACLE_TRANSPARENT = 4;
    public static final short COF_NOMOVEMENT = 1;
    public static final short COF_HIDDEN = 2;
    public static final short COF_FIRSTTEXT = 4;
    public static final short MAX_FRAMERATE = 10;
    public static final short LOOPEXIT_NEXTLEVEL = 1;
    public static final short LOOPEXIT_PREVLEVEL = 2;
    public static final short LOOPEXIT_GOTOLEVEL = 3;
    public static final short LOOPEXIT_NEWGAME = 4;
    public static final short LOOPEXIT_PAUSEGAME = 5;
    public static final short LOOPEXIT_SAVEAPPLICATION = 6;
    public static final short LOOPEXIT_LOADAPPLICATION = 7;
    public static final short LOOPEXIT_SAVEFRAME = 8;
    public static final short LOOPEXIT_LOADFRAME = 9;
    public static final short LOOPEXIT_ENDGAME = -2;
    public static final short LOOPEXIT_QUIT = 100;
    public static final short LOOPEXIT_RESTART = 101;
    public static final short LOOPEXIT_APPLETPAUSE = 102;
    public static final short BORDER_LEFT = 1;
    public static final short BORDER_RIGHT = 2;
    public static final short BORDER_TOP = 4;
    public static final short BORDER_BOTTOM = 8;
    public static final short BORDER_ALL = 15;
    short[] Table_InOut = new short[]{0, 1, 2, 0, 4, 5, 6, 0, 8, 9, 10, 0, 0, 0, 0, 0};
    public CSpriteGen spriteGen;
    public JFrame rhWindow;
    public CRunApp rhApp;
    public CRunFrame rhFrame;
    public int rhMaxOI;
    public byte rhStopFlag;
    public byte rhEvFlag;
    public int rhNPlayers;
    public byte rhMouseUsed;
    public short rhGameFlags;
    public short rhFree;
    public byte[] rhPlayer = new byte[4];
    public short rhQuit;
    public short rhQuitBis;
    public int rhReturn;
    public int rhQuitParam;
    public int rhNObjects;
    public int rhMaxObjects;
    public CObjInfo[] rhOiList;
    public CEventProgram rhEvtProg = null;
    public int rhLevelSx;
    public int rhLevelSy;
    public int rhWindowX;
    public int rhWindowY;
    public int rhVBLDeltaOld;
    public int rhVBLObjet;
    public int rhVBLOld;
    public short rhMT_VBLStep;
    public short rhMT_VBLCount;
    public int rhMT_MoveStep;
    public int rhLoopCount;
    public long rhTimer;
    public long rhTimerOld;
    public int rhTimerDelta;
    public short rhFree4;
    public int rhOiListPtr;
    public short rhObListNext;
    public short rhDestroyPos;
    public byte[] rh2OldPlayer = new byte[4];
    public byte[] rh2NewPlayer = new byte[4];
    public byte[] rh2InputMask = new byte[4];
    public byte rh2MouseKeys;
    public short rh2CreationCount;
    public short rh2Free;
    public int rh2MouseX;
    public int rh2MouseY;
    public short rh2Free2;
    public int rh2MouseSaveX;
    public int rh2MouseSaveY;
    public int rh2PauseCompteur;
    public long rh2PauseTimer;
    public int rh2PauseVbl;
    public int rh3DisplayX;
    public int rh3DisplayY;
    public int rh3WindowSx;
    public int rh3WindowSy;
    public short rh3CollisionCount;
    public char rh3Scrolling;
    public int rh3Panic;
    public int rh3PanicBase;
    public int rh3PanicPile;
    public int rh3XMinimum;
    public int rh3YMinimum;
    public int rh3XMaximum;
    public int rh3YMaximum;
    public int rh3XMinimumKill;
    public int rh3YMinimumKill;
    public int rh3XMaximumKill;
    public int rh3YMaximumKill;
    public short rh3Graine;
    public short rh4DemoMode;
    public CDemoRecord rh4Demo;
    public int rh4PauseKey;
    public String rh4CurrentFastLoop;
    public int rh4EndOfPause;
    public short rh4MouseWheelDelta;
    public int rh4OnMouseWheel;
    public String rh4PSaveFilename;
    public int rh4SaveVersion;
    public int rh4MusicHandle;
    public int rh4MusicFlags;
    public int rh4MusicLoops;
    public int rh4LoadCount;
    public ArrayList rh4FastLoops = null;
    public CValue rh4ExpValue1;
    public CValue rh4ExpValue2;
    public int rh4KpxReturn;
    public int rh4ObjectCurCreate;
    public int rh4ObjectAddCreate;
    public short rh4FakeKey;
    public char rh4DoUpdate;
    public boolean rh4MenuEaten = false;
    public int rh4OnCloseCount;
    public short rh4CursorCount;
    public short rh4ScrMode;
    public int rh4VBLDelta;
    public int rh4LoopTheoric;
    public int rh4EventCount;
    public ArrayList<CBackDraw> rh4BackDrawRoutines = null;
    public short rh4LastQuickDisplay;
    public short rh4FirstQuickDisplay;
    public int rh4WindowDeltaX;
    public int rh4WindowDeltaY;
    public int rh4TimeOut;
    public int rh4TabCounter;
    public int rh4MouseXCenter;
    public int rh4MouseYCenter;
    public int rh4PosPile;
    public CValue[] rh4Results;
    public CExp[] rh4Operators;
    public CExp rh4OpeNull;
    public int rh4CurToken;
    public CExp[] rh4Tokens;
    public static final int MAX_INTERMEDIATERESULTS = 128;
    public int[] rh4FrameRateArray = new int[10];
    public int rh4FrameRatePos;
    public int rh4FrameRatePrevious;
    public int[] rhDestroyList;
    public int rh4SaveFrame;
    public int rh4SaveFrameCount;
    public double rh4MvtTimerCoef;
    public CObject[] rhObjectList = null;
    int xScrolling = 320;
    public boolean bOperande;
    public static final short SAVE_VERSION = 1;
    static final int READ_ERROR = 1;
    static final int NOTMMF_ERROR = 2;
    static final int BADAPP_ERROR = 3;
    static final int BADRUNVERSION_ERROR = 4;
    static final int BADAPPVERSION_ERROR = 5;
    static final int BADFRAME_ERROR = 6;
    static final int WRITE_ERROR = 7;

    public CRun() {
    }

    public CRun(CRunApp cRunApp) {
        this.rhApp = cRunApp;
        this.rhFrame = cRunApp.frame;
        this.rhWindow = cRunApp.window;
    }

    public int allocRunHeader() {
        int n;
        this.rhObjectList = new CObject[this.rhFrame.maxObjects];
        this.rhEvtProg = this.rhFrame.evtProg;
        this.rhMaxOI = 0;
        COI cOI = this.rhApp.OIList.getFirstOI();
        while (cOI != null) {
            if (cOI.oiType >= 2) {
                ++this.rhMaxOI;
            }
            cOI = this.rhApp.OIList.getNextOI();
        }
        this.rhOiList = new CObjInfo[this.rhMaxOI];
        for (n = 0; n < this.rhMaxOI; ++n) {
            this.rhOiList[n] = null;
        }
        if (this.rhFrame.m_wRandomSeed == -1) {
            int n2 = (int)System.currentTimeMillis();
            this.rh3Graine = (short)n2;
        } else {
            this.rh3Graine = this.rhFrame.m_wRandomSeed;
        }
        this.spriteGen = new CSpriteGen(this.rhApp.imageBank, this.rhApp, this.rhFrame, this.rhApp.spritesBack);
        this.rhDestroyList = new int[this.rhFrame.maxObjects / 32 + 1];
        this.rh4FastLoops = new ArrayList();
        this.rh4CurrentFastLoop = new String("");
        this.rhMaxObjects = this.rhFrame.maxObjects;
        this.rhNPlayers = this.rhEvtProg.nPlayers;
        this.rhWindowX = this.rhFrame.leX;
        this.rhWindowY = this.rhFrame.leY;
        this.rhLevelSx = this.rhFrame.leVirtualRect.right;
        if (this.rhLevelSx == -1) {
            this.rhLevelSx = 0x7FFFF000;
        }
        this.rhLevelSy = this.rhFrame.leVirtualRect.bottom;
        if (this.rhLevelSy == -1) {
            this.rhLevelSy = 0x7FFFF000;
        }
        this.rhNObjects = 0;
        this.rhStopFlag = 0;
        this.rhQuit = 0;
        this.rhQuitBis = 0;
        this.rhGameFlags = (short)(this.rhGameFlags & 0x80);
        this.rhGameFlags = (short)(this.rhGameFlags | 4);
        this.rh3Panic = 0;
        this.rh4FirstQuickDisplay = Short.MIN_VALUE;
        this.rh4LastQuickDisplay = Short.MIN_VALUE;
        this.rh4MouseXCenter = this.rhFrame.leEditWinWidth / 2;
        this.rh4MouseYCenter = this.rhFrame.leEditWinHeight / 2;
        this.rh4FrameRatePos = 0;
        this.rh4FrameRatePrevious = 0;
        this.rh4BackDrawRoutines = null;
        this.rh4SaveFrame = 0;
        this.rh4SaveFrameCount = -3;
        this.rhGameFlags = (short)(this.rhGameFlags | 0x40);
        this.rh4CursorCount = this.rhApp.cursorCount;
        this.rh4Results = new CValue[128];
        this.rh4Operators = new CExp[128];
        for (n = 0; n < 128; ++n) {
            this.rh4Results[n] = new CValue();
        }
        this.rh4OpeNull = new EXP_END();
        this.rh4OpeNull.code = 0;
        this.rhFrame.rhOK = true;
        return 0;
    }

    public void freeRunHeader() {
        this.rhFrame.rhOK = false;
        this.rh4Demo = null;
        this.rhObjectList = null;
        this.rhOiList = null;
        this.rhDestroyList = null;
        this.rh4PSaveFilename = null;
        this.rh4CurrentFastLoop = null;
        this.rh4FastLoops = null;
        this.spriteGen = null;
        this.rh4BackDrawRoutines = null;
        for (int i = 0; i < 128; ++i) {
            this.rh4Results[i] = null;
        }
        this.rh4OpeNull = null;
    }

    public int initRunLoop(boolean bl) {
        int n = 0;
        if (this.rhApp.pLoadFilename != null) {
            if (this.loadFramePosition(null)) {
                return 0;
            }
            this.f_StopSamples();
            this.f_StopMusics();
            this.killFrameObjects();
            this.y_KillLevel(false);
            this.rhEvtProg.unBranchPrograms();
            this.freeMouse();
            this.freeRunHeader();
        }
        if ((n = this.allocRunHeader()) != 0) {
            return n;
        }
        if (bl) {
            this.rhGameFlags = (short)(this.rhGameFlags | 0x10);
        }
        this.initAsmLoop();
        this.y_InitLevel();
        n = this.prepareFrame();
        if (n != 0) {
            return n;
        }
        n = this.createFrameObjects(bl);
        if (n != 0) {
            return n;
        }
        this.redrawLevel(null, 258);
        this.loadGlobalObjectsData();
        this.rhEvtProg.prepareProgram();
        this.rhEvtProg.assemblePrograms(this);
        this.captureMouse();
        this.rhQuitParam = 0;
        this.f_InitLoop();
        System.gc();
        return 0;
    }

    public int doRunLoop() {
        int n;
        this.rhApp.appRunFlags = (short)(this.rhApp.appRunFlags | 4);
        int n2 = this.f_GameLoop();
        this.rhApp.appRunFlags = (short)(this.rhApp.appRunFlags & 0xFFFFFFFB);
        if (this.rhApp.sysEvents.size() > 0) {
            for (n = 0; n < this.rhApp.sysEvents.size(); ++n) {
                CSysEvent cSysEvent = this.rhApp.sysEvents.get(n);
                if (cSysEvent == null) continue;
                cSysEvent.execute(this);
            }
            this.rhApp.sysEvents.clear();
        }
        if ((this.rhGameFlags & 0x10) != 0) {
            this.f_RemoveObjects();
            this.rhFrame.fadeTimerDelta = System.currentTimeMillis() - this.rhTimerOld;
            this.rhFrame.fadeVblDelta = this.rhApp.newGetCptVbl() - this.rhVBLOld;
            this.y_KillLevel(true);
            this.rhEvtProg.unBranchPrograms();
        }
        if (this.rh4SaveFrame == 8) {
            this.rh4SaveFrame = 0;
            if (!this.rhFrame.fade) {
                this.saveFramePosition(null);
            }
        }
        if (n2 != 0) {
            n = 0;
            switch (n2) {
                case 5: {
                    this.rhQuit = 0;
                    this.pause();
                    n2 = 0;
                    break;
                }
                case 7: {
                    n = this.loadApplicationPosition(null);
                    if (n < 0) break;
                    if (n != this.rhApp.currentFrame) {
                        n2 = 3;
                        this.rhQuit = (short)n2;
                        this.rhQuitParam = n |= 0x8000;
                        break;
                    }
                }
                case 9: {
                    this.rhQuit = 0;
                    n2 = 0;
                    n = 0;
                    if (this.loadFramePosition(null)) break;
                }
                case 101: {
                    if (this.rhFrame.fade) break;
                    this.f_StopSamples();
                    this.f_StopMusics();
                    this.killFrameObjects();
                    this.y_KillLevel(false);
                    this.rhEvtProg.unBranchPrograms();
                    this.freeMouse();
                    this.freeRunHeader();
                    this.rhFrame.leLastScrlX = 0;
                    this.rhFrame.leX = 0;
                    this.rhFrame.leLastScrlY = 0;
                    this.rhFrame.leY = 0;
                    this.allocRunHeader();
                    this.initAsmLoop();
                    this.y_InitLevel();
                    this.redrawLevel(null, 10);
                    this.prepareFrame();
                    this.createFrameObjects(false);
                    this.loadGlobalObjectsData();
                    this.rhEvtProg.prepareProgram();
                    this.rhEvtProg.assemblePrograms(this);
                    this.f_InitLoop();
                    this.captureMouse();
                    n2 = 0;
                    this.rhQuitParam = 0;
                    break;
                }
                case -2: 
                case 100: {
                    this.rhEvtProg.handle_GlobalEvents(-196611);
                    break;
                }
                case 102: {
                    this.appletPause();
                    n2 = this.rhQuit;
                }
            }
        }
        return n2;
    }

    public void appletPause() {
        this.pause();
        do {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.rhQuit == 102);
        this.resume();
    }

    public int killRunLoop(int n, boolean bl) {
        if (n > 100) {
            n = -2;
        }
        int n2 = this.rhQuitParam;
        this.saveGlobalObjectsData();
        this.killFrameObjects();
        this.y_KillLevel(bl);
        this.rhEvtProg.unBranchPrograms();
        this.freeMouse();
        this.freeRunHeader();
        return CServices.MAKELONG(n, n2);
    }

    public void y_InitLevel() {
        this.resetFrameLayers(-1, false);
    }

    public void initAsmLoop() {
        if (this.rh3Panic == 0) {
            this.spriteGen.winSetColMode((short)1);
            this.f_ObjMem_Init();
        }
    }

    public void f_ObjMem_Init() {
        for (int i = 0; i < this.rhMaxObjects; ++i) {
            this.rhObjectList[i] = null;
        }
    }

    public int prepareFrame() {
        this.rhGameFlags = (this.rhApp.gaFlags & 8) != 0 && !this.rhFrame.fade ? (short)(this.rhGameFlags | 2) : (short)(this.rhGameFlags & 0xFFFFFFFD);
        this.rhGameFlags = (short)(this.rhGameFlags | 0x20);
        this.rhGameFlags = (short)(this.rhGameFlags | 0x200);
        this.rh2CreationCount = 0;
        int n = 0;
        this.rhOiList = new CObjInfo[this.rhMaxOI];
        COI cOI = this.rhApp.OIList.getFirstOI();
        while (cOI != null) {
            short s = cOI.oiType;
            if (s >= 2) {
                this.rhOiList[n] = new CObjInfo();
                this.rhOiList[n].copyData(cOI);
                this.rhOiList[n].oilHFII = (short)-1;
                if (s == 3 || s == 4) {
                    CLO cLO = this.rhFrame.LOList.first_LevObj();
                    while (cLO != null) {
                        if (cLO.loOiHandle == this.rhOiList[n].oilOi) {
                            this.rhOiList[n].oilHFII = cLO.loHandle;
                            break;
                        }
                        cLO = this.rhFrame.LOList.next_LevObj();
                    }
                }
                ++n;
                CObjectCommon cObjectCommon = (CObjectCommon)cOI.oiOC;
                if ((cObjectCommon.ocOEFlags & 0x10) != 0 && cObjectCommon.ocMovements != null) {
                    for (int n2 = 0; n2 < cObjectCommon.ocMovements.nMovements; n2 = (int)((short)(n2 + 1))) {
                        CMoveDef cMoveDef = cObjectCommon.ocMovements.moveList[n2];
                        if (cMoveDef.mvType != 1) continue;
                        this.rhMouseUsed = (byte)(this.rhMouseUsed | 1 << cMoveDef.mvControl - 1);
                    }
                }
            }
            cOI = this.rhApp.OIList.getNextOI();
        }
        for (int i = 0; i < this.rhFrame.nLayers; ++i) {
            CLayer cLayer = this.rhFrame.layers[i];
            cLayer.nZOrderMax = 1;
        }
        return 0;
    }

    public int createFrameObjects(boolean bl) {
        int n = 0;
        int n2 = 0;
        CLO cLO = this.rhFrame.LOList.first_LevObj();
        while (cLO != null) {
            block6: {
                short s;
                short s2;
                CObjectCommon cObjectCommon;
                block7: {
                    COI cOI = this.rhApp.OIList.getOIFromHandle(cLO.loOiHandle);
                    cObjectCommon = (CObjectCommon)cOI.oiOC;
                    s2 = cOI.oiType;
                    s = 0;
                    if (cLO.loParentType != 0) break block6;
                    if (s2 == 3) {
                        s = (short)(s | 4);
                    }
                    if ((cObjectCommon.ocFlags2 & 8) != 0) break block7;
                    if (s2 == 4) break block6;
                    s = (short)(s | 2);
                }
                if (!(bl && s2 >= 32 && (cObjectCommon.ocOEFlags & 8) == 0 || (cObjectCommon.ocOEFlags & 0x20000) != 0)) {
                    this.f_CreateObject(cLO.loHandle, cLO.loOiHandle, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, s, -1, -1);
                }
            }
            ++n2;
            cLO = this.rhFrame.LOList.next_LevObj();
        }
        this.rhGameFlags = (short)(this.rhGameFlags & 0xFFFFFDFF);
        return n;
    }

    public void createRemainingFrameObjects() {
        boolean bl = false;
        this.rhGameFlags = (short)(this.rhGameFlags & 0xFFFFFFEF);
        this.redrawLevel(null, 258);
        this.F_ReInitObjects();
        int n = 0;
        CLO cLO = this.rhFrame.LOList.first_LevObj();
        while (cLO != null) {
            block5: {
                short s;
                CObjectCommon cObjectCommon;
                block6: {
                    COI cOI = this.rhApp.OIList.getOIFromHandle(cLO.loOiHandle);
                    cObjectCommon = (CObjectCommon)cOI.oiOC;
                    short s2 = cOI.oiType;
                    if (s2 < 32 || (cObjectCommon.ocOEFlags & 8) != 0) break block5;
                    s = 0;
                    if (cLO.loParentType != 0) break block5;
                    if ((cObjectCommon.ocFlags2 & 8) != 0) break block6;
                    if (s2 != 3) break block5;
                    s = (short)(s | 2);
                }
                if ((cObjectCommon.ocOEFlags & 0x20000) == 0) {
                    this.f_CreateObject(cLO.loHandle, cLO.loOiHandle, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, s, -1, -1);
                }
            }
            ++n;
            cLO = this.rhFrame.LOList.next_LevObj();
        }
        this.rhEvtProg.assemblePrograms(this);
        this.rhTimerOld = System.currentTimeMillis() - this.rhFrame.fadeTimerDelta;
        this.rhVBLOld = this.rhApp.newGetCptVbl() - this.rhFrame.fadeVblDelta;
    }

    public void F_ReInitObjects() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if (cObject.ros == null) continue;
            cObject.ros.reInit_Spr(false);
        }
    }

    public void killFrameObjects() {
        for (int n = 0; n < this.rhMaxObjects && this.rhNObjects != 0; n = (int)((short)(n + 1))) {
            this.f_KillObject(n, true);
        }
        this.rh4FirstQuickDisplay = Short.MIN_VALUE;
    }

    public void y_KillLevel(boolean bl) {
        this.resetFrameLayers(-1, false);
        if (!bl) {
            if ((this.rhApp.gaNewFlags & 1) == 0) {
                this.rhApp.soundPlayer.stopAllSounds();
                this.rhApp.musicPlayer.stop();
            } else {
                this.rhApp.soundPlayer.keepCurrentSounds();
                this.rhApp.musicPlayer.keepCurrentMusic();
            }
        }
    }

    public void resetFrameLayers(int n, boolean bl) {
        int n2;
        int n3;
        if (n == -1) {
            n3 = 0;
            n2 = this.rhFrame.nLayers;
        } else {
            n3 = n;
            n2 = n + 1;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            CLayer cLayer = this.rhFrame.layers[n3];
            if (n3 != 0) {
                int n4;
                int n5 = cLayer.nBkdLOs;
                for (n4 = 0; n4 < n5; ++n4) {
                    CLO cLO = this.rhFrame.LOList.getLOFromIndex((short)(cLayer.nFirstLOIndex + n4));
                    for (int i = 0; i < 4; ++i) {
                        if (cLO.loSpr[i] == null) continue;
                        this.spriteGen.delSpriteFast(cLO.loSpr[i]);
                        cLO.loSpr[i] = null;
                    }
                }
                if (cLayer.pBkd2 != null) {
                    for (n4 = 0; n4 < cLayer.pBkd2.size(); ++n4) {
                        CBkd2 cBkd2 = cLayer.pBkd2.get(n4);
                        for (int i = 0; i < 4; ++i) {
                            if (cBkd2.pSpr[i] == null) continue;
                            this.spriteGen.delSpriteFast(cBkd2.pSpr[i]);
                            cBkd2.pSpr[i] = null;
                        }
                    }
                }
            }
            cLayer.dwOptions = cLayer.backUp_dwOptions;
            cLayer.xCoef = cLayer.backUp_xCoef;
            cLayer.yCoef = cLayer.backUp_yCoef;
            cLayer.nBkdLOs = cLayer.backUp_nBkdLOs;
            cLayer.nFirstLOIndex = cLayer.backUp_nFirstLOIndex;
            cLayer.dy = 0;
            cLayer.dx = 0;
            cLayer.y = 0;
            cLayer.x = 0;
            cLayer.pBkd2 = null;
            cLayer.pLadders = null;
        }
    }

    void f_RemoveObjects() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if (cObject.ros != null && cObject.roc.rcSprite != null) {
                cObject.ros.rsZOrder = cObject.roc.rcSprite.sprZOrder;
                this.spriteGen.delSpriteFast(cObject.roc.rcSprite);
            }
            cObject.killBack();
            if ((cObject.hoOEFlags & 0x1000) == 0) continue;
            this.remove_QuickDisplay(cObject);
        }
    }

    public void captureMouse() {
        if (this.rhMouseUsed != 0) {
            this.rh2MouseSaveX = this.rhApp.mouseX;
            this.rh2MouseSaveY = this.rhApp.mouseY;
            this.setCursorCount(-1);
        }
    }

    public void freeMouse() {
        if (this.rhMouseUsed != 0) {
            this.setCursorCount(0);
            this.rhApp.setCursorPos(this.rh2MouseSaveX, this.rh2MouseSaveY);
        }
    }

    public void setCursorCount(int n) {
        short s = n >= 0 ? this.rhApp.showCursor(true) : this.rhApp.showCursor(false);
        while (s > n) {
            s = this.rhApp.showCursor(false);
        }
        while (s < n) {
            s = this.rhApp.showCursor(true);
        }
        this.rh4CursorCount = s;
    }

    public void showMouse() {
        short s;
        while ((s = this.rhApp.showCursor(true)) < 0) {
        }
        this.rh4CursorCount = s;
    }

    public void hideMouse() {
        short s;
        while ((s = this.rhApp.showCursor(false)) > -1) {
        }
        this.rh4CursorCount = s;
    }

    public void saveGlobalObjectsData() {
        for (int i = 0; i < this.rhOiList.length; ++i) {
            CObjInfo cObjInfo = this.rhOiList[i];
            short s = cObjInfo.oilObject;
            if (cObjInfo.oilOi == Short.MAX_VALUE || (s & 0x8000) != 0) continue;
            COI cOI = this.rhApp.OIList.getOIFromHandle(cObjInfo.oilOi);
            if ((cOI.oiFlags & 4) == 0) continue;
            CObject cObject = this.rhObjectList[s];
            if (cObjInfo.oilType != 3 && cObjInfo.oilType != 7 && cObject.rov == null) continue;
            String string = String.format("%s::%d", cObjInfo.oilName, cObjInfo.oilType);
            if (this.rhApp.adGO == null) {
                this.rhApp.adGO = new ArrayList();
            }
            boolean bl = false;
            CSaveGlobal cSaveGlobal = null;
            for (int j = 0; j < this.rhApp.adGO.size(); ++j) {
                cSaveGlobal = this.rhApp.adGO.get(j);
                if (string.compareTo(cSaveGlobal.name) != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                cSaveGlobal = new CSaveGlobal();
                cSaveGlobal.name = string;
                cSaveGlobal.objects = new ArrayList();
                this.rhApp.adGO.add(cSaveGlobal);
            } else {
                cSaveGlobal.objects.clear();
            }
            do {
                int n;
                Object object;
                Object object2;
                cObject = this.rhObjectList[s];
                if (cObjInfo.oilType == 3) {
                    object2 = (CText)cObject;
                    object = new CSaveGlobalText();
                    ((CSaveGlobalText)object).text = ((CText)object2).rsTextBuffer;
                    ((CSaveGlobalText)object).rsMini = ((CText)object2).rsMini;
                    cSaveGlobal.objects.add(object);
                    continue;
                }
                if (cObjInfo.oilType == 7) {
                    object2 = (CCounter)cObject;
                    object = new CSaveGlobalCounter();
                    ((CSaveGlobalCounter)object).value = new CValue(((CCounter)object2).rsValue);
                    ((CSaveGlobalCounter)object).rsMini = ((CCounter)object2).rsMini;
                    ((CSaveGlobalCounter)object).rsMaxi = ((CCounter)object2).rsMaxi;
                    ((CSaveGlobalCounter)object).rsMiniDouble = ((CCounter)object2).rsMiniDouble;
                    ((CSaveGlobalCounter)object).rsMaxiDouble = ((CCounter)object2).rsMaxiDouble;
                    cSaveGlobal.objects.add(object);
                    continue;
                }
                object2 = new CSaveGlobalValues();
                ((CSaveGlobalValues)object2).flags = cObject.rov.rvValueFlags;
                ((CSaveGlobalValues)object2).values = new CValue[26];
                for (n = 0; n < 26; ++n) {
                    ((CSaveGlobalValues)object2).values[n] = null;
                    if (cObject.rov.rvValues[n] == null) continue;
                    ((CSaveGlobalValues)object2).values[n] = new CValue(cObject.rov.rvValues[n]);
                }
                ((CSaveGlobalValues)object2).strings = new String[10];
                for (n = 0; n < 10; ++n) {
                    ((CSaveGlobalValues)object2).strings[n] = null;
                    if (cObject.rov.rvStrings[n] == null) continue;
                    ((CSaveGlobalValues)object2).strings[n] = new String(cObject.rov.rvStrings[n]);
                }
                cSaveGlobal.objects.add(object2);
            } while (((s = cObject.hoNumNext) & 0x8000) == 0);
        }
    }

    public void loadGlobalObjectsData() {
        if (this.rhApp.adGO == null) {
            return;
        }
        block0: for (int i = 0; i < this.rhOiList.length; ++i) {
            CObjInfo cObjInfo = this.rhOiList[i];
            short s = cObjInfo.oilObject;
            if (cObjInfo.oilOi == Short.MAX_VALUE || (s & 0x8000) != 0) continue;
            COI cOI = this.rhApp.OIList.getOIFromHandle(cObjInfo.oilOi);
            if ((cOI.oiFlags & 4) == 0) continue;
            String string = String.format("%s::%d", cObjInfo.oilName, cObjInfo.oilType);
            for (int j = 0; j < this.rhApp.adGO.size(); ++j) {
                CObject cObject;
                CSaveGlobal cSaveGlobal = this.rhApp.adGO.get(j);
                if (string.compareTo(cSaveGlobal.name) != 0) continue;
                int n = 0;
                do {
                    int n2;
                    Object object;
                    cObject = this.rhObjectList[s];
                    if (cObjInfo.oilType == 3) {
                        object = (CSaveGlobalText)cSaveGlobal.objects.get(n);
                        CText cText = (CText)cObject;
                        cText.rsTextBuffer = ((CSaveGlobalText)object).text;
                        cText.rsMini = ((CSaveGlobalText)object).rsMini;
                        continue;
                    }
                    if (cObjInfo.oilType == 7) {
                        object = (CSaveGlobalCounter)cSaveGlobal.objects.get(n);
                        CCounter cCounter = (CCounter)cObject;
                        cCounter.rsValue = new CValue(((CSaveGlobalCounter)object).value);
                        cCounter.rsMini = ((CSaveGlobalCounter)object).rsMini;
                        cCounter.rsMaxi = ((CSaveGlobalCounter)object).rsMaxi;
                        cCounter.rsMiniDouble = ((CSaveGlobalCounter)object).rsMiniDouble;
                        cCounter.rsMaxiDouble = ((CSaveGlobalCounter)object).rsMaxiDouble;
                        continue;
                    }
                    object = (CSaveGlobalValues)cSaveGlobal.objects.get(n);
                    cObject.rov.rvValueFlags = ((CSaveGlobalValues)object).flags;
                    for (n2 = 0; n2 < 26; ++n2) {
                        if (((CSaveGlobalValues)object).values[n2] == null) continue;
                        cObject.rov.rvValues[n2] = new CValue(((CSaveGlobalValues)object).values[n2]);
                    }
                    for (n2 = 0; n2 < 10; ++n2) {
                        if (((CSaveGlobalValues)object).strings[n2] == null) continue;
                        cObject.rov.rvStrings[n2] = new String(((CSaveGlobalValues)object).strings[n2]);
                    }
                } while (((s = cObject.hoNumNext) & 0x8000) == 0 && ++n < cSaveGlobal.objects.size());
                continue block0;
            }
        }
    }

    public int f_CreateObject(short s, short s2, int n, int n2, int n3, short s3, int n4, int n5) {
        CCreateObjectInfo cCreateObjectInfo = new CCreateObjectInfo();
        CLO cLO = null;
        if (s != -1) {
            cLO = this.rhFrame.LOList.getLOFromHandle(s);
        }
        COI cOI = this.rhApp.OIList.getOIFromHandle(s2);
        CObjectCommon cObjectCommon = (CObjectCommon)cOI.oiOC;
        if ((cObjectCommon.ocFlags2 & 8) == 0) {
            s3 = (short)(s3 | 2);
        }
        if (this.rhNObjects < this.rhMaxObjects) {
            CObject cObject = null;
            switch (cOI.oiType) {
                case 2: {
                    cObject = new CActive();
                    break;
                }
                case 3: {
                    cObject = new CText();
                    break;
                }
                case 4: {
                    cObject = new CQuestion();
                    break;
                }
                case 5: {
                    cObject = new CScore();
                    break;
                }
                case 6: {
                    cObject = new CLives();
                    break;
                }
                case 7: {
                    cObject = new CCounter();
                    break;
                }
                case 8: {
                    cObject = new CRtf();
                    break;
                }
                case 9: {
                    cObject = new CCCA();
                    break;
                }
                default: {
                    cObject = new CExtension(cOI.oiType, this);
                }
            }
            if (cObject != null) {
                if (n5 < 0) {
                    for (n5 = 0; n5 < this.rhMaxObjects && this.rhObjectList[n5] != null; ++n5) {
                    }
                }
                if (n5 >= this.rhMaxObjects) {
                    return -1;
                }
                this.rhObjectList[n5] = cObject;
                ++this.rhNObjects;
                cObject.hoIdentifier = cObjectCommon.ocIdentifier;
                cObject.hoOEFlags = cObjectCommon.ocOEFlags;
                if (n5 > this.rh4ObjectCurCreate) {
                    ++this.rh4ObjectAddCreate;
                }
                cObject.hoNumber = (short)n5;
                this.rh2CreationCount = (short)(this.rh2CreationCount + 1);
                if (this.rh2CreationCount == 0) {
                    this.rh2CreationCount = 1;
                }
                cObject.hoCreationId = this.rh2CreationCount;
                cObject.hoOi = s2;
                cObject.hoHFII = s;
                cObject.hoType = cOI.oiType;
                this.oi_Insert(cObject);
                cObject.hoAdRunHeader = this;
                cObject.hoCallRoutine = true;
                cObject.hoCommon = cObjectCommon;
                int n6 = n;
                if (n6 == Integer.MIN_VALUE) {
                    n6 = cLO.loX;
                }
                cCreateObjectInfo.cobX = n6;
                cObject.hoX = n6;
                int n7 = n2;
                if (n7 == Integer.MIN_VALUE) {
                    n7 = cLO.loY;
                }
                cCreateObjectInfo.cobY = n7;
                cObject.hoY = n7;
                if (cLO != null) {
                    if (n4 == -1) {
                        n4 = cLO.loLayer;
                    }
                } else {
                    n4 = 0;
                }
                cCreateObjectInfo.cobLayer = n4;
                cObject.hoLayer = n4;
                CLayer cLayer = this.rhFrame.layers[n4];
                ++cLayer.nZOrderMax;
                cCreateObjectInfo.cobZOrder = cLayer.nZOrderMax;
                cCreateObjectInfo.cobFlags = s3;
                cCreateObjectInfo.cobDir = n3;
                cCreateObjectInfo.cobLevObj = cLO;
                cObject.roc = null;
                if ((cObject.hoOEFlags & 0x230) != 0) {
                    cObject.roc = new CRCom();
                    cObject.roc.init();
                }
                cObject.rom = null;
                if ((cObject.hoOEFlags & 0x10) != 0) {
                    cObject.rom = new CRMvt();
                    if ((cCreateObjectInfo.cobFlags & 1) == 0) {
                        cObject.rom.init(0, cObject, cObjectCommon, cCreateObjectInfo, -1);
                    }
                }
                cObject.roa = null;
                if ((cObject.hoOEFlags & 0x20) != 0) {
                    cObject.roa = new CRAni();
                    cObject.roa.init(cObject);
                }
                cObject.ros = null;
                if ((cObject.hoOEFlags & 0x200) != 0) {
                    cObject.ros = new CRSpr();
                    cObject.ros.init1(cObject, cObjectCommon, cCreateObjectInfo);
                }
                cObject.rov = null;
                if ((cObject.hoOEFlags & 0x100) != 0) {
                    cObject.rov = new CRVal();
                    cObject.rov.init(cObject, cObjectCommon, cCreateObjectInfo);
                }
                cObject.init(cObjectCommon, cCreateObjectInfo);
                if ((cObject.hoOEFlags & 0x200) != 0) {
                    cObject.ros.init2();
                }
                return n5;
            }
        }
        return -1;
    }

    public void f_KillObject(int n, boolean bl) {
        CObject cObject = this.rhObjectList[n];
        if (cObject == null) {
            return;
        }
        if (bl && cObject.hoCreationId == 0) {
            this.rhObjectList[n] = null;
            --this.rhNObjects;
            return;
        }
        this.killShootPtr(cObject);
        if (cObject.rom != null) {
            cObject.rom.kill(bl);
        }
        if (cObject.rov != null) {
            cObject.rov.kill(bl);
        }
        if (cObject.ros != null) {
            cObject.ros.kill(bl);
        }
        if (cObject.roc != null) {
            cObject.roc.kill(bl);
        }
        cObject.kill(bl);
        this.oi_Delete(cObject);
        boolean bl2 = false;
        if ((cObject.hoOEFlags & 0x200) == 0) {
            bl2 = true;
        } else if (bl) {
            cObject.killBack();
            bl2 = true;
        } else if ((cObject.hoOEFlags & 0x1000) == 0) {
            if ((cObject.ros.rsCreaFlags & 0x2000) == 0) {
                bl2 = true;
            }
        } else if (cObject.hoNextQuickDisplay == -2 || cObject.hoNextQuickDisplay == -1) {
            cObject.hoNextQuickDisplay = (short)-1;
            this.display_OwnerQuickDisplay(cObject);
        }
        cObject.hoCreationId = 0;
        if (bl2) {
            if ((cObject.hoOEFlags & 0x1000) != 0) {
                this.remove_QuickDisplay(cObject);
            }
            this.rhObjectList[n] = null;
            --this.rhNObjects;
        }
        cObject.hoCallRoutine = false;
    }

    public void destroy_Add(int n) {
        int n2 = n / 32;
        this.rhDestroyList[n2] = this.rhDestroyList[n2] | 1 << (n & 0x1F);
        this.rhDestroyPos = (short)(this.rhDestroyPos + 1);
    }

    public void destroy_List() {
        if (this.rhDestroyPos == 0) {
            return;
        }
        for (int i = 0; i < this.rhMaxObjects; i += 32) {
            int n = this.rhDestroyList[i / 32];
            if (n == 0) continue;
            for (int j = 0; n != 0 && j < 32; n >>= 1, ++j) {
                if ((n & 1) == 0) continue;
                CObject cObject = this.rhObjectList[i + j];
                if (cObject != null && cObject.hoOiList.oilNObjects == 1) {
                    this.rhEvtProg.handle_Event(cObject, cObject.hoType | 0xFFDF0000);
                }
                this.f_KillObject(i + j, false);
                this.rhDestroyPos = (short)(this.rhDestroyPos - 1);
            }
            this.rhDestroyList[i / 32] = 0;
            if (this.rhDestroyPos != 0) continue;
            return;
        }
    }

    void killShootPtr(CObject cObject) {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject2 = this.rhObjectList[n];
            ++n;
            if (cObject2.rom == null || cObject2.roc.rcMovementType != 13) continue;
            CMoveBullet cMoveBullet = (CMoveBullet)cObject2.rom.rmMovement;
            if (cMoveBullet.MBul_ShootObject != cObject || !cMoveBullet.MBul_Wait) continue;
            cMoveBullet.startBullet();
        }
    }

    public void oi_Insert(CObject cObject) {
        int n;
        short s = cObject.hoOi;
        for (n = 0; n < this.rhMaxOI && this.rhOiList[n].oilOi != s; ++n) {
        }
        CObjInfo cObjInfo = this.rhOiList[n];
        if ((cObjInfo.oilObject & 0x8000) != 0) {
            cObjInfo.oilObject = cObject.hoNumber;
            cObject.hoNumPrev = (short)(n | 0x8000);
            cObject.hoNumNext = Short.MIN_VALUE;
        } else {
            CObject cObject2 = this.rhObjectList[cObjInfo.oilObject];
            cObject.hoNumPrev = cObject2.hoNumPrev;
            cObject2.hoNumPrev = cObject.hoNumber;
            cObject.hoNumNext = cObject2.hoNumber;
            cObjInfo.oilObject = cObject.hoNumber;
        }
        cObject.hoEvents = cObjInfo.oilEvents;
        cObject.hoOiList = cObjInfo;
        cObject.hoLimitFlags = cObjInfo.oilLimitFlags;
        if (cObject.hoHFII == -1) {
            cObject.hoHFII = cObjInfo.oilHFII;
        } else if (cObjInfo.oilHFII == -1) {
            cObjInfo.oilHFII = cObject.hoHFII;
        }
        ++cObjInfo.oilNObjects;
    }

    void oi_Delete(CObject cObject) {
        CObjInfo cObjInfo = cObject.hoOiList;
        --cObjInfo.oilNObjects;
        if (cObject.hoNumPrev >= 0) {
            CObject cObject2 = this.rhObjectList[cObject.hoNumPrev];
            if (cObject.hoNumNext >= 0) {
                CObject cObject3 = this.rhObjectList[cObject.hoNumNext];
                if (cObject2 != null) {
                    cObject2.hoNumNext = cObject.hoNumNext;
                }
                if (cObject3 != null) {
                    cObject3.hoNumPrev = cObject.hoNumPrev;
                }
            } else if (cObject2 != null) {
                cObject2.hoNumNext = Short.MIN_VALUE;
            }
        } else if (cObject.hoNumNext >= 0) {
            CObject cObject4 = this.rhObjectList[cObject.hoNumNext];
            if (cObject4 != null) {
                cObject4.hoNumPrev = cObject.hoNumPrev;
                cObjInfo.oilObject = cObject4.hoNumber;
            }
        } else {
            cObjInfo.oilObject = Short.MIN_VALUE;
        }
    }

    public void pause() {
        ++this.rh2PauseCompteur;
        if (this.rh2PauseCompteur == 1) {
            this.rh2PauseTimer = System.currentTimeMillis();
            this.rh2PauseVbl = this.rhApp.newGetCptVbl() - this.rhVBLOld;
            int n = 0;
            for (int i = 0; i < this.rhNObjects; ++i) {
                while (this.rhObjectList[n] == null) {
                    ++n;
                }
                CObject cObject = this.rhObjectList[n];
                ++n;
                if (cObject.hoType < 32) continue;
                CExtension cExtension = (CExtension)cObject;
                cExtension.ext.pauseRunObject();
            }
            this.rhApp.soundPlayer.pause();
            this.rhApp.musicPlayer.pause();
            short s = this.rh4CursorCount;
            if (this.rhMouseUsed != 0) {
                this.showMouse();
                this.rhApp.setCursorPos(this.rh2MouseSaveX, this.rh2MouseSaveY);
            } else if (this.rh4CursorCount < 0) {
                this.showMouse();
            }
            this.rh4CursorCount = s;
        }
    }

    public void resume() {
        if (this.rh2PauseCompteur != 0) {
            --this.rh2PauseCompteur;
            if (this.rh2PauseCompteur == 0) {
                short s = this.rh4CursorCount;
                if (this.rhMouseUsed != 0) {
                    this.rh2MouseSaveX = this.rhApp.mouseX;
                    this.rh2MouseSaveY = this.rhApp.mouseY;
                    this.hideMouse();
                    this.rhApp.setCursorPos(this.rh4MouseXCenter, this.rh4MouseYCenter);
                } else if (this.rh4CursorCount < 0) {
                    this.hideMouse();
                }
                this.rh4CursorCount = s;
                int n = 0;
                for (int i = 0; i < this.rhNObjects; ++i) {
                    while (this.rhObjectList[n] == null) {
                        ++n;
                    }
                    CObject cObject = this.rhObjectList[n];
                    ++n;
                    if (cObject.hoType < 32) continue;
                    CExtension cExtension = (CExtension)cObject;
                    cExtension.ext.continueRunObject();
                }
                this.rhApp.soundPlayer.resume();
                this.rhApp.musicPlayer.resume();
                this.rhApp.flushKeyboard();
                long l = System.currentTimeMillis();
                this.rhTimerOld += (l -= this.rh2PauseTimer);
                this.rhVBLOld = this.rhApp.newGetCptVbl() - this.rh2PauseVbl;
                this.rh4PauseKey = 0;
            }
        }
    }

    public void f_StopSamples() {
        this.rhApp.soundPlayer.stopAllSounds();
    }

    public void f_StopMusics() {
        this.rhApp.musicPlayer.stop();
    }

    /*
     * Unable to fully structure code
     */
    void redrawLevel(Graphics2D var1_1, int var2_2) {
        var10_3 = 0;
        var11_4 = false;
        var14_5 = null;
        var17_6 = (this.rhFrame.leFlags & 32) != 0;
        var18_7 = (var2_2 & 16) == 0;
        var19_8 = (var2_2 & 64) != 0;
        var20_9 = new CRect();
        var22_10 = false;
        var23_11 = false;
        if (var1_1 == null) {
            var1_1 = this.rhApp.editWin.createGraphics();
            if (var1_1 == null) {
                return;
            }
            var23_11 = true;
        }
        var20_9.top = 0;
        var20_9.left = 0;
        var20_9.right = this.rhFrame.leEditWinWidth;
        var20_9.bottom = this.rhFrame.leEditWinHeight;
        var3_12 = var20_9.right;
        var8_13 = var3_12 - 1;
        var4_14 = var20_9.bottom;
        var9_15 = var4_14 - 1;
        if ((var2_2 & 268) != 0) {
            for (var21_16 = 0; var21_16 < this.rhFrame.nLayers; ++var21_16) {
                var24_17 = this.rhFrame.layers[var21_16];
                if ((var24_17.dwOptions & 262144) != 0) {
                    this.f_ShowAllObjects(var21_16, true);
                }
                if ((var24_17.dwOptions & 131072) == 0) continue;
                this.f_ShowAllObjects(var21_16, false);
            }
        }
        if (!var19_8 && (var2_2 & 128) != 0) {
            var24_17 = this.rhFrame.layers[0];
            if ((var24_17.dwOptions & 65536) == 0) {
                var19_8 = true;
            }
        }
        for (var21_16 = 1; var21_16 < this.rhFrame.nLayers; ++var21_16) {
            var24_17 = this.rhFrame.layers[var21_16];
            if ((var24_17.dwOptions & 131072) == 0) continue;
            var25_21 = var24_17.nBkdLOs;
            for (var5_19 = 0; var5_19 < var25_21; ++var5_19) {
                var13_20 = this.rhFrame.LOList.getLOFromIndex((short)(var24_17.nFirstLOIndex + var5_19));
                for (var26_22 = 0; var26_22 < 4; ++var26_22) {
                    if (var13_20.loSpr[var26_22] == null) continue;
                    this.spriteGen.delSprite(var13_20.loSpr[var26_22]);
                    var13_20.loSpr[var26_22] = null;
                }
            }
        }
        if ((var2_2 & 4) != 0) {
            if ((var2_2 & 128) != 0) {
                this.spriteGen.activeSprite(null, 1, null);
            }
            this.f_UpdateWindowPos(var1_1, this.rhFrame.leX, this.rhFrame.leY);
            this.spriteGen.activeSprite(null, 1, null);
        }
        if (!var19_8) {
            if ((this.rhFrame.leFlags & 2) != 0) {
                if ((var2_2 & 8) != 0) {
                    this.grabDesktop(var1_1);
                }
            } else if ((this.rhFrame.leFlags & 4) == 0 && ((this.rhFrame.layers[0].dwOptions & 32) != 0 || this.rhFrame.leX + var3_12 >= 0 && this.rhFrame.leX < this.rhFrame.leVirtualRect.right) && ((this.rhFrame.layers[0].dwOptions & 64) != 0 || this.rhFrame.leY + var4_14 >= 0 && this.rhFrame.leY < this.rhFrame.leVirtualRect.bottom)) {
                var1_1.setComposite(AlphaComposite.Src);
                var24_17 = new Color(this.rhFrame.leBackground);
                var1_1.setColor((Color)var24_17);
                var1_1.fillRect(0, 0, var3_12, var4_14);
            }
        }
        var1_1.setComposite(AlphaComposite.SrcOver);
        if (var18_7 && !var19_8) {
            if (var17_6 && this.rhFrame.colMask != null) {
                this.rhFrame.colMask.setOrigin(0, 0);
            }
            if ((var2_2 & 32) == 0) {
                if (this.rhFrame.colMask != null) {
                    this.rhFrame.colMask.fill((short)0);
                }
            } else if (this.rhFrame.colMask != null) {
                this.rhFrame.colMask.fillRectangle(-32767, -32767, 32767, 32767, 0);
            }
            var11_4 = true;
        }
        var24_18 = this.rhFrame.leWidth;
        var25_21 = this.rhFrame.leHeight;
        var21_16 = 0;
        if (var19_8) {
            ++var21_16;
        }
        while (var21_16 < this.rhFrame.nLayers) {
            block117: {
                block118: {
                    block116: {
                        var26_24 = this.rhFrame.layers[var21_16];
                        var26_24.x += var26_24.dx;
                        var26_24.y += var26_24.dy;
                        var26_24.dx = 0;
                        var26_24.dy = 0;
                        if ((var26_24.dwOptions & 262144) != 0) {
                            var26_24.dwOptions |= 16;
                        }
                        if ((var26_24.dwOptions & 16) != 0) break block116;
                        if (var21_16 != 0 || !var18_7) break block117;
                        var22_10 = true;
                    }
                    if ((var2_2 & 128) != 0 && (var26_24.dwOptions & 65536) == 0) break block117;
                    var26_24.dwOptions &= -65537;
                    var27_31 = (var26_24.dwOptions & 32) != 0;
                    var28_32 = (var26_24.dwOptions & 64) != 0;
                    var29_33 = var27_31 | var28_32;
                    var15_29 = this.rhFrame.leX;
                    var16_30 = this.rhFrame.leY;
                    if ((var26_24.dwOptions & 3) != 0) {
                        if ((var26_24.dwOptions & 1) != 0) {
                            var15_29 = (int)((float)var15_29 * var26_24.xCoef);
                        }
                        if ((var26_24.dwOptions & 2) != 0) {
                            var16_30 = (int)((float)var16_30 * var26_24.yCoef);
                        }
                    }
                    var15_29 += var26_24.x;
                    var16_30 += var26_24.y;
                    if (var27_31) {
                        var15_29 %= var24_18;
                    }
                    if (var28_32) {
                        var16_30 %= var25_21;
                    }
                    this.y_Ladder_Reset(var21_16);
                    var30_34 = var26_24.nBkdLOs;
                    if ((var26_24.dwOptions & 131072) != 0 && var21_16 <= 0) {
                        var22_10 = true;
                    }
                    if ((var26_24.dwOptions & 131072) != 0 && var21_16 != 0) break block118;
                    v0 = var31_35 = (var26_24.dwOptions & 4) == 0;
                    if ((var26_24.dwOptions & 262144) != 0) {
                        var26_24.dwOptions &= -262145;
                    }
                    var32_36 = 0;
                    var33_37 = 0;
                    for (var5_19 = 0; var5_19 < var30_34; ++var5_19) {
                        block122: {
                            block128: {
                                block129: {
                                    block127: {
                                        block125: {
                                            block126: {
                                                block124: {
                                                    block120: {
                                                        block123: {
                                                            block121: {
                                                                block119: {
                                                                    var13_20 = this.rhFrame.LOList.getLOFromIndex((short)(var26_24.nFirstLOIndex + var5_19));
                                                                    var34_38 = true;
                                                                    var35_39 = var33_37;
                                                                    var36_40 = null;
                                                                    var37_41 = null;
                                                                    var39_43 = var13_20.loType;
                                                                    if (var39_43 >= 2) break block119;
                                                                    var20_9.left = var13_20.loX - var15_29;
                                                                    var20_9.top = var13_20.loY - var16_30;
                                                                    break block120;
                                                                }
                                                                var36_40 = this.rhApp.OIList.getOIFromHandle(var13_20.loOiHandle);
                                                                if (var36_40 != null && var36_40.oiOC != null) break block121;
                                                                var32_36 = 0;
                                                                var33_37 = 0;
                                                                break block122;
                                                            }
                                                            var37_41 = var36_40.oiOC;
                                                            var38_42 = (CObjectCommon)var37_41;
                                                            if ((var38_42.ocOEFlags & 2) != 0 && (var14_5 = this.find_HeaderObject(var13_20.loHandle)) != null) break block123;
                                                            var32_36 = 0;
                                                            var33_37 = 0;
                                                            break block122;
                                                        }
                                                        var20_9.left = var14_5.hoX - this.rhFrame.leX - var14_5.hoImgXSpot;
                                                        var20_9.top = var14_5.hoY - this.rhFrame.leY - var14_5.hoImgYSpot;
                                                    }
                                                    if (var17_6 || var29_33 || var20_9.left < var8_13 + 64 + 32 && var20_9.top < var9_15 + 16) break block124;
                                                    var32_36 = 0;
                                                    var33_37 = 0;
                                                    break block122;
                                                }
                                                var7_27 = 0;
                                                var40_44 = null;
                                                var41_45 = null;
                                                if (var39_43 >= 2) break block125;
                                                var36_40 = this.rhApp.OIList.getOIFromHandle(var13_20.loOiHandle);
                                                if (var36_40 != null && var36_40.oiOC != null) break block126;
                                                var32_36 = 0;
                                                var33_37 = 0;
                                                break block122;
                                            }
                                            var37_41 = var36_40.oiOC;
                                            if (var39_43 == 0) {
                                                var40_44 = (COCQBackdrop)var37_41;
                                                var20_9.right = var20_9.left + var40_44.ocCx;
                                                var20_9.bottom = var20_9.top + var40_44.ocCy;
                                                var7_27 = var40_44.ocObstacleType;
                                                var10_3 = var40_44.ocColMode;
                                            } else if (var39_43 == 1) {
                                                var41_45 = (COCBackground)var37_41;
                                                var20_9.right = var20_9.left + var41_45.ocCx;
                                                var20_9.bottom = var20_9.top + var41_45.ocCy;
                                                var7_27 = var41_45.ocObstacleType;
                                                var10_3 = var41_45.ocColMode;
                                            }
                                            break block127;
                                        }
                                        var20_9.right = var20_9.left + var14_5.hoImgWidth;
                                        var20_9.bottom = var20_9.top + var14_5.hoImgHeight;
                                        var38_42 = (CObjectCommon)var37_41;
                                        var7_27 = (var38_42.ocFlags2 & 48) >> 4;
                                        v1 = var10_3 = (var38_42.ocFlags2 & 4) != 0 ? 1 : 0;
                                    }
                                    if (var29_33) {
                                        switch (var33_37) {
                                            case 0: {
                                                if (var27_31 && (var20_9.left < 0 || var20_9.right > var24_18)) {
                                                    if (var28_32 && (var20_9.top < 0 || var20_9.bottom > var25_21)) {
                                                        var33_37 = 3;
                                                        var32_36 |= 7;
                                                    } else {
                                                        var33_37 = 1;
                                                        var32_36 |= 1;
                                                    }
                                                } else if (var28_32 && (var20_9.top < 0 || var20_9.bottom > var25_21)) {
                                                    var33_37 = 2;
                                                    var32_36 |= 2;
                                                }
                                                if (!(var32_36 & true) && var13_20.loSpr[1] != null) {
                                                    this.spriteGen.delSprite(var13_20.loSpr[1]);
                                                    var13_20.loSpr[1] = null;
                                                }
                                                if ((var32_36 & 2) == 0 && var13_20.loSpr[2] != null) {
                                                    this.spriteGen.delSprite(var13_20.loSpr[2]);
                                                    var13_20.loSpr[2] = null;
                                                }
                                                if ((var32_36 & 4) != 0 || var13_20.loSpr[3] == null) break;
                                                this.spriteGen.delSprite(var13_20.loSpr[3]);
                                                var13_20.loSpr[3] = null;
                                                break;
                                            }
                                            case 1: {
                                                if (var20_9.left < 0) {
                                                    var42_46 = var24_18;
                                                    var20_9.left += var42_46;
                                                    var20_9.right += var42_46;
                                                } else if (var20_9.right > var24_18) {
                                                    var42_47 = var24_18;
                                                    var20_9.left -= var42_47;
                                                    var20_9.right -= var42_47;
                                                }
                                                var33_37 = 0;
                                                if (((var32_36 &= -2) & 2) == 0) break;
                                                var33_37 = 2;
                                                break;
                                            }
                                            case 2: {
                                                if (var20_9.top < 0) {
                                                    var42_48 = var25_21;
                                                    var20_9.top += var42_48;
                                                    var20_9.bottom += var42_48;
                                                } else if (var20_9.bottom > var25_21) {
                                                    var42_49 = var25_21;
                                                    var20_9.top -= var42_49;
                                                    var20_9.bottom -= var42_49;
                                                }
                                                var33_37 = 0;
                                                if (((var32_36 &= -3) & 1) == 0) break;
                                                var33_37 = 1;
                                                break;
                                            }
                                            case 3: {
                                                if (var20_9.left < 0) {
                                                    var42_50 = var24_18;
                                                    var20_9.left += var42_50;
                                                    var20_9.right += var42_50;
                                                } else if (var20_9.right > var24_18) {
                                                    var42_51 = var24_18;
                                                    var20_9.left -= var42_51;
                                                    var20_9.right -= var42_51;
                                                }
                                                if (var20_9.top < 0) {
                                                    var42_52 = var25_21;
                                                    var20_9.top += var42_52;
                                                    var20_9.bottom += var42_52;
                                                } else if (var20_9.bottom > var25_21) {
                                                    var42_53 = var25_21;
                                                    var20_9.top -= var42_53;
                                                    var20_9.bottom -= var42_53;
                                                }
                                                var32_36 &= -5;
                                                var33_37 = 2;
                                            }
                                        }
                                    }
                                    if (var7_27 == 3) {
                                        this.y_Ladder_Add(var21_16, var20_9.left, var20_9.top, var20_9.right, var20_9.bottom);
                                        var10_3 = 1;
                                    }
                                    if (var21_16 == 0 && var18_7 && var7_27 != 4 && (var17_6 || var20_9.right >= -96 && var20_9.bottom >= -16)) {
                                        var42_54 = null;
                                        if (var17_6) {
                                            var20_9.left += var15_29;
                                            var20_9.top += var16_30;
                                            var20_9.right += var15_29;
                                            var20_9.bottom += var16_30;
                                        }
                                        var6_26 = 0;
                                        if (var7_27 == 1) {
                                            var6_26 = 3;
                                            var11_4 = false;
                                        }
                                        if (!var11_4) {
                                            if (var10_3 != 0) {
                                                this.rhFrame.colMask.fillRectangle(var20_9.left, var20_9.top, var20_9.right, var20_9.bottom, var6_26);
                                            } else {
                                                if (var42_54 == null) {
                                                    if (var39_43 < 2) {
                                                        var12_28 = ((COCBackground)var37_41).ocImage;
                                                        var43_57 = this.rhApp.imageBank.getImageFromHandle(var12_28);
                                                        var42_54 = var43_57.getMask(CMask.GCMF_OBSTACLE);
                                                    } else {
                                                        var42_54 = var14_5.getCollisionMask(CMask.GCMF_OBSTACLE);
                                                    }
                                                }
                                                if (var42_54 == null) {
                                                    this.rhFrame.colMask.fillRectangle(var20_9.left, var20_9.top, var20_9.right, var20_9.bottom, var6_26);
                                                } else {
                                                    this.rhFrame.colMask.orMask(var42_54, var20_9.left, var20_9.top, 3, var6_26);
                                                }
                                            }
                                        }
                                        if (var7_27 == 2) {
                                            var11_4 = false;
                                            if (var10_3 != 0) {
                                                this.rhFrame.colMask.fillRectangle(var20_9.left, var20_9.top, var20_9.right, Math.min(var20_9.top + CColMask.HEIGHT_PLATFORM, var20_9.bottom), 2);
                                            } else {
                                                if (var42_54 == null) {
                                                    if (var39_43 < 2) {
                                                        var12_28 = ((COCBackground)var37_41).ocImage;
                                                        var43_57 = this.rhApp.imageBank.getImageFromHandle(var12_28);
                                                        var42_54 = var43_57.getMask(CMask.GCMF_OBSTACLE);
                                                    } else {
                                                        var42_54 = var14_5.getCollisionMask(CMask.GCMF_OBSTACLE);
                                                    }
                                                }
                                                if (var42_54 == null) {
                                                    this.rhFrame.colMask.fillRectangle(var20_9.left, var20_9.top, var20_9.right, Math.min(var20_9.top + CColMask.HEIGHT_PLATFORM, var20_9.bottom), 2);
                                                } else {
                                                    this.rhFrame.colMask.orPlatformMask(var42_54, var20_9.left, var20_9.top);
                                                }
                                            }
                                        }
                                        if (var17_6) {
                                            var20_9.left -= var15_29;
                                            var20_9.top -= var16_30;
                                            var20_9.right -= var15_29;
                                            var20_9.bottom -= var16_30;
                                        }
                                    }
                                    if (var20_9.left > var8_13 || var20_9.top > var9_15 || var20_9.right < 0 || var20_9.bottom < 0) break block122;
                                    var34_38 = false;
                                    if (var21_16 <= 0) break block128;
                                    var42_55 = 0x480008;
                                    if (!var31_35) {
                                        var42_55 |= 512;
                                    }
                                    switch (var7_27) {
                                        case 1: {
                                            var42_55 |= 65537;
                                            break;
                                        }
                                        case 2: {
                                            var42_55 |= 131073;
                                        }
                                    }
                                    if (var13_20.loSpr[var33_37] != null) break block129;
                                    switch (var39_43) {
                                        case 0: {
                                            var13_20.loSpr[var33_37] = this.spriteGen.addOwnerDrawSprite(var20_9.left, var20_9.top, var20_9.right, var20_9.bottom, var13_20.loLayer, var5_19 * 4 + var35_39, 0, var42_55 | 256, null, var40_44);
                                            break;
                                        }
                                        case 1: {
                                            var13_20.loSpr[var33_37] = this.spriteGen.addSprite(var20_9.left, var20_9.top, var41_45.ocImage, var13_20.loLayer, var5_19 * 4 + var35_39, 0, var42_55, null);
                                            this.spriteGen.modifSpriteEffect(var13_20.loSpr[var33_37], var36_40.oiInkEffect, var36_40.oiInkEffectParam);
                                            break;
                                        }
                                        default: {
                                            if (var14_5 != null) {
                                                var13_20.loSpr[var33_37] = this.spriteGen.addOwnerDrawSprite(var20_9.left, var20_9.top, var20_9.right, var20_9.bottom, var13_20.loLayer, var5_19 * 4 + var35_39, 0, var42_55 | 256, null, var14_5);
                                                break;
                                            } else {
                                                break;
                                            }
                                        }
                                    }
                                    break block122;
                                }
                                switch (var39_43) {
                                    case 0: {
                                        var43_57 = var13_20.loSpr[var33_37].getSpriteRect();
                                        if (var20_9.left != var43_57.left || var20_9.top != var43_57.top || var20_9.right != var43_57.right || var20_9.bottom != var43_57.bottom) {
                                            this.spriteGen.modifOwnerDrawSprite(var13_20.loSpr[var33_37], var20_9.left, var20_9.top, var20_9.right, var20_9.bottom);
                                            ** break;
                                        }
                                        break block122;
                                    }
                                    case 1: {
                                        this.spriteGen.modifSprite(var13_20.loSpr[var33_37], var20_9.left, var20_9.top, var41_45.ocImage);
                                        ** break;
                                    }
                                    default: {
                                        if (var14_5 != null) {
                                            this.spriteGen.modifOwnerDrawSprite(var13_20.loSpr[var33_37], var20_9.left, var20_9.top, var20_9.right, var20_9.bottom);
                                        }
lbl352:
                                        // 5 sources

                                        break block122;
                                    }
                                }
                            }
                            if (!var22_10) {
                                switch (var39_43) {
                                    case 0: {
                                        var42_56 = this.rhApp.OIList.getOIFromHandle(var13_20.loOiHandle);
                                        var43_57 = (COCQBackdrop)var42_56.oiOC;
                                        var43_57.spriteDraw(var1_1, null, this.rhApp.imageBank, var20_9.left, var20_9.top);
                                        this.rhApp.winMan.winAddZone(var20_9);
                                        break;
                                    }
                                    case 1: {
                                        this.spriteGen.pasteSpriteEffect(var1_1, var41_45.ocImage, var20_9.left, var20_9.top, 0, var36_40.oiInkEffect, var36_40.oiInkEffectParam);
                                        break;
                                    }
                                    default: {
                                        var14_5.draw(var1_1);
                                    }
                                }
                            }
                        }
                        if (var34_38 && var13_20.loLayer > 0 && var13_20.loSpr[var33_37] != null) {
                            this.spriteGen.delSprite(var13_20.loSpr[var33_37]);
                            var13_20.loSpr[var33_37] = null;
                        }
                        if (var32_36 == 0) continue;
                        --var5_19;
                    }
                }
                if (var26_24.pBkd2 != null) {
                    this.displayBkd2Layer(var1_1, var26_24, var21_16, var2_2, var8_13, var9_15, var11_4);
                }
                if ((var26_24.dwOptions & 131072) != 0) {
                    var26_24.dwOptions &= -131089;
                }
            }
            ++var21_16;
        }
        if (var17_6) {
            var26_25 = this.rhFrame.layers[0];
            var15_29 = this.rhFrame.leX;
            var16_30 = this.rhFrame.leY;
            if ((var26_25.dwOptions & 3) != 0) {
                if ((var26_25.dwOptions & 1) != 0) {
                    var15_29 = (int)((float)var15_29 * var26_25.xCoef);
                }
                if ((var26_25.dwOptions & 2) != 0) {
                    var16_30 = (int)((float)var16_30 * var26_25.yCoef);
                }
            }
            var15_29 += var26_25.x;
            var16_30 += var26_25.y;
            if (this.rhFrame.colMask != null) {
                this.rhFrame.colMask.setOrigin(var15_29, var16_30);
            }
        }
        if ((var2_2 & 4) != 0) {
            this.f_UpdateWindowPosEnd(var1_1);
        }
        this.rhApp.winMan.winAddZone(null);
        if (var23_11) {
            var1_1.dispose();
        }
    }

    public void grabDesktop(Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        switch (this.rhApp.displayType) {
            case 0: {
                rectangle2 = this.rhApp.window.getBounds();
                rectangle.x = rectangle2.x + this.rhApp.xOffset;
                rectangle.y = rectangle2.y + this.rhApp.yOffset;
                break;
            }
            case 1: {
                rectangle2 = this.rhApp.window.getBounds();
                rectangle3 = this.rhApp.component.getBounds();
                rectangle.x = rectangle2.x + rectangle3.x;
                int n = 0;
                if (this.rhApp.appMenu != null) {
                    n = this.rhApp.appMenu.getPreferredSize().height;
                }
                rectangle.y = rectangle2.y + rectangle3.y + n;
            }
        }
        rectangle.width = this.rhFrame.leEditWinWidth;
        rectangle.height = this.rhFrame.leEditWinHeight;
        if (this.rhApp.robot != null) {
            BufferedImage bufferedImage = this.rhApp.robot.createScreenCapture(rectangle);
            graphics2D.drawImage(bufferedImage, null, 0, 0);
        }
    }

    void scrollLevel(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.rhFrame.leEditWinWidth;
        int n7 = this.rhFrame.leEditWinHeight;
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.rhFrame.nLayers > 0) {
            CLayer cLayer = this.rhFrame.layers[0];
            f = cLayer.xCoef;
            f2 = cLayer.yCoef;
        }
        int n8 = this.rhFrame.leLastScrlX;
        int n9 = this.rh3DisplayX;
        if (f != 1.0f) {
            n8 = (int)((float)n8 * f);
            n9 = (int)((float)n9 * f);
        }
        if (n9 < n8) {
            n5 = 0;
            n4 = n8 - n9;
            this.rhFrame.leLastScrlX = this.rh3DisplayX;
        } else {
            n5 = n9 - n8;
            n4 = 0;
            if (n5 != 0) {
                this.rhFrame.leLastScrlX = this.rh3DisplayX;
            }
        }
        int n10 = this.rhFrame.leLastScrlY;
        int n11 = this.rh3DisplayY;
        if (f2 != 1.0f) {
            n10 = (int)((float)n10 * f2);
            n11 = (int)((float)n11 * f2);
        }
        if (n11 < n10) {
            n3 = 0;
            n2 = n10 - n11;
            this.rhFrame.leLastScrlY = this.rh3DisplayY;
        } else {
            n3 = n11 - n10;
            n2 = 0;
            if (n3 != 0) {
                this.rhFrame.leLastScrlY = this.rh3DisplayY;
            }
        }
        int n12 = n6 - n5 - n4;
        int n13 = n7 - n3 - n2;
        this.rhFrame.leX = this.rh3DisplayX;
        this.rhFrame.leY = this.rh3DisplayY;
        this.spriteGen.activeSprite(null, 1, null);
        for (n = 0; n < this.rhFrame.nLayers; ++n) {
            CLayer cLayer = this.rhFrame.layers[n];
            if ((cLayer.dwOptions & 0x40000) != 0) {
                this.f_ShowAllObjects(n, true);
            }
            if ((cLayer.dwOptions & 0x20000) == 0) continue;
            this.f_ShowAllObjects(n, false);
        }
        this.f_UpdateWindowPos(graphics2D, this.rhFrame.leX, this.rhFrame.leY);
        boolean bl = false;
        boolean bl2 = false;
        if (n12 > n6 / 4 && n13 > n7 / 4) {
            if (n12 == n6 && n13 == n7) {
                bl2 = true;
                bl = true;
            } else {
                if (n12 > 0 && n13 > 0) {
                    graphics2D.copyArea(n5, n3, n12, n13, n4 - n5, n2 - n3);
                    bl2 = true;
                }
                if (!bl2 || (this.rhFrame.leFlags & 0x20) == 0) {
                    // empty if block
                }
            }
        }
        if (!bl2) {
            this.redrawLevel(graphics2D, 2);
        } else {
            n = 0;
            if (n5 != 0) {
                graphics2D.setClip(n12 - 1, 0, Short.MAX_VALUE, Short.MAX_VALUE);
            } else if (n4 != 0) {
                graphics2D.setClip(0, 0, n4, Short.MAX_VALUE);
            }
            if (n5 != 0 || n4 != 0) {
                this.rhApp.winMan.winAddZone(null);
                if (bl) {
                    this.redrawLevel(graphics2D, 34);
                } else {
                    this.redrawLevel(graphics2D, 18);
                }
                n = 1;
            }
            if (n3 != 0) {
                graphics2D.setClip(0, n13 - 1, Short.MAX_VALUE, Short.MAX_VALUE);
            } else if (n2 != 0) {
                graphics2D.setClip(0, 0, Short.MAX_VALUE, n2);
            }
            if (n3 != 0 || n2 != 0) {
                this.rhApp.winMan.winAddZone(null);
                if (bl) {
                    this.redrawLevel(graphics2D, 34);
                } else {
                    this.redrawLevel(graphics2D, 18);
                }
                n = 1;
            }
            graphics2D.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
            if (n == 0 && this.rhFrame.nLayers > 0) {
                if ((this.rhFrame.layers[0].dwOptions & 0x10000) != 0) {
                    this.redrawLevel(graphics2D, 18);
                } else {
                    this.redrawLevel(graphics2D, 82);
                }
            }
        }
        this.f_UpdateWindowPosEnd(graphics2D);
    }

    public void updateScrollLevelPos() {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.rhFrame.nLayers > 0) {
            CLayer cLayer = this.rhFrame.layers[0];
            f = cLayer.xCoef;
            f2 = cLayer.yCoef;
        }
        int n = this.rhFrame.leLastScrlX;
        int n2 = this.rh3DisplayX;
        if ((double)f != 1.0) {
            n = (int)((float)n * f);
            n2 = (int)((float)n2 * f);
        }
        if (n2 < n) {
            boolean bl = false;
            this.rhFrame.leLastScrlX = this.rh3DisplayX;
        } else {
            int n3 = n2 - n;
            if (n3 != 0) {
                this.rhFrame.leLastScrlX = this.rh3DisplayX;
            }
        }
        int n4 = this.rhFrame.leLastScrlY;
        int n5 = this.rh3DisplayY;
        if ((double)f2 != 1.0) {
            n4 = (int)((float)n4 * f2);
            n5 = (int)((float)n5 * f2);
        }
        if (n5 < n4) {
            boolean bl = false;
            this.rhFrame.leLastScrlY = this.rh3DisplayY;
        } else {
            int n6 = n5 - n4;
            if (n6 != 0) {
                this.rhFrame.leLastScrlY = this.rh3DisplayY;
            }
        }
        this.rhFrame.leX = this.rh3DisplayX;
        this.rhFrame.leY = this.rh3DisplayY;
    }

    public void screen_Update() {
        Graphics2D graphics2D = this.rhApp.editWin.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        if (this.rh3Scrolling == '\u0000') {
            graphics2D.setComposite(AlphaComposite.Src);
            this.spriteGen.spriteClear(graphics2D);
            this.erase_QuickDisplay(graphics2D);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            this.callBackDrawRoutines(graphics2D);
            this.save_QuickDisplay(this.rhApp.editWin);
            this.spriteGen.spriteUpdate();
            this.draw_QuickDisplay(graphics2D);
            this.spriteGen.spriteDraw(graphics2D, this.rhApp.editWin);
        } else {
            graphics2D.setComposite(AlphaComposite.Src);
            if ((this.rh3Scrolling & 4) != 0) {
                char c = this.rh3Scrolling;
                this.rh3Scrolling = '\u0000';
                if (this.rhFrame.leX != this.rh3DisplayX || this.rhFrame.leY != this.rh3DisplayY) {
                    this.updateScrollLevelPos();
                }
                int n = 6;
                if ((c & 8) == 0 && (this.rhFrame.leFlags & 0x20) != 0) {
                    n |= 0x10;
                }
                this.redrawLevel(graphics2D, n);
                this.rh3DisplayX = this.rhWindowX;
                this.rh3DisplayY = this.rhWindowY;
            } else if ((this.rh3Scrolling & '\u0001') != 0) {
                this.rh3Scrolling = '\u0000';
                if (this.rhFrame.leX == this.rh3DisplayX && this.rhFrame.leY == this.rh3DisplayY) {
                    this.redrawLevel(graphics2D, 6);
                } else {
                    this.scrollLevel(graphics2D);
                }
                this.rh3DisplayX = this.rhWindowX;
                this.rh3DisplayY = this.rhWindowY;
            } else {
                this.rh3Scrolling = '\u0000';
                this.redrawLevel(graphics2D, 134);
            }
        }
        graphics2D.dispose();
    }

    public void f_Sprites_Update(Graphics2D graphics2D) {
        graphics2D.setComposite(AlphaComposite.SrcOver);
        this.spriteGen.spriteClear(graphics2D);
        this.erase_QuickDisplay(graphics2D);
        this.spriteGen.spriteUpdate();
        this.save_QuickDisplay(this.rhApp.editWin);
        graphics2D.setComposite(AlphaComposite.Src);
        this.draw_QuickDisplay(graphics2D);
        this.spriteGen.spriteDraw(graphics2D, this.rhApp.editWin);
        this.razBackDrawRoutines();
    }

    public void modif_RedrawLevel(CExtension cExtension) {
        boolean bl = false;
        if (cExtension != null) {
            int n = cExtension.hoCommon.ocFlags2 & 0x30;
            if (cExtension.getCollisionMask(-1) != null && (cExtension.hoLayer == 0 && n != 48 || cExtension.hoLayer > 0 && (n == 16 || n == 32))) {
                bl = true;
            }
        }
        this.ohRedrawLevel(bl);
    }

    public void updateControlsPos() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if ((cObject.hoOEFlags & 0x80) == 0) continue;
            cObject.draw(null);
        }
    }

    public void updateSubAppPos() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if (!(cObject instanceof CCCA)) continue;
            ((CCCA)cObject).setDockedPosition();
        }
    }

    public void bringSubAppToFront() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if (!(cObject instanceof CCCA)) continue;
            ((CCCA)cObject).bringToFront();
        }
    }

    public int scaleX(int n) {
        if ((this.rhApp.gaFlags & 0x10) != 0) {
            return (int)((double)n * ((double)this.rhApp.sxComponent / (double)this.rhApp.frame.leEditWinWidth));
        }
        return n;
    }

    public int scaleY(int n) {
        if ((this.rhApp.gaFlags & 0x10) != 0) {
            return (int)((double)n * ((double)this.rhApp.syComponent / (double)this.rhApp.frame.leEditWinHeight));
        }
        return n;
    }

    public void sendKey(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n2] == null) {
                ++n2;
            }
            CObject cObject = this.rhObjectList[n2];
            ++n2;
            if (!(cObject instanceof CCCA)) continue;
            CCCA cCCA = (CCCA)cObject;
            cCCA.sendKey(n, bl);
        }
    }

    public CObject find_HeaderObject(short s) {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            if (s == this.rhObjectList[n].hoHFII) {
                return this.rhObjectList[n];
            }
            ++n;
        }
        return null;
    }

    public void f_UpdateWindowPos(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4 = 0;
        this.rh4WindowDeltaX = n - this.rhWindowX;
        if (this.rh4WindowDeltaX != 0) {
            n4 = (short)(n4 + 1);
        }
        this.rh4WindowDeltaY = n2 - this.rhWindowY;
        if (this.rh4WindowDeltaY != 0) {
            n4 = (short)(n4 + 1);
        }
        if (n4 == 0) {
            for (n3 = 0; n3 < this.rhFrame.nLayers; ++n3) {
                CLayer cLayer = this.rhFrame.layers[n3];
                if (cLayer.dx == 0 && cLayer.dy == 0) continue;
                n4 = (short)(n4 + 1);
                break;
            }
        }
        n3 = this.rhWindowX;
        int n5 = this.rhWindowY;
        int n6 = n;
        int n7 = n2;
        int n8 = this.rh4WindowDeltaX;
        int n9 = this.rh4WindowDeltaY;
        this.rhWindowX = n;
        this.rh3XMinimum = n - 64;
        if (this.rh3XMinimum < 0) {
            this.rh3XMinimum = this.rh3XMinimumKill;
        }
        this.rhWindowY = n2;
        this.rh3YMinimum = n2 - 16;
        if (this.rh3YMinimum < 0) {
            this.rh3YMinimum = this.rh3YMinimumKill;
        }
        this.rh3XMaximum = n + this.rh3WindowSx + 64;
        if (this.rh3XMaximum > this.rhLevelSx) {
            this.rh3XMaximum = this.rh3XMaximumKill;
        }
        this.rh3YMaximum = n2 + this.rh3WindowSy + 16;
        if (this.rh3YMaximum > this.rhLevelSy) {
            this.rh3YMaximum = this.rh3YMaximumKill;
        }
        this.rh4FirstQuickDisplay = Short.MIN_VALUE;
        this.rh4LastQuickDisplay = Short.MIN_VALUE;
        int n10 = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n10] == null) {
                ++n10;
            }
            CObject cObject = this.rhObjectList[n10];
            ++n10;
            if (cObject.hoNextQuickDisplay != -2) {
                cObject.hoNextQuickDisplay = (short)-1;
            }
            if (n4 != 0) {
                int n11;
                int n12;
                if ((cObject.hoOEFlags & 0x800) != 0) {
                    n12 = n8;
                    n11 = n9;
                    if (cObject.rom == null) {
                        cObject.hoX += n12;
                        cObject.hoY += n11;
                    } else {
                        cObject.rom.rmMovement.setXPosition(n12 += cObject.hoX);
                        cObject.rom.rmMovement.setYPosition(n11 += cObject.hoY);
                    }
                } else {
                    n12 = cObject.hoLayer;
                    if (n12 < this.rhFrame.nLayers) {
                        n11 = n3;
                        int n13 = n5;
                        int n14 = n6;
                        int n15 = n7;
                        CLayer cLayer = this.rhFrame.layers[n12];
                        if ((cLayer.dwOptions & 1) != 0) {
                            n11 = (int)(cLayer.xCoef * (float)n11);
                            n14 = (int)(cLayer.xCoef * (float)n14);
                        }
                        if ((cLayer.dwOptions & 2) != 0) {
                            n13 = (int)(cLayer.yCoef * (float)n13);
                            n15 = (int)(cLayer.yCoef * (float)n15);
                        }
                        int n16 = cObject.hoX + n11 - n14 + n8 - cLayer.dx;
                        int n17 = cObject.hoY + n13 - n15 + n9 - cLayer.dy;
                        if ((cObject.hoOEFlags & 0x10) == 0) {
                            cObject.hoX = n16;
                            cObject.hoY = n17;
                        } else {
                            cObject.rom.rmMovement.setXPosition(n16);
                            cObject.rom.rmMovement.setYPosition(n17);
                        }
                    }
                }
                if ((cObject.hoOEFlags & 2) != 0) continue;
                cObject.modif();
                continue;
            }
            if ((cObject.hoOEFlags & 2) != 0) continue;
            cObject.display();
        }
        this.spriteGen.spriteClear(graphics2D);
        this.erase_QuickDisplay(graphics2D);
    }

    void f_UpdateWindowPosEnd(Graphics2D graphics2D) {
        this.callBackDrawRoutines(graphics2D);
        this.spriteGen.spriteUpdate();
        this.save_QuickDisplay(this.rhApp.editWin);
        this.spriteGen.spriteDraw(graphics2D, this.rhApp.editWin);
        this.draw_QuickDisplay(graphics2D);
        this.razBackDrawRoutines();
    }

    public void f_ShowAllObjects(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n2] == null) {
                ++n2;
            }
            CObject cObject = this.rhObjectList[n2];
            ++n2;
            if (n != cObject.hoLayer && n != -1 || cObject.ros == null) continue;
            if (cObject.roc.rcSprite != null) {
                this.spriteGen.activeSprite(cObject.roc.rcSprite, 1, null);
            }
            if (bl) {
                if ((cObject.ros.rsFlags & 0x20) != 0) {
                    CLayer cLayer = this.rhFrame.layers[cObject.hoLayer];
                    int n3 = cLayer.dwOptions;
                    cLayer.dwOptions = cLayer.dwOptions & 0xFFF9FFFF | 0x10;
                    cObject.ros.obShow();
                    cLayer.dwOptions = n3;
                }
            } else {
                cObject.ros.obHide();
            }
            cObject.ros.rsFlash = 0;
        }
    }

    public void setDisplay(int n, int n2, int n3, int n4) {
        float f = n -= this.rh3WindowSx / 2;
        float f2 = n2 -= this.rh3WindowSy / 2;
        if (n3 != -1 && n3 < this.rhFrame.nLayers) {
            float f3;
            CLayer cLayer = this.rhFrame.layers[n3];
            if (cLayer.xCoef > 1.0f) {
                f3 = f - (float)this.rhWindowX;
                f = (float)this.rhWindowX + (f3 /= cLayer.xCoef);
            }
            if (cLayer.yCoef > 1.0f) {
                f3 = f2 - (float)this.rhWindowY;
                f2 = (float)this.rhWindowY + (f3 /= cLayer.yCoef);
            }
        }
        n = (int)f;
        n2 = (int)f2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n5 = n + this.rh3WindowSx;
        int n6 = n2 + this.rh3WindowSy;
        if (n5 > this.rhLevelSx) {
            n5 = this.rhLevelSx - this.rh3WindowSx;
            if (n5 < 0) {
                n5 = 0;
            }
            n = n5;
        }
        if (n6 > this.rhLevelSy) {
            n6 = this.rhLevelSy - this.rh3WindowSy;
            if (n6 < 0) {
                n6 = 0;
            }
            n2 = n6;
        }
        if ((n4 & 1) != 0 && n != this.rhWindowX) {
            this.rh3DisplayX = n;
            this.rh3Scrolling = (char)(this.rh3Scrolling | '\u0001');
        }
        if ((n4 & 2) != 0 && n2 != this.rhWindowY) {
            this.rh3DisplayY = n2;
            this.rh3Scrolling = (char)(this.rh3Scrolling | '\u0001');
        }
    }

    public void ohRedrawLevel(boolean bl) {
        this.rh3Scrolling = (char)(this.rh3Scrolling | 4);
        if (bl) {
            this.rh3Scrolling = (char)(this.rh3Scrolling | 8);
        }
    }

    public void y_Ladder_Reset(int n) {
        if (n >= 0 && n < this.rhFrame.nLayers) {
            CLayer cLayer = this.rhFrame.layers[n];
            cLayer.pLadders = null;
        }
    }

    public void y_Ladder_Add(int n, int n2, int n3, int n4, int n5) {
        if (n >= 0 && n < this.rhFrame.nLayers) {
            CLayer cLayer = this.rhFrame.layers[n];
            CRect cRect = new CRect();
            cRect.left = Math.min(n2, n4);
            cRect.top = Math.min(n3, n5);
            cRect.right = Math.max(n2, n4);
            cRect.bottom = Math.max(n3, n5);
            if (cLayer.pLadders == null) {
                cLayer.pLadders = new ArrayList();
            }
            cLayer.pLadders.add(cRect);
        }
    }

    public void y_Ladder_Sub(int n, int n2, int n3, int n4, int n5) {
        if (n >= 0 && n < this.rhFrame.nLayers) {
            CLayer cLayer = this.rhFrame.layers[n];
            if (cLayer.pLadders != null) {
                CRect cRect = new CRect();
                cRect.left = Math.min(n2, n4);
                cRect.top = Math.min(n3, n5);
                cRect.right = Math.max(n2, n4);
                cRect.bottom = Math.max(n3, n5);
                for (int i = 0; i < cLayer.pLadders.size(); ++i) {
                    CRect cRect2 = cLayer.pLadders.get(i);
                    if (cRect2.intersectRect(cRect)) continue;
                    cLayer.pLadders.remove(i);
                    --i;
                }
            }
        }
    }

    public CRect y_GetLadderAt(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n == -1) {
            n5 = 0;
            n4 = this.rhFrame.nLayers;
        } else {
            n5 = n;
            n4 = n + 1;
        }
        while (n5 < n4) {
            CLayer cLayer = this.rhFrame.layers[n5];
            if (cLayer.pLadders != null) {
                for (int i = 0; i < cLayer.pLadders.size(); ++i) {
                    CRect cRect = cLayer.pLadders.get(i);
                    if (n2 < cRect.left || n3 < cRect.top || n2 >= cRect.right || n3 >= cRect.bottom) continue;
                    return cRect;
                }
            }
            ++n5;
        }
        return null;
    }

    public CRect y_GetLadderAt_Absolute(int n, int n2, int n3) {
        return this.y_GetLadderAt(n, n2 -= this.rhFrame.leX, n3 -= this.rhFrame.leY);
    }

    public void activeToBackdrop(CObject cObject, int n, boolean bl) {
        CBkd2 cBkd2 = new CBkd2();
        cBkd2.img = cObject.roc.rcImage;
        CImage cImage = this.rhApp.imageBank.getImageFromHandle(cBkd2.img);
        cBkd2.loHnd = 0;
        cBkd2.oiHnd = 0;
        cBkd2.x = cObject.hoX - cImage.xSpot;
        cBkd2.y = cObject.hoY - cImage.ySpot;
        cBkd2.nLayer = (short)cObject.hoLayer;
        cBkd2.obstacleType = (short)n;
        cBkd2.colMode = 1;
        if ((cObject.ros.rsCreaFlags & 0x100) != 0) {
            cBkd2.colMode = 0;
        }
        for (int i = 0; i < 4; ++i) {
            cBkd2.pSpr[i] = null;
        }
        cBkd2.inkEffect = cObject.ros.rsEffect;
        cBkd2.inkEffectParam = cObject.ros.rsEffectParam;
        CLayer cLayer = this.rhFrame.layers[cBkd2.nLayer];
        CBackDrawPaste cBackDrawPaste = new CBackDrawPaste();
        cBackDrawPaste.img = cBkd2.img;
        cBackDrawPaste.x = cObject.hoX;
        cBackDrawPaste.y = cObject.hoY;
        cBackDrawPaste.typeObst = (short)n;
        cBackDrawPaste.inkEffect = cBkd2.inkEffect;
        cBackDrawPaste.inkEffectParam = cBkd2.inkEffectParam;
        if (!bl && cBkd2.nLayer == 0) {
            if ((cLayer.dwOptions & 0x20010) == 16) {
                this.addBackDrawRoutine(cBackDrawPaste);
            }
        } else {
            this.addBackdrop2(cBkd2);
            if (cBkd2.nLayer == 0 && (cLayer.dwOptions & 0x20010) == 16) {
                this.addBackDrawRoutine(cBackDrawPaste);
            }
        }
        if (cBkd2.nLayer == 0 && this.rhFrame.nLayers > 1) {
            this.spriteGen.activeSprite(null, 1, null);
        }
    }

    public void addBackdrop2(CBkd2 cBkd2) {
        CBkd2 cBkd22;
        if (cBkd2.nLayer < 0 || cBkd2.nLayer >= this.rhFrame.nLayers) {
            return;
        }
        CLayer cLayer = this.rhFrame.layers[cBkd2.nLayer];
        if (cLayer.pBkd2 != null) {
            for (int i = 0; i < cLayer.pBkd2.size(); ++i) {
                int n;
                cBkd22 = cLayer.pBkd2.get(i);
                if (cBkd22.x != cBkd2.x || cBkd22.y != cBkd2.y || cBkd22.nLayer != cBkd2.nLayer || cBkd22.img != cBkd2.img || (cBkd22.inkEffect & 0xFFFF) != 0) continue;
                if (i != cLayer.pBkd2.size() - 1) {
                    for (n = 0; n < 4; ++n) {
                        if (cBkd22.pSpr[n] == null) continue;
                        this.spriteGen.moveSpriteToFront(cBkd22.pSpr[n]);
                    }
                    cLayer.pBkd2.remove(i);
                    cLayer.pBkd2.add(cBkd22);
                }
                cBkd22.colMode = cBkd2.colMode;
                cBkd22.obstacleType = cBkd2.obstacleType;
                if (cBkd22.inkEffect != cBkd2.inkEffect || cBkd22.inkEffectParam != cBkd2.inkEffectParam) {
                    cBkd22.inkEffect = cBkd2.inkEffect;
                    cBkd22.inkEffectParam = cBkd2.inkEffectParam;
                    for (n = 0; n < 4; ++n) {
                        if (cBkd22.pSpr[n] == null) continue;
                        this.spriteGen.modifSpriteEffect(cBkd22.pSpr[n], cBkd22.inkEffect, cBkd22.inkEffectParam);
                    }
                }
                return;
            }
            if (cLayer.pBkd2.size() >= this.rhFrame.maxObjects) {
                return;
            }
        } else {
            cLayer.pBkd2 = new ArrayList();
        }
        int n = cLayer.pBkd2.size();
        cLayer.pBkd2.add(cBkd2);
        if (cBkd2.nLayer > 0) {
            cBkd22 = cBkd2;
            CRect cRect = new CRect();
            int n2 = this.rhFrame.leX;
            int n3 = this.rhFrame.leY;
            boolean bl = (cLayer.dwOptions & 0x20) != 0;
            boolean bl2 = (cLayer.dwOptions & 0x40) != 0;
            boolean bl3 = false;
            if (bl || bl2) {
                bl3 = true;
            }
            int n4 = this.rhFrame.leWidth;
            int n5 = this.rhFrame.leHeight;
            if ((cLayer.dwOptions & 3) != 0) {
                if ((cLayer.dwOptions & 1) != 0) {
                    n2 = (int)((float)n2 * cLayer.xCoef);
                }
                if ((cLayer.dwOptions & 2) != 0) {
                    n3 = (int)((float)n3 * cLayer.yCoef);
                }
            }
            n2 += cLayer.x;
            n3 += cLayer.y;
            if (bl) {
                n2 %= n4;
            }
            if (bl2) {
                n3 %= n5;
            }
            if ((cLayer.dwOptions & 0x20010) == 16) {
                boolean bl4 = (cLayer.dwOptions & 4) == 0;
                int n6 = 0;
                int n7 = 0;
                do {
                    int n8;
                    int n9 = n7;
                    cRect.left = cBkd22.x - n2;
                    cRect.top = cBkd22.y - n3;
                    int n10 = this.rhFrame.leEditWinWidth - 1;
                    int n11 = this.rhFrame.leEditWinHeight - 1;
                    short s = cBkd22.img;
                    CImage cImage = this.rhApp.imageBank.getImageFromHandle(s);
                    if (cImage != null) {
                        cRect.right = cRect.left + cImage.width;
                        cRect.bottom = cRect.top + cImage.height;
                    } else {
                        cRect.right = cRect.left + 1;
                        cRect.bottom = cRect.top + 1;
                    }
                    if (bl3) {
                        switch (n7) {
                            case 0: {
                                if (bl && (cRect.left < 0 || cRect.right > n4)) {
                                    if (bl2 && (cRect.top < 0 || cRect.bottom > n5)) {
                                        n7 = 3;
                                        n6 |= 7;
                                    } else {
                                        n7 = 1;
                                        n6 |= 1;
                                    }
                                } else if (bl2 && (cRect.top < 0 || cRect.bottom > n5)) {
                                    n7 = 2;
                                    n6 |= 2;
                                }
                                if (!(n6 & true) && cBkd22.pSpr[1] != null) {
                                    this.spriteGen.delSprite(cBkd22.pSpr[1]);
                                    cBkd22.pSpr[1] = null;
                                }
                                if ((n6 & 2) == 0 && cBkd22.pSpr[2] != null) {
                                    this.spriteGen.delSprite(cBkd22.pSpr[2]);
                                    cBkd22.pSpr[2] = null;
                                }
                                if ((n6 & 4) != 0 || cBkd22.pSpr[3] == null) break;
                                this.spriteGen.delSprite(cBkd22.pSpr[3]);
                                cBkd22.pSpr[3] = null;
                                break;
                            }
                            case 1: {
                                if (cRect.left < 0) {
                                    n8 = n4;
                                    cRect.left += n8;
                                    cRect.right += n8;
                                } else if (cRect.right > n4) {
                                    n8 = n4;
                                    cRect.left -= n8;
                                    cRect.right -= n8;
                                }
                                n7 = 0;
                                if (((n6 &= 0xFFFFFFFE) & 2) == 0) break;
                                n7 = 2;
                                break;
                            }
                            case 2: {
                                if (cRect.top < 0) {
                                    n8 = n5;
                                    cRect.top += n8;
                                    cRect.bottom += n8;
                                } else if (cRect.bottom > n5) {
                                    n8 = n5;
                                    cRect.top -= n8;
                                    cRect.bottom -= n8;
                                }
                                n7 = 0;
                                if (((n6 &= 0xFFFFFFFD) & 1) == 0) break;
                                n7 = 1;
                                break;
                            }
                            case 3: {
                                if (cRect.left < 0) {
                                    n8 = n4;
                                    cRect.left += n8;
                                    cRect.right += n8;
                                } else if (cRect.right > n4) {
                                    n8 = n4;
                                    cRect.left -= n8;
                                    cRect.right -= n8;
                                }
                                if (cRect.top < 0) {
                                    n8 = n5;
                                    cRect.top += n8;
                                    cRect.bottom += n8;
                                } else if (cRect.bottom > n5) {
                                    n8 = n5;
                                    cRect.top -= n8;
                                    cRect.bottom -= n8;
                                }
                                n6 &= 0xFFFFFFFB;
                                n7 = 2;
                            }
                        }
                    }
                    if (cRect.left >= n10 + 64 + 32 || cRect.top >= n11 + 16) continue;
                    short s2 = cBkd22.obstacleType;
                    if (s2 == 3) {
                        this.y_Ladder_Add(cBkd22.nLayer, cRect.left, cRect.top, cRect.right, cRect.bottom);
                    }
                    if (cRect.left > n10 || cRect.top > n11 || cRect.right < 0 || cRect.bottom < 0) continue;
                    n8 = 0x480008;
                    if (!bl4) {
                        n8 |= 0x200;
                    }
                    if (s2 == 1) {
                        n8 |= 0x10001;
                    }
                    if (s2 == 2) {
                        n8 |= 0x20001;
                    }
                    cBkd22.pSpr[n9] = this.spriteGen.addSprite(cRect.left, cRect.top, s, cBkd22.nLayer, 0x10000000 + n * 4 + n9, 0, n8, null);
                    this.spriteGen.modifSpriteEffect(cBkd22.pSpr[n9], cBkd22.inkEffect, cBkd22.inkEffectParam);
                } while (n6 != 0);
            }
        }
    }

    public void deleteAllBackdrop2(int n) {
        if (n < 0 || n >= this.rhFrame.nLayers) {
            return;
        }
        CLayer cLayer = this.rhFrame.layers[n];
        if (cLayer.pBkd2 != null) {
            for (int i = 0; i < cLayer.pBkd2.size(); ++i) {
                CBkd2 cBkd2 = cLayer.pBkd2.get(i);
                for (int j = 0; j < 4; ++j) {
                    if (cBkd2.pSpr[j] == null) continue;
                    this.spriteGen.delSprite(cBkd2.pSpr[j]);
                    cBkd2.pSpr[j] = null;
                }
            }
            cLayer.pBkd2 = null;
            cLayer.dwOptions |= 0x10000;
            this.rh3Scrolling = (char)(this.rh3Scrolling | 2);
        }
    }

    public void deleteBackdrop2At(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= this.rhFrame.nLayers) {
            return;
        }
        CLayer cLayer = this.rhFrame.layers[n];
        if (cLayer.pBkd2 != null) {
            boolean bl2 = false;
            boolean bl3 = (cLayer.dwOptions & 0x20) != 0;
            boolean bl4 = (cLayer.dwOptions & 0x40) != 0;
            boolean bl5 = bl3 | bl4;
            int n4 = this.rhFrame.leWidth;
            int n5 = this.rhFrame.leHeight;
            int n6 = this.rhFrame.leX;
            int n7 = this.rhFrame.leY;
            if ((cLayer.dwOptions & 3) != 0) {
                if ((cLayer.dwOptions & 1) != 0) {
                    n6 = (int)((float)n6 * cLayer.xCoef);
                }
                if ((cLayer.dwOptions & 2) != 0) {
                    n7 = (int)((float)n7 * cLayer.yCoef);
                }
            }
            n6 += cLayer.x;
            n7 += cLayer.y;
            if (bl3) {
                n6 %= n4;
            }
            if (bl4) {
                n7 %= n5;
            }
            int n8 = 0;
            int n9 = 0;
            for (int i = 0; i < cLayer.pBkd2.size(); ++i) {
                CBkd2 cBkd2 = cLayer.pBkd2.get(i);
                if (cBkd2.nLayer != n) continue;
                boolean bl6 = false;
                CRect cRect = new CRect();
                boolean bl7 = cBkd2.colMode == 0;
                cRect.left = cBkd2.x - n6;
                cRect.top = cBkd2.y - n7;
                CImage cImage = this.rhApp.imageBank.getImageFromHandle(cBkd2.img);
                if (cImage != null) {
                    cRect.right = cRect.left + cImage.width;
                    cRect.bottom = cRect.top + cImage.height;
                } else {
                    cRect.right = cRect.left + 1;
                    cRect.bottom = cRect.top + 1;
                }
                if (bl5) {
                    switch (n9) {
                        case 0: {
                            if (bl3 && (cRect.left < 0 || cRect.right > n4)) {
                                if (bl4 && (cRect.top < 0 || cRect.bottom > n5)) {
                                    n9 = 3;
                                    n8 |= 7;
                                    break;
                                }
                                n9 = 1;
                                n8 |= 1;
                                break;
                            }
                            if (!bl4 || cRect.top >= 0 && cRect.bottom <= n5) break;
                            n9 = 2;
                            n8 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                int n10 = n4;
                                cRect.left += n10;
                                cRect.right += n10;
                            } else if (cRect.right > n4) {
                                int n11 = n4;
                                cRect.left -= n11;
                                cRect.right -= n11;
                            }
                            n9 = 0;
                            if (((n8 &= 0xFFFFFFFE) & 2) == 0) break;
                            n9 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                int n12 = n5;
                                cRect.top += n12;
                                cRect.bottom += n12;
                            } else if (cRect.bottom > n5) {
                                int n13 = n5;
                                cRect.top -= n13;
                                cRect.bottom -= n13;
                            }
                            n9 = 0;
                            if (((n8 &= 0xFFFFFFFD) & 1) == 0) break;
                            n9 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                int n14 = n4;
                                cRect.left += n14;
                                cRect.right += n14;
                            } else if (cRect.right > n4) {
                                int n15 = n4;
                                cRect.left -= n15;
                                cRect.right -= n15;
                            }
                            if (cRect.top < 0) {
                                int n16 = n5;
                                cRect.top += n16;
                                cRect.bottom += n16;
                            } else if (cRect.bottom > n5) {
                                int n17 = n5;
                                cRect.top -= n17;
                                cRect.bottom -= n17;
                            }
                            n8 &= 0xFFFFFFFB;
                            n9 = 2;
                        }
                    }
                }
                if (n2 >= cRect.left && n3 >= cRect.top && n2 < cRect.right && n3 < cRect.bottom) {
                    if (!bl || bl7) {
                        bl6 = true;
                    } else {
                        CMask cMask = this.rhApp.imageBank.getImageFromHandle(cBkd2.img).getMask(CMask.GCMF_OBSTACLE);
                        if (cMask != null && cMask.testPoint(n2 - cRect.left, n3 - cRect.top)) {
                            bl6 = true;
                        }
                    }
                }
                if (bl6) {
                    bl2 = true;
                    for (int j = 0; j < 4; ++j) {
                        if (cBkd2.pSpr[j] == null) continue;
                        this.spriteGen.delSprite(cBkd2.pSpr[j]);
                        cBkd2.pSpr[j] = null;
                    }
                    cLayer.pBkd2.remove(i);
                    n8 = 0;
                    --i;
                }
                if (n8 == 0) continue;
                --i;
            }
            if (bl2) {
                cLayer.dwOptions |= 0x10000;
                this.rh3Scrolling = (char)(this.rh3Scrolling | 2);
            }
        }
    }

    public void displayBkd2Layer(Graphics2D graphics2D, CLayer cLayer, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        CBkd2 cBkd2;
        int n6;
        CRect cRect = new CRect();
        boolean bl2 = (this.rhFrame.leFlags & 0x20) != 0;
        boolean bl3 = (n2 & 0x10) == 0;
        boolean bl4 = n == 0 && (cLayer.dwOptions & 0x10) == 0;
        int n7 = this.rhFrame.leX;
        int n8 = this.rhFrame.leY;
        boolean bl5 = (cLayer.dwOptions & 0x20) != 0;
        boolean bl6 = (cLayer.dwOptions & 0x40) != 0;
        boolean bl7 = bl5 | bl6;
        int n9 = this.rhFrame.leWidth;
        int n10 = this.rhFrame.leHeight;
        if ((cLayer.dwOptions & 3) != 0) {
            if ((cLayer.dwOptions & 1) != 0) {
                n7 = (int)((float)n7 * cLayer.xCoef);
            }
            if ((cLayer.dwOptions & 2) != 0) {
                n8 = (int)((float)n8 * cLayer.yCoef);
            }
        }
        n7 += cLayer.x;
        n8 += cLayer.y;
        if (bl5) {
            n7 %= n9;
        }
        if (bl6) {
            n8 %= n10;
        }
        if ((cLayer.dwOptions & 0x20000) != 0) {
            if (n > 0) {
                for (n6 = 0; n6 < cLayer.pBkd2.size(); ++n6) {
                    cBkd2 = cLayer.pBkd2.get(n6);
                    for (n5 = 0; n5 < 4; ++n5) {
                        if (cBkd2.pSpr[n5] == null) continue;
                        this.spriteGen.delSprite(cBkd2.pSpr[n5]);
                        cBkd2.pSpr[n5] = null;
                    }
                }
            } else {
                bl4 = true;
            }
        }
        if ((cLayer.dwOptions & 0x20000) == 0 || n == 0) {
            n5 = (cLayer.dwOptions & 4) == 0 ? 1 : 0;
            int n11 = 0;
            int n12 = 0;
            for (n6 = 0; n6 < cLayer.pBkd2.size(); ++n6) {
                int n13;
                cBkd2 = cLayer.pBkd2.get(n6);
                int n14 = n12;
                cRect.left = cBkd2.x - n7;
                cRect.top = cBkd2.y - n8;
                if (!(bl2 || bl7 || cRect.left < n3 + 64 + 32 && cRect.top < n4 + 16)) {
                    if (n <= 0 || cBkd2.pSpr[n14] == null) continue;
                    this.spriteGen.delSprite(cBkd2.pSpr[n14]);
                    cBkd2.pSpr[n14] = null;
                    continue;
                }
                short s = cBkd2.img;
                CImage cImage = this.rhApp.imageBank.getImageFromHandle(s);
                if (cImage != null) {
                    cRect.right = cRect.left + cImage.width;
                    cRect.bottom = cRect.top + cImage.height;
                } else {
                    cRect.right = cRect.left + 1;
                    cRect.bottom = cRect.top + 1;
                }
                if (bl7) {
                    switch (n12) {
                        case 0: {
                            if (bl5 && (cRect.left < 0 || cRect.right > n9)) {
                                if (bl6 && (cRect.top < 0 || cRect.bottom > n10)) {
                                    n12 = 3;
                                    n11 |= 7;
                                } else {
                                    n12 = 1;
                                    n11 |= 1;
                                }
                            } else if (bl6 && (cRect.top < 0 || cRect.bottom > n10)) {
                                n12 = 2;
                                n11 |= 2;
                            }
                            if (!(n11 & true) && cBkd2.pSpr[1] != null) {
                                this.spriteGen.delSprite(cBkd2.pSpr[1]);
                                cBkd2.pSpr[1] = null;
                            }
                            if ((n11 & 2) == 0 && cBkd2.pSpr[2] != null) {
                                this.spriteGen.delSprite(cBkd2.pSpr[2]);
                                cBkd2.pSpr[2] = null;
                            }
                            if ((n11 & 4) != 0 || cBkd2.pSpr[3] == null) break;
                            this.spriteGen.delSprite(cBkd2.pSpr[3]);
                            cBkd2.pSpr[3] = null;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                n13 = n9;
                                cRect.left += n13;
                                cRect.right += n13;
                            } else if (cRect.right > n9) {
                                n13 = n9;
                                cRect.left -= n13;
                                cRect.right -= n13;
                            }
                            n12 = 0;
                            if (((n11 &= 0xFFFFFFFE) & 2) == 0) break;
                            n12 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                n13 = n10;
                                cRect.top += n13;
                                cRect.bottom += n13;
                            } else if (cRect.bottom > n10) {
                                n13 = n10;
                                cRect.top -= n13;
                                cRect.bottom -= n13;
                            }
                            n12 = 0;
                            if (((n11 &= 0xFFFFFFFD) & 1) == 0) break;
                            n12 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                n13 = n9;
                                cRect.left += n13;
                                cRect.right += n13;
                            } else if (cRect.right > n9) {
                                n13 = n9;
                                cRect.left -= n13;
                                cRect.right -= n13;
                            }
                            if (cRect.top < 0) {
                                n13 = n10;
                                cRect.top += n13;
                                cRect.bottom += n13;
                            } else if (cRect.bottom > n10) {
                                n13 = n10;
                                cRect.top -= n13;
                                cRect.bottom -= n13;
                            }
                            n11 &= 0xFFFFFFFB;
                            n12 = 2;
                        }
                    }
                }
                short s2 = cBkd2.obstacleType;
                int n15 = n13 = cBkd2.colMode == 0 ? 1 : 0;
                if (s2 == 3) {
                    this.y_Ladder_Add(n, cRect.left, cRect.top, cRect.right, cRect.bottom);
                    n13 = 1;
                }
                if (n == 0 && bl3 && s2 != 4 && (bl2 || cRect.right >= -96 && cRect.bottom >= -16)) {
                    CMask cMask;
                    if (bl2) {
                        cRect.left += n7;
                        cRect.top += n8;
                        cRect.right += n7;
                        cRect.bottom += n8;
                    }
                    int n16 = 0;
                    if (s2 == 1) {
                        n16 = 3;
                        bl = false;
                    }
                    if (!bl) {
                        if (n13 != 0) {
                            this.rhFrame.colMask.fillRectangle(cRect.left, cRect.top, cRect.right, cRect.bottom, n16);
                        } else {
                            cMask = this.rhApp.imageBank.getImageFromHandle(s).getMask(CMask.GCMF_OBSTACLE);
                            this.rhFrame.colMask.orMask(cMask, cRect.left, cRect.top, 3, n16);
                        }
                    }
                    if (s2 == 2) {
                        bl = false;
                        if (n13 != 0) {
                            this.rhFrame.colMask.fillRectangle(cRect.left, cRect.top, cRect.right, Math.min(cRect.top + CColMask.HEIGHT_PLATFORM, cRect.bottom), 2);
                        } else {
                            cMask = this.rhApp.imageBank.getImageFromHandle(s).getMask(CMask.GCMF_OBSTACLE);
                            this.rhFrame.colMask.orPlatformMask(cMask, cRect.left, cRect.top);
                        }
                    }
                    if (bl2) {
                        cRect.left -= n7;
                        cRect.top -= n8;
                        cRect.right -= n7;
                        cRect.bottom -= n8;
                    }
                }
                if (cRect.left <= n3 && cRect.top <= n4 && cRect.right >= 0 && cRect.bottom >= 0) {
                    if (n > 0) {
                        int n17 = 0x480008;
                        if (n5 == 0) {
                            n17 |= 0x200;
                        }
                        if (s2 == 1) {
                            n17 |= 0x10001;
                        }
                        if (s2 == 2) {
                            n17 |= 0x20001;
                        }
                        if (cBkd2.pSpr[n14] == null) {
                            cBkd2.pSpr[n14] = this.spriteGen.addSprite(cRect.left, cRect.top, s, cBkd2.nLayer, 0x10000000 + n6 * 4 + n14, 0, n17, null);
                            this.spriteGen.modifSpriteEffect(cBkd2.pSpr[n14], cBkd2.inkEffect, cBkd2.inkEffectParam);
                        } else {
                            this.spriteGen.modifSprite(cBkd2.pSpr[n14], cRect.left, cRect.top, s);
                        }
                    } else if (!bl4) {
                        this.spriteGen.pasteSpriteEffect(graphics2D, s, cRect.left, cRect.top, 0, cBkd2.inkEffect, cBkd2.inkEffectParam);
                    }
                } else if (n > 0 && cBkd2.pSpr[n14] != null) {
                    this.spriteGen.delSprite(cBkd2.pSpr[n14]);
                    cBkd2.pSpr[n14] = null;
                }
                if (n11 == 0) continue;
                --n6;
            }
        }
    }

    public void addBackDrawRoutine(CBackDraw cBackDraw) {
        if (this.rh4BackDrawRoutines == null) {
            this.rh4BackDrawRoutines = new ArrayList();
        }
        this.rh4BackDrawRoutines.add(cBackDraw);
    }

    public void callBackDrawRoutines(Graphics2D graphics2D) {
        if (this.rh4BackDrawRoutines != null) {
            for (int i = 0; i < this.rh4BackDrawRoutines.size(); ++i) {
                CBackDraw cBackDraw = this.rh4BackDrawRoutines.get(i);
                cBackDraw.execute(this, graphics2D);
            }
            this.rh4BackDrawRoutines.clear();
        }
    }

    public void razBackDrawRoutines() {
        if (this.rh4BackDrawRoutines != null) {
            this.rh4BackDrawRoutines.clear();
        }
    }

    public void f_InitLoop() {
        int n;
        int n2;
        int n3;
        long l;
        this.rhTimerOld = l = System.currentTimeMillis();
        this.rhTimer = 0L;
        this.rhLoopCount = 0;
        this.rh4LoopTheoric = 0;
        this.rhVBLOld = this.rhApp.newGetCptVbl() - 1;
        this.rh4VBLDelta = 0;
        this.rhQuit = 0;
        this.rhQuitBis = 0;
        this.rhDestroyPos = 0;
        for (n3 = 0; n3 < (this.rhMaxObjects + 31) / 32; ++n3) {
            this.rhDestroyList[n3] = 0;
        }
        this.rh3WindowSx = this.rhFrame.leEditWinWidth;
        this.rh3WindowSy = this.rhFrame.leEditWinHeight;
        this.rh3XMinimumKill = -480;
        this.rh3YMinimumKill = -300;
        this.rh3XMaximumKill = this.rhLevelSx + 480;
        this.rh3YMaximumKill = this.rhLevelSy + 300;
        this.rh3DisplayX = n3 = this.rhWindowX;
        if ((n3 -= 64) < 0) {
            n3 = this.rh3XMinimumKill;
        }
        this.rh3XMinimum = n3;
        this.rh3DisplayY = n2 = this.rhWindowY;
        if ((n2 -= 16) < 0) {
            n2 = this.rh3YMinimumKill;
        }
        this.rh3YMinimum = n2;
        int n4 = this.rhWindowX;
        if ((n4 += this.rh3WindowSx + 64) > this.rhLevelSx) {
            n4 = this.rh3XMaximumKill;
        }
        this.rh3XMaximum = n4;
        int n5 = this.rhWindowY;
        if ((n5 += this.rh3WindowSy + 16) > this.rhLevelSy) {
            n5 = this.rh3YMaximumKill;
        }
        this.rh3YMaximum = n5;
        this.rh3Scrolling = '\u0000';
        this.rh4DoUpdate = '\u0000';
        this.rh4EventCount = 0;
        this.rh4TimeOut = 0;
        this.rh2PauseCompteur = 0;
        this.rh4FakeKey = 0;
        for (n = 0; n < 4; ++n) {
            this.rhPlayer[n] = 0;
            this.rh2OldPlayer[n] = 0;
            this.rh2InputMask[n] = -1;
        }
        this.rh2MouseKeys = 0;
        if (this.rhMouseUsed != 0) {
            this.rh4MouseXCenter = this.rhFrame.leEditWinWidth / 2;
            this.rh4MouseYCenter = this.rhFrame.leEditWinHeight / 2;
            this.rhApp.setCursorPos(this.rh4MouseXCenter, this.rh4MouseYCenter);
        }
        this.rhEvtProg.rh2ActionEndRoutine = false;
        this.rh4OnCloseCount = -1;
        this.rh4EndOfPause = -1;
        this.rh4OnMouseWheel = -1;
        this.rh4LoadCount = -1;
        this.rhEvtProg.rh4CheckDoneInstart = false;
        this.rh4PauseKey = 0;
        this.rh4DemoMode = 0;
        this.rh4Demo = null;
        for (n = 0; n < 10; ++n) {
            this.rh4FrameRateArray[n] = 20;
        }
        this.rh4FrameRatePos = 0;
        this.razBackDrawRoutines();
    }

    public int f_GameLoop() {
        int n;
        int n2;
        byte by;
        int n3;
        if (this.rh2PauseCompteur != 0) {
            return 0;
        }
        if (this.rhApp.parentApp == null) {
            int n4;
            if ((this.rhGameFlags & 2) != 0) {
                if (this.rh4VBLDelta <= 0) {
                    n4 = this.rhApp.newGetCptVbl();
                    int n5 = n4 - this.rhVBLOld;
                    if (n5 == 0) {
                        if (this.rhQuit == 0) {
                            return this.rhQuitBis;
                        }
                        if (this.rhQuit == 1 || this.rhQuit == 2 || this.rhQuit == -2 || this.rhQuit == 3 || this.rhQuit == 100 || this.rhQuit == 4) {
                            this.rhEvtProg.handle_GlobalEvents(-65539);
                        }
                        return this.rhQuit;
                    }
                    this.rhVBLOld = n4;
                    int n6 = n5 += this.rh4LoopTheoric;
                    if ((n5 -= this.rhLoopCount) > 3) {
                        n5 = 3;
                        n6 = this.rhLoopCount + n5;
                    }
                    this.rh4LoopTheoric = n6;
                    this.rh4VBLDelta = n5;
                }
            } else {
                n4 = this.rhApp.newGetCptVbl();
                if (n4 == this.rhVBLOld) {
                    this.wait(1);
                    if (this.rhQuit == 0) {
                        return this.rhQuitBis;
                    }
                    if (this.rhQuit == 1 || this.rhQuit == 2 || this.rhQuit == -2 || this.rhQuit == 3 || this.rhQuit == 100 || this.rhQuit == 4) {
                        this.rhEvtProg.handle_GlobalEvents(-65539);
                    }
                    return this.rhQuit;
                }
                this.rhVBLOld = n4;
                this.rh4VBLDelta = 1;
            }
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.rhTimerOld;
        long l3 = this.rhTimer;
        this.rhTimer = l2;
        this.rhTimerDelta = (int)(l2 -= l3);
        this.rh4TimeOut = (int)((long)this.rh4TimeOut + l2);
        ++this.rhLoopCount;
        this.rh4MvtTimerCoef = (double)this.rhTimerDelta * (double)this.rhFrame.m_dwMvtTimerBase / 1000.0;
        this.rh4FrameRateArray[this.rh4FrameRatePos] = (int)l2;
        ++this.rh4FrameRatePos;
        if (this.rh4FrameRatePos >= 10) {
            this.rh4FrameRatePos = 0;
        }
        if (this.rh4DemoMode == 2) {
            this.rh4Demo.playStep();
        }
        for (n3 = 0; n3 < 4; ++n3) {
            this.rh2OldPlayer[n3] = this.rhPlayer[n3];
        }
        if (this.rh4DemoMode == 2) {
            for (n3 = 0; n3 < 4; ++n3) {
                this.rhPlayer[n3] = this.rh4Demo.getJoystick(n3);
            }
        } else {
            this.joyTest();
        }
        if (this.rhMouseUsed != 0) {
            if (this.rh4DemoMode == 2) {
                this.rh4Demo.setMousePos();
            }
            this.getMouseCoords();
            this.rh2MouseX = this.rhApp.mouseX - this.rh4MouseXCenter;
            this.rh2MouseY = this.rhApp.mouseY - this.rh4MouseYCenter;
            if (this.rh2MouseX != 0 || this.rh2MouseY != 0) {
                this.rhApp.setCursorPos(this.rh4MouseXCenter, this.rh4MouseYCenter);
            }
            this.rh2MouseKeys = 0;
            by = this.rh4DemoMode == 2 ? (byte)(this.rh4Demo.getKeyState(0) ? 1 : 0) : (byte)(this.rhApp.getKeyState(0) ? 1 : 0);
            if (by != 0) {
                this.rh2MouseKeys = (byte)(this.rh2MouseKeys | 0x10);
            }
            if ((by = this.rh4DemoMode == 2 ? (byte)(this.rh4Demo.getKeyState(2) ? 1 : 0) : (byte)(this.rhApp.getKeyState(2) ? 1 : 0)) != 0) {
                this.rh2MouseKeys = (byte)(this.rh2MouseKeys | 0x20);
            }
            n2 = this.rhMouseUsed;
            for (n3 = 0; n3 < this.rhNPlayers; ++n3) {
                if ((n2 & 1) != 0) {
                    n = (byte)(this.rhPlayer[n3] & 0xCF);
                    this.rhPlayer[n3] = n = (int)((byte)(n | this.rh2MouseKeys));
                }
                n2 = (byte)(n2 >> 1);
            }
        } else {
            this.getMouseCoords();
        }
        for (n3 = 0; n3 < 4; ++n3) {
            by = (byte)(this.rhPlayer[n3] & plMasks[this.rhNPlayers][n3]);
            this.rhPlayer[n3] = by = (byte)(by & this.rh2InputMask[n3]);
            this.rh2NewPlayer[n3] = by = (byte)(by ^ this.rh2OldPlayer[n3]);
            if (by == 0) continue;
            if (((by = (byte)(by & this.rhPlayer[n3])) & 0xF0) != 0) {
                this.rhEvtProg.rhCurOi = (short)n3;
                by = this.rh2NewPlayer[n3];
                if ((by & 0xF0) != 0) {
                    this.rhEvtProg.rhCurParam0 = by;
                    this.rhEvtProg.handle_GlobalEvents(-196615);
                }
                if ((by & 0xF) == 0) continue;
                this.rhEvtProg.rhCurParam0 = by;
                this.rhEvtProg.handle_GlobalEvents(-196615);
                continue;
            }
            n2 = this.rhEvtProg.listPointers[this.rhEvtProg.rhEvents[7] + 4];
            if (n2 == 0) continue;
            this.rhEvtProg.rhCurParam0 = by;
            this.rhEvtProg.computeEventList(n2, null);
        }
        if (this.rhNObjects != 0) {
            n2 = this.rhNObjects;
            n = 0;
            do {
                this.rh4ObjectAddCreate = 0;
                while (this.rhObjectList[n] == null) {
                    ++n;
                }
                CObject cObject = this.rhObjectList[n];
                cObject.hoPrevNoRepeat = cObject.hoBaseNoRepeat;
                cObject.hoBaseNoRepeat = null;
                if (cObject.hoCallRoutine) {
                    this.rh4ObjectCurCreate = n;
                    cObject.handle();
                }
                n2 += this.rh4ObjectAddCreate;
                ++n;
            } while (--n2 != 0);
        }
        this.rh3CollisionCount = (short)(this.rh3CollisionCount + 1);
        this.rhEvtProg.compute_TimerEvents();
        if (this.rhEvtProg.rhEventAlways && (this.rhGameFlags & 0x10) == 0) {
            this.rhEvtProg.computeEventList(0, null);
        }
        this.rhEvtProg.handle_PushedEvents();
        this.modif_ChangedObjects();
        this.destroy_List();
        this.rhEvtProg.rh2CurrentClick = (short)-1;
        this.rhEvtProg.rh3CurrentMenu = 0;
        ++this.rh4EventCount;
        this.rh4FakeKey = 0;
        --this.rh4VBLDelta;
        if ((this.rhGameFlags & 0x10) != 0 || this.rh4VBLDelta <= 0 || this.rhQuit != 0) {
            this.screen_Update();
            if ((this.rhGameFlags & 0x10) == 0) {
                this.screen_Refresh();
            }
        }
        this.wait(1);
        if (this.rhQuit == 0) {
            return this.rhQuitBis;
        }
        if (this.rhQuit == 1 || this.rhQuit == 2 || this.rhQuit == -2 || this.rhQuit == 3 || this.rhQuit == 100 || this.rhQuit == 4) {
            this.rhEvtProg.handle_GlobalEvents(-65539);
        }
        return this.rhQuit;
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void repaintWindow() {
        switch (this.rhApp.displayType) {
            case 0: 
            case 2: {
                this.rhApp.repaintWindow();
                break;
            }
            case 1: {
                Rectangle rectangle = this.rhApp.component.getBounds();
                this.rhApp.component.paintImmediately(0, 0, rectangle.width, rectangle.height);
                break;
            }
            case 4: {
                this.rhApp.component.repaint();
            }
        }
    }

    public void screen_Refresh() {
        switch (this.rhApp.displayType) {
            case 0: {
                if (this.rhApp.bPositionWindow) {
                    int n = this.rhApp.gaCxWin + this.rhApp.insets.left + this.rhApp.insets.right;
                    int n2 = this.rhApp.gaCyWin + this.rhApp.insets.top + this.rhApp.insets.bottom;
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    this.rhApp.window.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
                    this.rhApp.bPositionWindow = false;
                }
            }
            case 2: {
                this.rhApp.repaintWindow();
                break;
            }
            case 1: {
                Cloneable cloneable;
                if (this.rhApp.bPositionWindow) {
                    int n = this.rhApp.gaCxWin + this.rhApp.insets.left + this.rhApp.insets.right;
                    int n3 = this.rhApp.gaCyWin + this.rhApp.insets.top + this.rhApp.insets.bottom;
                    cloneable = Toolkit.getDefaultToolkit().getScreenSize();
                    this.rhApp.window.setLocation((((Dimension)cloneable).width - n) / 2, (((Dimension)cloneable).height - n3) / 2);
                    this.rhApp.bPositionWindow = false;
                }
                if (this.rhApp.bResizeWindow) {
                    if ((this.rhApp.gaOtherFlags & 0x1000) != 0) {
                        cloneable = this.rhApp.window.getBounds();
                        this.rhApp.window.setSize(cloneable.width - 1, cloneable.height);
                        this.rhApp.window.setSize(cloneable.width, cloneable.height);
                    }
                    this.rhApp.bResizeWindow = false;
                }
                this.rhApp.internalPaintFlag = true;
                if ((this.rhApp.gaOtherFlags & 0x1000) != 0) {
                    this.rhApp.component.repaint();
                    break;
                }
                cloneable = this.rhApp.component.getBounds();
                this.rhApp.component.paintImmediately(0, 0, cloneable.width, cloneable.height);
                break;
            }
            case 4: {
                Rectangle rectangle = this.rhApp.component.getBounds();
                this.rhApp.component.paintImmediately(0, 0, rectangle.width, rectangle.height);
            }
        }
    }

    public void modif_ChangedObjects() {
        int n = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.rhObjectList[n];
            ++n;
            if ((cObject.hoOEFlags & 0x230) == 0 || !cObject.roc.rcChanged) continue;
            cObject.modif();
            cObject.roc.rcChanged = false;
        }
    }

    void joyTest() {
        int n;
        for (n = 0; n < 4; ++n) {
            this.rhPlayer[n] = 0;
        }
        short[] sArray = this.rhApp.getCtrlType();
        short[][] sArray2 = this.rhApp.getCtrlKeys();
        block5: for (n = 0; n < 4; ++n) {
            switch (sArray[n]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    continue block5;
                }
                case 5: {
                    for (int i = 0; i < 8; ++i) {
                        if (!this.rhApp.getKeyState(sArray2[n][i])) continue;
                        int n2 = n;
                        this.rhPlayer[n2] = (byte)(this.rhPlayer[n2] | (byte)(1 << i));
                    }
                    continue block5;
                }
            }
        }
    }

    void getMouseCoords() {
        if (this.rh4DemoMode == 2) {
            this.rh2MouseX = this.rh4Demo.getMouseX();
            this.rh2MouseY = this.rh4Demo.getMouseY();
        } else {
            this.rh2MouseX = this.rhApp.mouseX;
            this.rh2MouseY = this.rhApp.mouseY;
        }
        if ((this.rhGameFlags & 0x40) == 0 || (this.rhApp.gaFlags & 0x10) == 0) {
            this.rh2MouseX += this.rhWindowX;
            this.rh2MouseY += this.rhWindowY;
            return;
        }
        double d = (double)this.rhFrame.leEditWinWidth / (double)this.rhApp.sxComponent;
        double d2 = (double)this.rhFrame.leEditWinHeight / (double)this.rhApp.syComponent;
        this.rh2MouseX = (int)((double)this.rhApp.mouseX * d) + this.rhWindowX;
        this.rh2MouseY = (int)((double)this.rhApp.mouseY * d2) + this.rhWindowY;
    }

    public void newHandle_Collisions(CObject cObject) {
        ArrayList<CObject> arrayList;
        int n;
        int n2;
        int n3;
        cObject.rom.rmMoveFlag = false;
        cObject.rom.rmEventFlags = 0;
        if ((cObject.hoLimitFlags & 0x400) != 0) {
            int n4;
            n3 = this.quadran_In(cObject.roc.rcOldX1, cObject.roc.rcOldY1, cObject.roc.rcOldX2, cObject.roc.rcOldY2);
            if (n3 != 0 && (n2 = this.quadran_In(cObject.hoX - cObject.hoImgXSpot, cObject.hoY - cObject.hoImgYSpot, cObject.hoX - cObject.hoImgXSpot + cObject.hoImgWidth, cObject.hoY - cObject.hoImgYSpot + cObject.hoImgHeight)) == 0 && (n4 = n3 ^ n2) != 0) {
                cObject.rom.rmEventFlags = (short)(cObject.rom.rmEventFlags | 1);
                this.rhEvtProg.rhCurParam0 = n4;
                this.rhEvtProg.handle_Event(cObject, 0xFFF50000 | cObject.hoType & 0xFFFF);
            }
            if (((n2 = this.quadran_In(cObject.hoX - cObject.hoImgXSpot, cObject.hoY - cObject.hoImgYSpot, cObject.hoX - cObject.hoImgXSpot + cObject.hoImgWidth, cObject.hoY - cObject.hoImgYSpot + cObject.hoImgHeight)) & cObject.rom.rmWrapping) != 0) {
                if ((n2 & 1) != 0) {
                    cObject.rom.rmMovement.setXPosition(cObject.hoX + this.rhLevelSx);
                } else if ((n2 & 2) != 0) {
                    cObject.rom.rmMovement.setXPosition(cObject.hoX - this.rhLevelSx);
                }
                if ((n2 & 4) != 0) {
                    cObject.rom.rmMovement.setYPosition(cObject.hoY + this.rhLevelSy);
                } else if ((n2 & 8) != 0) {
                    cObject.rom.rmMovement.setYPosition(cObject.hoY - this.rhLevelSy);
                }
            }
            if ((n3 = this.quadran_Out(cObject.roc.rcOldX1, cObject.roc.rcOldY1, cObject.roc.rcOldX2, cObject.roc.rcOldY2)) != 15 && (n = ~n3 & (n4 = this.quadran_Out(cObject.hoX - cObject.hoImgXSpot, cObject.hoY - cObject.hoImgYSpot, cObject.hoX - cObject.hoImgXSpot + cObject.hoImgWidth, cObject.hoY - cObject.hoImgYSpot + cObject.hoImgHeight))) != 0) {
                cObject.rom.rmEventFlags = (short)(cObject.rom.rmEventFlags | 2);
                this.rhEvtProg.rhCurParam0 = n;
                this.rhEvtProg.handle_Event(cObject, 0xFFF40000 | cObject.hoType & 0xFFFF);
            }
        }
        if ((cObject.hoLimitFlags & 0x200) != 0) {
            if (cObject.roc.rcMovementType == 9) {
                CMovePlatform cMovePlatform = (CMovePlatform)cObject.rom.rmMovement;
                cMovePlatform.mpHandle_Background();
            } else {
                n3 = this.colMask_TestObject_IXY(cObject, cObject.roc.rcImage, cObject.roc.rcAngle, cObject.roc.rcScaleX, cObject.roc.rcScaleY, cObject.hoX, cObject.hoY, 0, 1);
                if (n3 != 0) {
                    this.rhEvtProg.handle_Event(cObject, n3);
                }
            }
        }
        if ((cObject.hoLimitFlags & 0x100) != 0 && (arrayList = this.objectAllCol_IXY(cObject, cObject.roc.rcImage, cObject.roc.rcAngle, cObject.roc.rcScaleX, cObject.roc.rcScaleY, cObject.hoX, cObject.hoY)) != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                CObject cObject2 = arrayList.get(n2);
                if ((cObject2.hoFlags & 1) != 0) continue;
                n = cObject.hoType;
                CObject cObject3 = cObject;
                CObject cObject4 = cObject2;
                if (cObject3.hoType > cObject4.hoType) {
                    cObject3 = cObject2;
                    cObject4 = cObject;
                    n = cObject3.hoType;
                }
                this.rhEvtProg.rhCurParam0 = cObject4.hoOi;
                this.rhEvtProg.rh1stObjectNumber = cObject4.hoNumber;
                this.rhEvtProg.handle_Event(cObject3, 0xFFF20000 | n & 0xFFFF);
            }
        }
    }

    public ArrayList<CObject> objectAllCol_IXY(CObject cObject, short s, int n, float f, float f2, int n2, int n3) {
        ArrayList<CObject> arrayList = null;
        if ((cObject.hoFlags & 0x24) != 0) {
            if (cObject.roc.rcSprite != null) {
                arrayList = this.spriteGen.spriteCol_TestSprite_All(cObject.roc.rcSprite, s, n2 - this.rhWindowX, n3 - this.rhWindowY, n, f, f2, 0);
            }
            if ((cObject.hoLimitFlags & 0x1000) != 0) {
                short s2 = cObject.hoFlags;
                cObject.hoFlags = (short)(cObject.hoFlags | 0x2000);
                int n4 = n2 - cObject.hoImgXSpot;
                int n5 = n4 + cObject.hoImgWidth;
                int n6 = n3 - cObject.hoImgYSpot;
                int n7 = n6 + cObject.hoImgHeight;
                int n8 = 0;
                for (int i = 0; i < this.rhNObjects; ++i) {
                    while (this.rhObjectList[n8] == null) {
                        ++n8;
                    }
                    CObject cObject2 = this.rhObjectList[n8];
                    ++n8;
                    if ((cObject2.hoFlags & 0x2024) != 0 || cObject2.hoX - cObject2.hoImgXSpot > n5 || cObject2.hoX - cObject2.hoImgXSpot + cObject2.hoImgWidth < n4 || cObject2.hoY - cObject2.hoImgYSpot > n7 || cObject2.hoY - cObject2.hoImgYSpot + cObject2.hoImgHeight < n6) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(cObject2);
                }
                cObject.hoFlags = s2;
            }
        } else if ((cObject.hoFlags & 0x2000) == 0) {
            short s3 = cObject.hoFlags;
            cObject.hoFlags = (short)(cObject.hoFlags | 0x2000);
            int n9 = n2 - cObject.hoImgXSpot;
            int n10 = n9 + cObject.hoImgWidth;
            int n11 = n3 - cObject.hoImgYSpot;
            int n12 = n11 + cObject.hoImgHeight;
            int n13 = 0;
            for (int i = 0; i < this.rhNObjects; ++i) {
                while (this.rhObjectList[n13] == null) {
                    ++n13;
                }
                CObject cObject3 = this.rhObjectList[n13];
                ++n13;
                if ((cObject3.hoFlags & 0x2000) != 0 || (cObject3.hoLimitFlags & 0x100) == 0 || cObject3.hoX - cObject3.hoImgXSpot > n10 || cObject3.hoX - cObject3.hoImgXSpot + cObject3.hoImgWidth < n9 || cObject3.hoY - cObject3.hoImgYSpot > n12 || cObject3.hoY - cObject3.hoImgYSpot + cObject3.hoImgHeight < n11) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(cObject3);
            }
            cObject.hoFlags = s3;
        }
        return arrayList;
    }

    public int colMask_TestObject_IXY(CObject cObject, short s, int n, float f, float f2, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n2 - this.rhWindowX;
        int n8 = n3 - this.rhWindowY;
        boolean bl = false;
        if ((cObject.hoFlags & 0x24) != 0 && (cObject.ros.rsCreaFlags & 0x100) == 0) {
            bl = true;
        }
        if (bl) {
            CSprite cSprite = cObject.roc.rcSprite;
            if (cSprite != null && this.rhFrame.bkdCol_TestSprite(cSprite, s, n7, n8, n, f, f2, n4, n5)) {
                n6 = 0xFFF30000 | cObject.hoType & 0xFFFF;
            }
        } else {
            n7 -= cObject.hoImgXSpot;
            n8 -= cObject.hoImgYSpot;
            if (n4 != 0) {
                n8 += cObject.hoImgHeight;
                if (this.rhFrame.bkdCol_TestRect(n7, n8 -= n4, cObject.hoImgWidth, n4, cObject.hoLayer, n5)) {
                    n6 = 0xFFF30000 | cObject.hoType & 0xFFFF;
                }
            } else if (this.rhFrame.bkdCol_TestRect(n7, n8, cObject.hoImgWidth, cObject.hoImgHeight, cObject.hoLayer, n5)) {
                n6 = 0xFFF30000 | cObject.hoType & 0xFFFF;
            }
        }
        return n6;
    }

    public int quadran_Out(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (n < 0) {
            n5 |= 1;
        }
        if (n2 < 0) {
            n5 |= 4;
        }
        if (n3 > this.rhLevelSx) {
            n5 |= 2;
        }
        if (n4 > this.rhLevelSy) {
            n5 |= 8;
        }
        return this.Table_InOut[n5];
    }

    public int quadran_In(int n, int n2, int n3, int n4) {
        int n5 = 15;
        if (n < this.rhLevelSx) {
            n5 &= 0xFFFFFFFD;
        }
        if (n2 < this.rhLevelSy) {
            n5 &= 0xFFFFFFF7;
        }
        if (n3 > 0) {
            n5 &= 0xFFFFFFFE;
        }
        if (n4 > 0) {
            n5 &= 0xFFFFFFFB;
        }
        return this.Table_InOut[n5];
    }

    public short random(short s) {
        int n = this.rh3Graine * 31415 + 1;
        this.rh3Graine = (short)n;
        return (short)((n &= 0xFFFF) * s >>> 16);
    }

    public int get_Direction(int n) {
        int n2;
        if (n == 0 || n == -1) {
            return this.random((short)32);
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        for (n2 = 0; n2 < 32; ++n2) {
            if ((n5 & 1) != 0) {
                ++n4;
                n3 = n2;
            }
            n5 >>>= 1;
        }
        if (n4 == 1) {
            return n3;
        }
        n4 = this.random((short)n4);
        n5 = n;
        for (n2 = 0; n2 < 32; ++n2) {
            if ((n5 & 1) != 0 && --n4 < 0) {
                return n2;
            }
            n5 >>>= 1;
        }
        return 0;
    }

    public CValue get_EventExpressionAny(CParamExpression cParamExpression) {
        this.rh4Tokens = cParamExpression.tokens;
        this.rh4CurToken = 0;
        return this.getExpression();
    }

    public int get_EventExpressionInt(CParamExpression cParamExpression) {
        this.rh4Tokens = cParamExpression.tokens;
        this.rh4CurToken = 0;
        return this.getExpression().getInt();
    }

    public double get_EventExpressionDouble(CParamExpression cParamExpression) {
        this.rh4Tokens = cParamExpression.tokens;
        this.rh4CurToken = 0;
        return this.getExpression().getDouble();
    }

    public String get_EventExpressionString(CParamExpression cParamExpression) {
        this.rh4Tokens = cParamExpression.tokens;
        this.rh4CurToken = 0;
        return this.getExpression().getString();
    }

    public int get_ExpressionInt() {
        return this.getExpression().getInt();
    }

    public double get_ExpressionDouble() {
        return this.getExpression().getDouble();
    }

    public String get_ExpressionString() {
        return this.getExpression().getString();
    }

    public CValue getExpression() {
        int n = this.rh4PosPile;
        this.rh4Operators[this.rh4PosPile] = this.rh4OpeNull;
        block0: do {
            ++this.rh4PosPile;
            this.bOperande = true;
            this.rh4Tokens[this.rh4CurToken].evaluate(this);
            this.bOperande = false;
            ++this.rh4CurToken;
            while (true) {
                CExp cExp = this.rh4Tokens[this.rh4CurToken];
                if (cExp.code > 0 && cExp.code < 0x140000) {
                    if (cExp.code > this.rh4Operators[this.rh4PosPile - 1].code) {
                        this.rh4Operators[this.rh4PosPile] = cExp;
                        ++this.rh4CurToken;
                        ++this.rh4PosPile;
                        this.bOperande = true;
                        this.rh4Tokens[this.rh4CurToken].evaluate(this);
                        this.bOperande = false;
                        ++this.rh4CurToken;
                        continue;
                    }
                    --this.rh4PosPile;
                    this.rh4Operators[this.rh4PosPile].evaluate(this);
                    continue;
                }
                --this.rh4PosPile;
                if (this.rh4PosPile == n) continue block0;
                this.rh4Operators[this.rh4PosPile].evaluate(this);
            }
        } while (this.rh4PosPile > n + 1);
        return this.rh4Results[n + 1];
    }

    public CValue getCurrentResult() {
        return this.rh4Results[this.rh4PosPile];
    }

    public CValue getPreviousResult() {
        return this.rh4Results[this.rh4PosPile - 1];
    }

    public CValue getNextResult() {
        return this.rh4Results[this.rh4PosPile + 1];
    }

    public static boolean compareTo(CValue cValue, CValue cValue2, short s) {
        switch (s) {
            case 0: {
                return cValue.equal(cValue2);
            }
            case 1: {
                return cValue.notEqual(cValue2);
            }
            case 2: {
                return cValue.lower(cValue2);
            }
            case 3: {
                return cValue.lowerThan(cValue2);
            }
            case 4: {
                return cValue.greater(cValue2);
            }
            case 5: {
                return cValue.greaterThan(cValue2);
            }
        }
        return false;
    }

    public static boolean compareTer(int n, int n2, short s) {
        switch (s) {
            case 0: {
                return n == n2;
            }
            case 1: {
                return n != n2;
            }
            case 2: {
                return n <= n2;
            }
            case 3: {
                return n < n2;
            }
            case 4: {
                return n >= n2;
            }
            case 5: {
                return n > n2;
            }
        }
        return false;
    }

    public void update_PlayerObjects(int n, short s, int n2) {
        ++n;
        int n3 = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n3] == null) {
                ++n3;
            }
            CObject cObject = this.rhObjectList[n3];
            if (cObject.hoType == s) {
                switch (s) {
                    case 5: {
                        CScore cScore = (CScore)cObject;
                        if (cScore.rsPlayer != n) break;
                        cScore.rsValue.forceInt(n2);
                        break;
                    }
                    case 6: {
                        CLives cLives = (CLives)cObject;
                        if (cLives.rsPlayer != n) break;
                        cLives.rsValue.forceInt(n2);
                    }
                }
                cObject.roc.rcChanged = true;
                cObject.modif();
            }
            ++n3;
        }
    }

    public void actPla_FinishLives(int n, int n2) {
        int[] nArray = this.rhApp.getLives();
        if (n2 == nArray[n]) {
            return;
        }
        if (n2 == 0 && nArray[n] != 0) {
            this.rhEvtProg.push_Event(0, -262151, 0, null, (short)n);
        }
        nArray[n] = n2;
        this.update_PlayerObjects(n, (short)6, n2);
    }

    public boolean getMouseOnObjectsEDX(short s, boolean bl) {
        CObject cObject;
        CObject cObject2 = this.rhEvtProg.evt_FirstObject(s);
        if (cObject2 == null) {
            return bl;
        }
        int n = this.rhEvtProg.evtNSelectedObjects;
        int n2 = this.rh2MouseX - this.rhWindowX;
        int n3 = this.rh2MouseY - this.rhWindowY;
        ArrayList<CObject> arrayList = new ArrayList<CObject>();
        CSprite cSprite = this.spriteGen.spriteCol_TestPoint(null, (short)-1, n2, n3, 0);
        while (cSprite != null) {
            cObject = cSprite.sprExtraInfo;
            if ((cObject.hoFlags & 1) == 0) {
                arrayList.add(cObject);
            }
            cSprite = this.spriteGen.spriteCol_TestPoint(cSprite, (short)-1, n2, n3, 0);
        }
        int n4 = 0;
        for (int i = 0; i < this.rhNObjects; ++i) {
            while (this.rhObjectList[n4] == null) {
                ++n4;
            }
            cObject = this.rhObjectList[n4];
            ++n4;
            if ((cObject.hoFlags & 0x2004) != 0) continue;
            int n5 = cObject.hoX - this.rhWindowX - cObject.hoImgXSpot;
            int n6 = n5 + cObject.hoImgWidth;
            int n7 = cObject.hoY - this.rhWindowY - cObject.hoImgYSpot;
            int n8 = n7 + cObject.hoImgHeight;
            if (n2 < n5 || n2 >= n6 || n3 < n7 || n3 >= n8 || (cObject.hoFlags & 1) != 0) continue;
            arrayList.add(cObject);
        }
        if (arrayList.size() == 0) {
            return bl;
        }
        if (!bl) {
            do {
                for (n4 = 0; n4 < arrayList.size() && (cObject = (CObject)arrayList.get(n4)) != cObject2; ++n4) {
                }
                if (n4 != arrayList.size()) continue;
                --n;
                this.rhEvtProg.evt_DeleteCurrentObject();
            } while ((cObject2 = this.rhEvtProg.evt_NextObject()) != null);
            return n != 0;
        }
        do {
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                cObject = (CObject)arrayList.get(n4);
                if (cObject != cObject2) continue;
                return false;
            }
        } while ((cObject2 = this.rhEvtProg.evt_NextObject()) != null);
        return true;
    }

    public int txtDisplay(CEvent cEvent, short s, int n) {
        PARAM_CREATE pARAM_CREATE = (PARAM_CREATE)cEvent.evtParams[0];
        CPositionInfo cPositionInfo = new CPositionInfo();
        if (pARAM_CREATE.read_Position(this, 16, cPositionInfo)) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.rhNObjects; ++n2) {
                while (this.rhObjectList[n3] == null) {
                    ++n3;
                }
                CObject cObject = this.rhObjectList[n3];
                ++n3;
                if (cObject.hoType != 3 || cObject.hoOi != s || cObject.hoX != cPositionInfo.x || cObject.hoY != cPositionInfo.y) continue;
                cObject.ros.obShow();
                cObject.hoFlags = (short)(cObject.hoFlags & 0xFFFFDFFF);
                CText cText = (CText)cObject;
                cText.rsMini = -2;
                cText.txtChange(n);
                cObject.roc.rcChanged = true;
                cObject.display();
                cObject.ros.rsFlash = 0;
                cObject.ros.rsFlags = (short)(cObject.ros.rsFlags | 0x20);
                return cObject.hoNumber;
            }
            n2 = this.f_CreateObject((short)-1, s, cPositionInfo.x, cPositionInfo.y, 0, (short)0, this.rhFrame.nLayers - 1, -1);
            if (n2 >= 0) {
                ((CText)this.rhObjectList[n2]).txtChange(n);
                return n2;
            }
        }
        return -1;
    }

    public int txtDoDisplay(CEvent cEvent, int n) {
        if (cEvent.evtOiList >= 0) {
            return this.txtDisplay(cEvent, cEvent.evtOi, n);
        }
        if (cEvent.evtOiList == -1) {
            return -1;
        }
        int n2 = cEvent.evtOiList & Short.MAX_VALUE;
        CQualToOiList cQualToOiList = this.rhEvtProg.qualToOiList[n2];
        for (int i = 0; i < cQualToOiList.qoiList.length; i += 2) {
            this.txtDisplay(cEvent, cQualToOiList.qoiList[i], n);
        }
        return -1;
    }

    public static CFontInfo getObjectFont(CObject cObject) {
        CFontInfo cFontInfo = null;
        if (cObject.hoType >= 32) {
            CExtension cExtension = (CExtension)cObject;
            cFontInfo = cExtension.ext.getRunObjectFont();
        } else {
            switch (cObject.hoType) {
                case 3: {
                    CText cText = (CText)cObject;
                    cFontInfo = cText.getFont();
                    break;
                }
                case 5: {
                    CScore cScore = (CScore)cObject;
                    cFontInfo = cScore.getFont();
                    break;
                }
                case 6: {
                    CLives cLives = (CLives)cObject;
                    cFontInfo = cLives.getFont();
                    break;
                }
                case 7: {
                    CCounter cCounter = (CCounter)cObject;
                    cFontInfo = cCounter.getFont();
                }
            }
        }
        if (cFontInfo == null) {
            cFontInfo = new CFontInfo();
        }
        return cFontInfo;
    }

    public static void setObjectFont(CObject cObject, CFontInfo cFontInfo, CRect cRect) {
        if (cObject.hoType >= 32) {
            CExtension cExtension = (CExtension)cObject;
            cExtension.ext.setRunObjectFont(cFontInfo, cRect);
        } else {
            switch (cObject.hoType) {
                case 3: {
                    CText cText = (CText)cObject;
                    cText.setFont(cFontInfo, cRect);
                    break;
                }
                case 5: {
                    CScore cScore = (CScore)cObject;
                    cScore.setFont(cFontInfo, cRect);
                    break;
                }
                case 6: {
                    CLives cLives = (CLives)cObject;
                    cLives.setFont(cFontInfo, cRect);
                    break;
                }
                case 7: {
                    CCounter cCounter = (CCounter)cObject;
                    cCounter.setFont(cFontInfo, cRect);
                }
            }
        }
    }

    public static int getObjectTextColor(CObject cObject) {
        if (cObject.hoType >= 32) {
            CExtension cExtension = (CExtension)cObject;
            return cExtension.ext.getRunObjectTextColor();
        }
        switch (cObject.hoType) {
            case 3: {
                CText cText = (CText)cObject;
                return cText.getFontColor();
            }
            case 5: {
                CScore cScore = (CScore)cObject;
                return cScore.getFontColor();
            }
            case 6: {
                CLives cLives = (CLives)cObject;
                return cLives.getFontColor();
            }
            case 7: {
                CCounter cCounter = (CCounter)cObject;
                return cCounter.getFontColor();
            }
        }
        return 0;
    }

    public static void setObjectTextColor(CObject cObject, int n) {
        if (cObject.hoType >= 32) {
            CExtension cExtension = (CExtension)cObject;
            cExtension.ext.setRunObjectTextColor(n);
        } else {
            switch (cObject.hoType) {
                case 3: {
                    CText cText = (CText)cObject;
                    cText.setFontColor(n);
                    break;
                }
                case 5: {
                    CScore cScore = (CScore)cObject;
                    cScore.setFontColor(n);
                    break;
                }
                case 6: {
                    CLives cLives = (CLives)cObject;
                    cLives.setFontColor(n);
                    break;
                }
                case 7: {
                    CCounter cCounter = (CCounter)cObject;
                    cCounter.setFontColor(n);
                }
            }
        }
    }

    public static void setXPosition(CObject cObject, int n) {
        if (cObject.rom != null) {
            cObject.rom.rmMovement.setXPosition(n);
        } else if (cObject.hoX != n) {
            cObject.hoX = n;
            if (cObject.roc != null) {
                cObject.roc.rcChanged = true;
                cObject.roc.rcCheckCollides = true;
            }
        }
    }

    public static void setYPosition(CObject cObject, int n) {
        if (cObject.rom != null) {
            cObject.rom.rmMovement.setYPosition(n);
        } else if (cObject.hoY != n) {
            cObject.hoY = n;
            if (cObject.roc != null) {
                cObject.roc.rcChanged = true;
                cObject.roc.rcCheckCollides = true;
            }
        }
    }

    public static int get_DirFromPente(int n, int n2) {
        if (n == 0) {
            if (n2 >= 0) {
                return 24;
            }
            return 8;
        }
        if (n2 == 0) {
            if (n >= 0) {
                return 0;
            }
            return 16;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (n2 < 0) {
            bl2 = true;
            n2 = -n2;
        }
        int n3 = n * 256 / n2;
        int n4 = 0;
        while (n3 < CMove.CosSurSin32[n4]) {
            n4 += 2;
        }
        int n5 = CMove.CosSurSin32[n4 + 1];
        if (bl2) {
            n5 = -n5 + 32;
            n5 &= 0x1F;
        }
        if (bl) {
            n5 -= 8;
            n5 &= 0x1F;
            n5 = -n5;
            n5 &= 0x1F;
            n5 += 8;
            n5 &= 0x1F;
        }
        return n5;
    }

    public void init_Disappear(CObject cObject) {
        boolean bl = false;
        int n = 0;
        if ((cObject.hoFlags & 8) == 0) {
            if (!cObject.ros.createFadeSprite(true) && (cObject.hoOEFlags & 0x20) != 0 && cObject.roa.anim_Exist(4)) {
                n = 1;
            }
            if ((cObject.hoFlags & 0x10) != 0) {
                n |= 2;
            }
            if (n == 0) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            cObject.hoCallRoutine = false;
            this.destroy_Add(cObject.hoNumber);
            return;
        }
        if (cObject.roc.rcSprite != null) {
            cObject.roc.rcSprite.setSpriteColFlag(0);
        }
        if (cObject.rom != null) {
            cObject.rom.initSimple(cObject, 11, false);
            cObject.roc.rcSpeed = 0;
        }
        if ((n & 1) != 0) {
            cObject.roa.animation_Force(4);
            cObject.roa.animation_OneLoop();
        }
    }

    public void display_OwnerQuickDisplay(CObject cObject) {
        if (cObject.hoNextQuickDisplay == -1) {
            if (this.rh4LastQuickDisplay >= 0) {
                CObject cObject2 = this.rhObjectList[this.rh4LastQuickDisplay];
                cObject2.hoNextQuickDisplay = cObject.hoNumber;
                this.rh4LastQuickDisplay = cObject.hoNumber;
                cObject.hoNextQuickDisplay = (short)-3;
            } else {
                cObject.hoNextQuickDisplay = (short)-3;
                this.rh4FirstQuickDisplay = cObject.hoNumber;
                this.rh4LastQuickDisplay = cObject.hoNumber;
            }
        }
    }

    void erase_QuickDisplay(Graphics2D graphics2D) {
        short s = this.rh4FirstQuickDisplay;
        CObject cObject = null;
        while (s >= 0) {
            CObject cObject2 = cObject;
            cObject = this.rhObjectList[s];
            cObject.restoreBack(graphics2D);
            s = cObject.hoNextQuickDisplay;
            if (cObject.hoCreationId != 0) continue;
            this.rqd_Found(cObject, cObject2);
            cObject.killBack();
            this.rhObjectList[cObject.hoNumber] = null;
            --this.rhNObjects;
            cObject = cObject2;
        }
    }

    public void save_QuickDisplay(BufferedImage bufferedImage) {
        short s = this.rh4FirstQuickDisplay;
        while (s >= 0) {
            CObject cObject = this.rhObjectList[s];
            if ((cObject.ros.rsFlags & 5) == 0) {
                cObject.ros.objGetZoneInfos();
                if ((cObject.hoOEFlags & 4) != 0) {
                    cObject.saveBack(bufferedImage);
                }
            }
            s = cObject.hoNextQuickDisplay;
        }
    }

    public void draw_QuickDisplay(Graphics2D graphics2D) {
        short s = this.rh4FirstQuickDisplay;
        while (s >= 0) {
            CObject cObject = this.rhObjectList[s];
            if ((cObject.ros.rsFlags & 5) == 0) {
                cObject.draw(graphics2D);
                s = cObject.hoNextQuickDisplay;
                cObject.hoNextQuickDisplay = (short)-1;
                continue;
            }
            s = cObject.hoNextQuickDisplay;
            cObject.hoNextQuickDisplay = (short)-2;
        }
        this.rh4FirstQuickDisplay = Short.MIN_VALUE;
        this.rh4LastQuickDisplay = Short.MIN_VALUE;
    }

    public void remove_QuickDisplay(CObject cObject) {
        CObject cObject2;
        CObject cObject3 = null;
        short s = this.rh4FirstQuickDisplay;
        while (s >= 0 && (cObject2 = this.rhObjectList[s]) != cObject) {
            cObject3 = cObject2;
            s = cObject2.hoNextQuickDisplay;
        }
        if (s >= 0) {
            this.rqd_Found(cObject, cObject3);
        }
    }

    void rqd_Found(CObject cObject, CObject cObject2) {
        short s = cObject.hoNextQuickDisplay;
        if (cObject2 == null) {
            this.rh4FirstQuickDisplay = s;
        } else {
            cObject2.hoNextQuickDisplay = s;
        }
        if (cObject.hoNumber == this.rh4LastQuickDisplay) {
            this.rh4LastQuickDisplay = cObject2 == null ? (short)Short.MIN_VALUE : cObject2.hoNumber;
        }
    }

    public CExtStorage getStorage(int n) {
        if (this.rhApp.extensionStorage != null) {
            for (int i = 0; i < this.rhApp.extensionStorage.size(); ++i) {
                CExtStorage cExtStorage = this.rhApp.extensionStorage.get(i);
                if (cExtStorage.id != n) continue;
                return cExtStorage;
            }
        }
        return null;
    }

    public void delStorage(int n) {
        if (this.rhApp.extensionStorage != null) {
            for (int i = 0; i < this.rhApp.extensionStorage.size(); ++i) {
                CExtStorage cExtStorage = this.rhApp.extensionStorage.get(i);
                if (cExtStorage.id != n) continue;
                this.rhApp.extensionStorage.remove(i);
            }
        }
    }

    public void addStorage(CExtStorage cExtStorage, int n) {
        CExtStorage cExtStorage2 = this.getStorage(n);
        if (cExtStorage2 == null) {
            if (this.rhApp.extensionStorage == null) {
                this.rhApp.extensionStorage = new ArrayList();
            }
            cExtStorage.id = n;
            this.rhApp.extensionStorage.add(cExtStorage);
        }
    }

    public boolean isMouseOn() {
        return this.rh4CursorCount > 0;
    }

    public static void objectHide(CObject cObject) {
        if (cObject.ros != null) {
            cObject.ros.obHide();
            cObject.ros.rsFlags = (short)(cObject.ros.rsFlags & 0xFFFFFFDF);
            cObject.ros.rsFlash = 0;
        } else {
            ((CRtf)cObject).setVisible(false);
        }
    }

    public static void objectShow(CObject cObject) {
        if (cObject.ros != null) {
            cObject.ros.obShow();
            cObject.ros.rsFlags = (short)(cObject.ros.rsFlags | 0x20);
            cObject.ros.rsFlash = 0;
        } else if (cObject instanceof CRtf) {
            ((CRtf)cObject).setVisible(true);
        }
    }

    public void setFrameRate(int n) {
        if (n >= 1 && n <= 1000) {
            CRunApp cRunApp = this.rhApp;
            while (cRunApp.parentApp != null) {
                cRunApp = cRunApp.parentApp;
            }
            cRunApp.gaFrameRate = n;
            cRunApp.refTime = System.currentTimeMillis() - (long)((int)((double)this.rhVBLOld * 1000.0 / (double)this.rhApp.gaFrameRate));
        }
    }

    public int getXMouse() {
        if (this.rhMouseUsed != 0) {
            return 0;
        }
        return this.rh2MouseX;
    }

    public int getYMouse() {
        if (this.rhMouseUsed != 0) {
            return 0;
        }
        return this.rh2MouseY;
    }

    public int getRGBAt(CObject cObject, int n, int n2) {
        int n3 = 0;
        if (cObject.roc.rcImage != -1) {
            CImage cImage = this.rhApp.imageBank.getImageFromHandle(cObject.roc.rcImage);
            int[] nArray = new int[cImage.width * cImage.height];
            PixelGrabber pixelGrabber = new PixelGrabber(cImage.img, 0, 0, (int)cImage.width, (int)cImage.height, nArray, 0, (int)cImage.width);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n3 = nArray[n2 * cImage.width + n] & 0xFFFFFF;
            n3 = CServices.swapRGB(n3);
        }
        return n3;
    }

    DataOutputStream openSaveFile() {
        String string = null;
        string = this.rh4PSaveFilename;
        try {
            if (string.length() != 0) {
                return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new CSaveFilter());
            this.pause();
            int n = jFileChooser.showSaveDialog(this.rhApp.window);
            this.resume();
            if (n != 0) {
                return null;
            }
            File file = jFileChooser.getSelectedFile();
            String string2 = CServices.getExtension(file);
            if (string2 == null) {
                string = file.getAbsolutePath();
                string = string + ".mfs";
                file = new File(string);
            }
            return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.reportError(7);
            return null;
        }
    }

    public boolean saveFramePosition(DataOutputStream dataOutputStream) {
        boolean bl = false;
        if (dataOutputStream == null) {
            dataOutputStream = this.openSaveFile();
            if (dataOutputStream == null) {
                return false;
            }
            bl = true;
        }
        boolean bl2 = true;
        try {
            Object object;
            Object object2;
            Object object3;
            int n;
            CObject cObject;
            int n2;
            String string;
            CValue cValue;
            int n3;
            int n4 = -855703551;
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeUTF(this.rhApp.appName);
            short s = (short)this.rhApp.currentFrame;
            dataOutputStream.writeShort(s);
            dataOutputStream.writeInt(this.rh4SaveVersion);
            dataOutputStream.writeInt(this.rhNPlayers);
            dataOutputStream.writeByte(this.rhMouseUsed);
            dataOutputStream.writeShort(this.rhGameFlags);
            dataOutputStream.writeInt(this.rhWindowX);
            dataOutputStream.writeInt(this.rhWindowY);
            dataOutputStream.writeInt(this.rhLoopCount);
            dataOutputStream.writeLong(this.rhTimer);
            dataOutputStream.writeLong(this.rhTimerOld - System.currentTimeMillis());
            for (n3 = 0; n3 < 4; ++n3) {
                dataOutputStream.writeByte(this.rh2InputMask[n3]);
            }
            dataOutputStream.writeShort(this.rh2CreationCount);
            dataOutputStream.writeShort(this.rh3Graine);
            dataOutputStream.writeInt(this.rh3DisplayX);
            dataOutputStream.writeInt(this.rh3DisplayY);
            dataOutputStream.writeInt(this.rh3WindowSx);
            dataOutputStream.writeInt(this.rh3WindowSy);
            dataOutputStream.writeInt(this.rh3XMinimum);
            dataOutputStream.writeInt(this.rh3YMinimum);
            dataOutputStream.writeInt(this.rh3XMaximum);
            dataOutputStream.writeInt(this.rh3YMaximum);
            dataOutputStream.writeInt(this.rh3XMinimumKill);
            dataOutputStream.writeInt(this.rh3YMinimumKill);
            dataOutputStream.writeInt(this.rh3XMaximumKill);
            dataOutputStream.writeInt(this.rh3YMaximumKill);
            dataOutputStream.writeInt(this.rh4VBLDelta);
            dataOutputStream.writeInt(this.rh4LoopTheoric);
            dataOutputStream.writeInt(this.rh4EventCount);
            dataOutputStream.writeInt(this.rh4WindowDeltaX);
            dataOutputStream.writeInt(this.rh4WindowDeltaY);
            dataOutputStream.writeInt(this.rh4TimeOut);
            dataOutputStream.writeInt(this.rhFrame.leX);
            dataOutputStream.writeInt(this.rhFrame.leY);
            dataOutputStream.writeInt(this.rhFrame.leLastScrlX);
            dataOutputStream.writeInt(this.rhFrame.leLastScrlY);
            dataOutputStream.writeInt(this.rhFrame.leWidth);
            dataOutputStream.writeInt(this.rhFrame.leHeight);
            this.rhFrame.leVirtualRect.write(dataOutputStream);
            dataOutputStream.writeInt(this.rhFrame.leBackground);
            for (n3 = 0; n3 < this.rhFrame.nLayers; ++n3) {
                CLayer cLayer = this.rhFrame.layers[n3];
                dataOutputStream.writeInt(cLayer.x);
                dataOutputStream.writeInt(cLayer.y);
                dataOutputStream.writeInt(cLayer.dx);
                dataOutputStream.writeInt(cLayer.dy);
                dataOutputStream.writeInt(cLayer.dwOptions);
                dataOutputStream.writeFloat(cLayer.xCoef);
                dataOutputStream.writeFloat(cLayer.yCoef);
            }
            for (n3 = 0; n3 < 4; ++n3) {
                dataOutputStream.writeInt(this.rhApp.scores[n3]);
            }
            for (n3 = 0; n3 < 4; ++n3) {
                dataOutputStream.writeInt(this.rhApp.lives[n3]);
            }
            int n5 = this.rhApp.gValues.size();
            dataOutputStream.writeInt(n5);
            for (n3 = 0; n3 < n5; ++n3) {
                cValue = this.rhApp.getGlobalValueAt(n3);
                cValue.write(dataOutputStream);
            }
            int n6 = this.rhApp.gStrings.size();
            dataOutputStream.writeInt(n6);
            for (n3 = 0; n3 < n6; ++n3) {
                string = this.rhApp.getGlobalStringAt(n3);
                dataOutputStream.writeUTF(string);
            }
            int n7 = 0;
            COI cOI = this.rhApp.OIList.getFirstOI();
            while (cOI != null) {
                if (cOI.oiType >= 2) {
                    ++n7;
                }
                cOI = this.rhApp.OIList.getNextOI();
            }
            dataOutputStream.writeInt(n7);
            int n8 = this.rhNObjects;
            n7 = 0;
            for (n2 = 0; n2 < this.rhNObjects; ++n2) {
                while (this.rhObjectList[n7] == null) {
                    ++n7;
                }
                cObject = this.rhObjectList[n7];
                ++n7;
                if (cObject.hoCreationId != 0) continue;
                --n8;
            }
            dataOutputStream.writeInt(n8);
            n7 = 0;
            block36: for (n2 = 0; n2 < this.rhNObjects; ++n2) {
                Object object4;
                Object object5;
                Object object6;
                while (this.rhObjectList[n7] == null) {
                    ++n7;
                }
                cObject = this.rhObjectList[n7];
                ++n7;
                if (cObject.hoCreationId == 0) continue;
                dataOutputStream.writeShort(cObject.hoNumber);
                dataOutputStream.writeShort(cObject.hoHFII);
                dataOutputStream.writeShort(cObject.hoOi);
                dataOutputStream.writeInt(cObject.hoX);
                dataOutputStream.writeInt(cObject.hoY);
                dataOutputStream.writeInt(cObject.hoLayer);
                int n9 = -1;
                if (cObject.roc != null) {
                    n9 = cObject.roc.rcDir;
                }
                dataOutputStream.writeInt(n9);
                dataOutputStream.writeShort(cObject.hoFlags);
                dataOutputStream.writeShort(cObject.hoCreationId);
                dataOutputStream.writeInt(cObject.hoX);
                dataOutputStream.writeInt(cObject.hoY);
                dataOutputStream.writeInt(cObject.hoCalculX);
                dataOutputStream.writeInt(cObject.hoCalculY);
                dataOutputStream.writeInt(cObject.hoImgXSpot);
                dataOutputStream.writeInt(cObject.hoImgYSpot);
                dataOutputStream.writeInt(cObject.hoImgWidth);
                dataOutputStream.writeInt(cObject.hoImgHeight);
                cObject.hoRect.write(dataOutputStream);
                dataOutputStream.writeInt(cObject.hoOEFlags);
                dataOutputStream.writeInt(cObject.hoIdentifier);
                n = 0;
                if (cObject.hoBaseNoRepeat != null) {
                    n = cObject.hoBaseNoRepeat.size();
                }
                dataOutputStream.writeInt(n);
                for (n3 = 0; n3 < n; ++n3) {
                    Integer n10 = cObject.hoBaseNoRepeat.get(n3);
                    dataOutputStream.writeInt(n10);
                }
                dataOutputStream.writeInt(cObject.roc.rcMovementType);
                if (cObject.rom != null) {
                    dataOutputStream.writeInt(cObject.rom.rmMovement.rmAcc);
                    dataOutputStream.writeInt(cObject.rom.rmMovement.rmDec);
                    dataOutputStream.writeInt(cObject.rom.rmMovement.rmStopSpeed);
                    dataOutputStream.writeInt(cObject.rom.rmMovement.rmAccValue);
                    dataOutputStream.writeInt(cObject.rom.rmMovement.rmDecValue);
                    dataOutputStream.writeShort(cObject.rom.rmEventFlags);
                    dataOutputStream.writeInt(cObject.rom.rmReverse);
                    dataOutputStream.writeBoolean(cObject.rom.rmBouncing);
                    dataOutputStream.writeInt(cObject.rom.rmMvtNum);
                    switch (cObject.roc.rcMovementType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            object3 = (CMoveMouse)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_DXMouse);
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_DYMouse);
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_FXMouse);
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_FYMouse);
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_Stopped);
                            dataOutputStream.writeInt(((CMoveMouse)object3).MM_OldSpeed);
                            break;
                        }
                        case 2: {
                            object6 = (CMoveRace)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_Bounce);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_BounceMu);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_Speed);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_RotSpeed);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_RotCpt);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_RotPos);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_RotMask);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_OkReverse);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_OldJoy);
                            dataOutputStream.writeInt(((CMoveRace)object6).MR_LastBounce);
                            break;
                        }
                        case 3: {
                            object2 = (CMoveGeneric)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_Bounce);
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_OkDirs);
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_BounceMu);
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_Speed);
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_LastBounce);
                            dataOutputStream.writeInt(((CMoveGeneric)object2).MG_DirMask);
                            break;
                        }
                        case 4: {
                            object5 = (CMoveBall)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_StartDir);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_Angles);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_Securite);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_SecuCpt);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_Bounce);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_Speed);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_MaskBounce);
                            dataOutputStream.writeInt(((CMoveBall)object5).MB_LastBounce);
                            dataOutputStream.writeBoolean(((CMoveBall)object5).MB_Blocked);
                            break;
                        }
                        case 5: {
                            object = (CMovePath)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMovePath)object).MT_Speed);
                            dataOutputStream.writeInt(((CMovePath)object).MT_Sinus);
                            dataOutputStream.writeInt(((CMovePath)object).MT_Cosinus);
                            dataOutputStream.writeInt(((CMovePath)object).MT_Longueur);
                            dataOutputStream.writeInt(((CMovePath)object).MT_XOrigin);
                            dataOutputStream.writeInt(((CMovePath)object).MT_YOrigin);
                            dataOutputStream.writeInt(((CMovePath)object).MT_XDest);
                            dataOutputStream.writeInt(((CMovePath)object).MT_YDest);
                            dataOutputStream.writeInt(((CMovePath)object).MT_MoveNumber);
                            dataOutputStream.writeBoolean(((CMovePath)object).MT_Direction);
                            dataOutputStream.writeInt(((CMovePath)object).MT_Calculs);
                            dataOutputStream.writeInt(((CMovePath)object).MT_XStart);
                            dataOutputStream.writeInt(((CMovePath)object).MT_YStart);
                            dataOutputStream.writeInt(((CMovePath)object).MT_Pause);
                            if (((CMovePath)object).MT_GotoNode == null) {
                                dataOutputStream.writeUTF("");
                                break;
                            }
                            dataOutputStream.writeUTF(((CMovePath)object).MT_GotoNode);
                            break;
                        }
                        case 9: {
                            object4 = (CMovePlatform)cObject.rom.rmMovement;
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_Type);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_Bounce);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_BounceMu);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_XSpeed);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_Gravity);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_Jump);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_YSpeed);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_XMB);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_YMB);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_HTFOOT);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_JumpControl);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_JumpStopped);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_PreviousDir);
                            int n11 = -1;
                            if (((CMovePlatform)object4).MP_ObjectUnder != null) {
                                n11 = ((CMovePlatform)object4).MP_ObjectUnder.hoNumber;
                            }
                            dataOutputStream.writeInt(n11);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_XObjectUnder);
                            dataOutputStream.writeInt(((CMovePlatform)object4).MP_YObjectUnder);
                            break;
                        }
                        case 11: {
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 13: {
                            CMoveBullet cMoveBullet = (CMoveBullet)cObject.rom.rmMovement;
                            dataOutputStream.writeBoolean(cMoveBullet.MBul_Wait);
                            int n12 = -1;
                            if (cMoveBullet.MBul_ShootObject != null) {
                                n12 = cMoveBullet.MBul_ShootObject.hoNumber;
                            }
                            dataOutputStream.writeInt(n12);
                            break;
                        }
                        case 14: {
                            CMoveExtension cMoveExtension = (CMoveExtension)cObject.rom.rmMovement;
                            cMoveExtension.callSavePosition(dataOutputStream);
                        }
                    }
                }
                if (cObject.roc != null) {
                    dataOutputStream.writeInt(cObject.roc.rcPlayer);
                    dataOutputStream.writeInt(cObject.roc.rcMovementType);
                    dataOutputStream.writeInt(cObject.roc.rcAnim);
                    dataOutputStream.writeShort(cObject.roc.rcImage);
                    dataOutputStream.writeFloat(cObject.roc.rcScaleX);
                    dataOutputStream.writeFloat(cObject.roc.rcScaleY);
                    dataOutputStream.writeInt(cObject.roc.rcAngle);
                    dataOutputStream.writeInt(cObject.roc.rcDir);
                    dataOutputStream.writeInt(cObject.roc.rcSpeed);
                    dataOutputStream.writeInt(cObject.roc.rcMinSpeed);
                    dataOutputStream.writeInt(cObject.roc.rcMaxSpeed);
                    dataOutputStream.writeInt(cObject.roc.rcOldX);
                    dataOutputStream.writeInt(cObject.roc.rcOldY);
                    dataOutputStream.writeShort(cObject.roc.rcOldImage);
                    dataOutputStream.writeInt(cObject.roc.rcOldAngle);
                    dataOutputStream.writeInt(cObject.roc.rcOldDir);
                    dataOutputStream.writeInt(cObject.roc.rcOldX1);
                    dataOutputStream.writeInt(cObject.roc.rcOldY1);
                    dataOutputStream.writeInt(cObject.roc.rcOldX2);
                    dataOutputStream.writeInt(cObject.roc.rcOldX2);
                }
                if (cObject.roa != null) {
                    dataOutputStream.writeInt(cObject.roa.raAnimForced);
                    dataOutputStream.writeInt(cObject.roa.raAnimDirForced);
                    dataOutputStream.writeInt(cObject.roa.raAnimSpeedForced);
                    dataOutputStream.writeBoolean(cObject.roa.raAnimStopped);
                    dataOutputStream.writeInt(cObject.roa.raAnimOn);
                    dataOutputStream.writeInt(cObject.roa.raAnimDir);
                    dataOutputStream.writeInt(cObject.roa.raAnimPreviousDir);
                    dataOutputStream.writeInt(cObject.roa.raAnimSpeed);
                    dataOutputStream.writeInt(cObject.roa.raAnimMinSpeed);
                    dataOutputStream.writeInt(cObject.roa.raAnimMaxSpeed);
                    dataOutputStream.writeInt(cObject.roa.raAnimDeltaSpeed);
                    dataOutputStream.writeInt(cObject.roa.raAnimCounter);
                    dataOutputStream.writeInt(cObject.roa.raAnimDelta);
                    dataOutputStream.writeInt(cObject.roa.raAnimRepeat);
                    dataOutputStream.writeInt(cObject.roa.raAnimRepeatLoop);
                    dataOutputStream.writeInt(cObject.roa.raAnimFrame);
                    dataOutputStream.writeInt(cObject.roa.raAnimNumberOfFrame);
                    dataOutputStream.writeInt(cObject.roa.raAnimFrameForced);
                    dataOutputStream.writeInt(cObject.roa.raRoutineAnimation);
                }
                if (cObject.ros != null) {
                    dataOutputStream.writeInt(cObject.ros.rsFlash);
                    dataOutputStream.writeInt(cObject.ros.rsFlashCpt);
                    dataOutputStream.writeShort(cObject.ros.rsLayer);
                    dataOutputStream.writeInt(cObject.ros.rsZOrder);
                    dataOutputStream.writeInt(cObject.ros.rsCreaFlags);
                    dataOutputStream.writeInt(cObject.ros.rsBackColor);
                    dataOutputStream.writeInt(cObject.ros.rsEffect);
                    dataOutputStream.writeInt(cObject.ros.rsEffectParam);
                    dataOutputStream.writeShort(cObject.ros.rsFlags);
                    dataOutputStream.writeShort(cObject.ros.rsFadeCreaFlags);
                    dataOutputStream.writeShort(cObject.ros.rsSpriteType);
                    if (cObject.ros.rsTrans != null) {
                        dataOutputStream.writeByte(1);
                        long l = System.currentTimeMillis();
                        dataOutputStream.writeLong(cObject.ros.rsTrans.m_initTime - l);
                        dataOutputStream.writeLong(cObject.ros.rsTrans.m_currentTime - l);
                        dataOutputStream.writeLong(cObject.ros.rsTrans.m_endTime - l);
                        dataOutputStream.writeInt(cObject.ros.rsTrans.m_duration);
                        dataOutputStream.writeBoolean(cObject.ros.rsTrans.m_overflow);
                        dataOutputStream.writeBoolean(cObject.ros.rsTrans.m_running);
                        dataOutputStream.writeBoolean(cObject.ros.rsTrans.m_starting);
                    } else {
                        dataOutputStream.writeByte(0);
                    }
                }
                if (cObject.rov != null) {
                    CValue cValue2 = new CValue();
                    for (n3 = 0; n3 < 26; ++n3) {
                        cValue = cObject.rov.rvValues[n3];
                        if (cValue == null) {
                            cValue = cValue2;
                        }
                        cValue.write(dataOutputStream);
                    }
                    for (n3 = 0; n3 < 10; ++n3) {
                        string = cObject.rov.rvStrings[n3];
                        if (string == null) {
                            string = "";
                        }
                        dataOutputStream.writeUTF(string);
                    }
                }
                switch (cObject.hoType) {
                    case 2: {
                        continue block36;
                    }
                    case 3: {
                        CText cText = (CText)cObject;
                        dataOutputStream.writeShort(cText.rsFlag);
                        dataOutputStream.writeInt(cText.rsBoxCx);
                        dataOutputStream.writeInt(cText.rsBoxCy);
                        dataOutputStream.writeInt(cText.rsMaxi);
                        dataOutputStream.writeInt(cText.rsMini);
                        dataOutputStream.writeByte(cText.rsHidden);
                        string = cText.rsTextBuffer;
                        if (string == null) {
                            string = "";
                        }
                        dataOutputStream.writeUTF(string);
                        dataOutputStream.writeShort(cText.rsFont);
                        dataOutputStream.writeInt(cText.rsTextColor);
                        continue block36;
                    }
                    case 4: {
                        continue block36;
                    }
                    case 5: {
                        object3 = (CScore)cObject;
                        dataOutputStream.writeShort(((CScore)object3).rsPlayer);
                        ((CScore)object3).rsValue.write(dataOutputStream);
                        dataOutputStream.writeInt(((CScore)object3).rsBoxCx);
                        dataOutputStream.writeInt(((CScore)object3).rsBoxCy);
                        dataOutputStream.writeShort(((CScore)object3).rsFont);
                        dataOutputStream.writeInt(((CScore)object3).rsColor1);
                        continue block36;
                    }
                    case 6: {
                        object6 = (CLives)cObject;
                        dataOutputStream.writeShort(((CLives)object6).rsPlayer);
                        ((CLives)object6).rsValue.write(dataOutputStream);
                        dataOutputStream.writeInt(((CLives)object6).rsBoxCx);
                        dataOutputStream.writeInt(((CLives)object6).rsBoxCy);
                        dataOutputStream.writeShort(((CLives)object6).rsFont);
                        dataOutputStream.writeInt(((CLives)object6).rsColor1);
                        continue block36;
                    }
                    case 7: {
                        object2 = (CCounter)cObject;
                        dataOutputStream.writeShort(((CCounter)object2).rsFlags);
                        dataOutputStream.writeInt(((CCounter)object2).rsMini);
                        dataOutputStream.writeInt(((CCounter)object2).rsMaxi);
                        ((CCounter)object2).rsValue.write(dataOutputStream);
                        dataOutputStream.writeInt(((CCounter)object2).rsBoxCx);
                        dataOutputStream.writeInt(((CCounter)object2).rsBoxCy);
                        dataOutputStream.writeDouble(((CCounter)object2).rsMiniDouble);
                        dataOutputStream.writeDouble(((CCounter)object2).rsMaxiDouble);
                        dataOutputStream.writeShort(((CCounter)object2).rsOldFrame);
                        dataOutputStream.writeByte(((CCounter)object2).rsHidden);
                        dataOutputStream.writeShort(((CCounter)object2).rsFont);
                        dataOutputStream.writeInt(((CCounter)object2).rsColor1);
                        dataOutputStream.writeInt(((CCounter)object2).rsColor2);
                        continue block36;
                    }
                    case 8: {
                        object5 = (CRtf)cObject;
                        ((CRtf)object5).writePosition(dataOutputStream);
                        continue block36;
                    }
                    case 9: {
                        object = (CCCA)cObject;
                        ((CCCA)object).writePosition(dataOutputStream);
                        continue block36;
                    }
                    default: {
                        object4 = (CExtension)cObject;
                        if (((CExtension)object4).ext.saveRunObject(dataOutputStream)) continue block36;
                        throw new IOException();
                    }
                }
            }
            short[] sArray = new short[this.rhNObjects];
            for (n = 0; n < this.rhFrame.nLayers; ++n) {
                n7 = 0;
                CSprite cSprite = this.spriteGen.getFirstSprite(n, 0);
                while (cSprite != null) {
                    cObject = cSprite.sprExtraInfo;
                    if (cObject.hoCreationId != 0) {
                        sArray[n7++] = cObject.hoNumber;
                    }
                    cSprite = this.spriteGen.getNextSprite(cSprite, 2);
                }
                dataOutputStream.writeInt(n7);
                for (n3 = 0; n3 < n7; ++n3) {
                    dataOutputStream.writeShort(sArray[n3]);
                }
            }
            sArray = new short[this.rhNObjects + this.rhOiList.length + 1];
            n7 = 0;
            for (int i = 0; i < this.rhOiList.length; ++i) {
                object3 = this.rhOiList[i];
                short s2 = ((CObjInfo)object3).oilObject;
                while (s2 >= 0) {
                    sArray[n7++] = s2;
                    cObject = this.rhObjectList[s2];
                    if (cObject == null) break;
                    if (cObject.hoCreationId == 0) {
                        --n7;
                    }
                    s2 = cObject.hoNumNext;
                }
                sArray[n7++] = -1;
            }
            dataOutputStream.writeShort((short)n7);
            for (n3 = 0; n3 < n7; ++n3) {
                dataOutputStream.writeShort(sArray[n3]);
            }
            if (this.rhApp.adGO != null) {
                dataOutputStream.writeInt(this.rhApp.adGO.size());
                for (n3 = 0; n3 < this.rhApp.adGO.size(); ++n3) {
                    object2 = this.rhApp.adGO.get(n3);
                    dataOutputStream.writeUTF(((CSaveGlobal)object2).name);
                    dataOutputStream.writeInt(((CSaveGlobal)object2).objects.size());
                    for (int i = 0; i < ((CSaveGlobal)object2).objects.size(); ++i) {
                        object = ((CSaveGlobal)object2).objects.get(i);
                        if (object instanceof CSaveGlobalCounter) {
                            dataOutputStream.writeByte(0);
                            ((CSaveGlobalCounter)object).write(dataOutputStream);
                            continue;
                        }
                        if (object instanceof CSaveGlobalText) {
                            dataOutputStream.writeByte(1);
                            ((CSaveGlobalText)object).write(dataOutputStream);
                            continue;
                        }
                        if (!(object instanceof CSaveGlobalValues)) continue;
                        dataOutputStream.writeByte(2);
                        ((CSaveGlobalValues)object).write(dataOutputStream);
                    }
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            n7 = this.rhEvtProg.events.length;
            dataOutputStream.writeInt(n7);
            for (n3 = 0; n3 < n7; ++n3) {
                object2 = this.rhEvtProg.events[n3];
                dataOutputStream.writeShort(((CEventGroup)object2).evgFlags);
                dataOutputStream.writeShort(((CEventGroup)object2).evgInhibit);
                dataOutputStream.writeShort(((CEventGroup)object2).evgInhibitCpt);
                dataOutputStream.writeShort(((CEventGroup)object2).evgIdentifier);
                for (int i = 0; i < ((CEventGroup)object2).evgNCond + ((CEventGroup)object2).evgNAct; ++i) {
                    object = ((CEventGroup)object2).evgEvents[i];
                    dataOutputStream.writeByte(((CEvent)object).evtFlags);
                    dataOutputStream.writeByte(((CEvent)object).evtFlags2);
                }
            }
            bl2 = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (bl) {
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl2) {
            this.reportError(7);
            return false;
        }
        this.rh4SaveFrameCount = this.rhLoopCount;
        return true;
    }

    String openLoadFile() {
        String string = null;
        string = this.rh4PSaveFilename;
        string = this.rh4PSaveFilename;
        if (this.rhApp.pLoadFilename != null) {
            string = this.rhApp.pLoadFilename;
        }
        if (string != null && string.length() != 0) {
            return string;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new CSaveFilter());
        this.pause();
        int n = jFileChooser.showOpenDialog(this.rhApp.window);
        this.resume();
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string2 = CServices.getExtension(file);
        if (string2 == null) {
            string = file.getAbsolutePath();
            string = string + ".mfs";
            file = new File(string);
        }
        return file.getAbsolutePath();
    }

    public int loadApplicationPosition(DataInputStream dataInputStream) {
        boolean bl = false;
        String string = null;
        if (dataInputStream == null && (string = this.openLoadFile()) == null) {
            return -1;
        }
        int n = -1;
        int n2 = 1;
        try {
            int n3;
            if (dataInputStream == null) {
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
                bl = true;
            }
            if ((n3 = dataInputStream.readInt()) != -855703551) {
                n2 = 2;
            } else {
                n = dataInputStream.readShort();
                if (n != 1) {
                    n2 = 4;
                } else {
                    dataInputStream.readUTF();
                    n = dataInputStream.readShort();
                    int n4 = dataInputStream.readInt();
                    n2 = n4 != this.rh4SaveVersion ? 5 : 0;
                }
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (dataInputStream != null && bl) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reportError(n2);
        if (n2 == 0) {
            this.rhApp.pLoadFilename = string;
        }
        return n;
    }

    public boolean loadFramePosition(DataInputStream dataInputStream) {
        boolean bl = false;
        String string = null;
        if (dataInputStream == null && (string = this.openLoadFile()) == null) {
            return false;
        }
        int n = -1;
        int n2 = 1;
        boolean bl2 = true;
        try {
            int n3;
            if (dataInputStream == null) {
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
                bl = true;
            }
            if ((n3 = dataInputStream.readInt()) != -855703551) {
                n2 = 2;
            } else {
                n = dataInputStream.readShort();
                if (n != 1) {
                    n2 = 4;
                } else {
                    String string2 = dataInputStream.readUTF();
                    if (string2.compareTo(this.rhApp.appName) != 0) {
                        n2 = 3;
                    } else {
                        n = dataInputStream.readShort();
                        if (n != this.rhApp.currentFrame) {
                            n2 = 6;
                        } else {
                            int n4 = dataInputStream.readInt();
                            if (n4 != this.rh4SaveVersion) {
                                n2 = 5;
                            } else {
                                String string3;
                                int n5;
                                this.rhApp.m_bLoading = true;
                                if (this.rhEvtProg != null) {
                                    this.f_StopSamples();
                                    this.f_StopMusics();
                                    this.killFrameObjects();
                                    this.y_KillLevel(false);
                                    this.rhEvtProg.unBranchPrograms();
                                    this.freeMouse();
                                    this.freeRunHeader();
                                }
                                this.allocRunHeader();
                                this.initAsmLoop();
                                this.y_InitLevel();
                                this.prepareFrame();
                                this.rhEvtProg.prepareProgram();
                                this.rhEvtProg.assemblePrograms(this);
                                this.f_InitLoop();
                                bl2 = false;
                                n2 = 1;
                                this.rhNPlayers = dataInputStream.readInt();
                                this.rhMouseUsed = dataInputStream.readByte();
                                this.rhGameFlags = dataInputStream.readShort();
                                this.rhWindowX = dataInputStream.readInt();
                                this.rhWindowY = dataInputStream.readInt();
                                this.rhLoopCount = dataInputStream.readInt();
                                this.rhTimer = dataInputStream.readLong();
                                this.rhTimerOld = dataInputStream.readLong() + System.currentTimeMillis();
                                for (n5 = 0; n5 < 4; ++n5) {
                                    this.rh2InputMask[n5] = dataInputStream.readByte();
                                }
                                this.rh2CreationCount = dataInputStream.readShort();
                                this.rh3Graine = dataInputStream.readShort();
                                this.rh3DisplayX = dataInputStream.readInt();
                                this.rh3DisplayY = dataInputStream.readInt();
                                this.rh3WindowSx = dataInputStream.readInt();
                                this.rh3WindowSy = dataInputStream.readInt();
                                this.rh3XMinimum = dataInputStream.readInt();
                                this.rh3YMinimum = dataInputStream.readInt();
                                this.rh3XMaximum = dataInputStream.readInt();
                                this.rh3YMaximum = dataInputStream.readInt();
                                this.rh3XMinimumKill = dataInputStream.readInt();
                                this.rh3YMinimumKill = dataInputStream.readInt();
                                this.rh3XMaximumKill = dataInputStream.readInt();
                                this.rh3YMaximumKill = dataInputStream.readInt();
                                this.rh4VBLDelta = dataInputStream.readInt();
                                this.rh4LoopTheoric = dataInputStream.readInt();
                                this.rh4EventCount = dataInputStream.readInt();
                                this.rh4WindowDeltaX = dataInputStream.readInt();
                                this.rh4WindowDeltaY = dataInputStream.readInt();
                                this.rh4TimeOut = dataInputStream.readInt();
                                this.rhFrame.leX = dataInputStream.readInt();
                                this.rhFrame.leY = dataInputStream.readInt();
                                this.rhFrame.leLastScrlX = dataInputStream.readInt();
                                this.rhFrame.leLastScrlY = dataInputStream.readInt();
                                this.rhFrame.leWidth = dataInputStream.readInt();
                                this.rhFrame.leHeight = dataInputStream.readInt();
                                this.rhFrame.leVirtualRect.read(dataInputStream);
                                this.rhFrame.leBackground = dataInputStream.readInt();
                                for (n5 = 0; n5 < this.rhFrame.nLayers; ++n5) {
                                    CLayer cLayer = this.rhFrame.layers[n5];
                                    cLayer.x = dataInputStream.readInt();
                                    cLayer.y = dataInputStream.readInt();
                                    cLayer.dx = dataInputStream.readInt();
                                    cLayer.dy = dataInputStream.readInt();
                                    cLayer.dwOptions = dataInputStream.readInt();
                                    cLayer.xCoef = dataInputStream.readFloat();
                                    cLayer.yCoef = dataInputStream.readFloat();
                                }
                                for (n5 = 0; n5 < 4; ++n5) {
                                    this.rhApp.scores[n5] = dataInputStream.readInt();
                                }
                                for (n5 = 0; n5 < 4; ++n5) {
                                    this.rhApp.lives[n5] = dataInputStream.readInt();
                                }
                                int n6 = dataInputStream.readInt();
                                CValue cValue = new CValue();
                                for (n5 = 0; n5 < n6; ++n5) {
                                    cValue.read(dataInputStream);
                                    if (cValue.type == 0 && (cValue.type != 0 || cValue.intValue == 0)) continue;
                                    this.rhApp.setGlobalValueAt(n5, cValue);
                                }
                                if (n5 < this.rhApp.getNGlobalValues()) {
                                    CValue cValue2 = new CValue(0);
                                    while (n5 < this.rhApp.getNGlobalValues()) {
                                        this.rhApp.setGlobalValueAt(n5, cValue2);
                                        ++n5;
                                    }
                                }
                                int n7 = dataInputStream.readInt();
                                for (n5 = 0; n5 < n7; ++n5) {
                                    string3 = dataInputStream.readUTF();
                                    if (string3.length() == 0) continue;
                                    this.rhApp.setGlobalStringAt(n5, string3);
                                }
                                if (n5 < this.rhApp.getNGlobalStrings()) {
                                    while (n5 < this.rhApp.getNGlobalStrings()) {
                                        this.rhApp.setGlobalStringAt(n5, "");
                                        ++n5;
                                    }
                                }
                                int n8 = 0;
                                COI cOI = this.rhApp.OIList.getFirstOI();
                                while (cOI != null) {
                                    if (cOI.oiType >= 2) {
                                        ++n8;
                                    }
                                    cOI = this.rhApp.OIList.getNextOI();
                                }
                                n5 = dataInputStream.readInt();
                                if (n5 != n8) {
                                    n2 = 5;
                                } else {
                                    CObject cObject;
                                    int n9;
                                    Object object;
                                    int n10;
                                    int n11;
                                    int n12;
                                    short s;
                                    int n13;
                                    int n14;
                                    int n15 = dataInputStream.readInt();
                                    n8 = 0;
                                    boolean bl3 = false;
                                    for (int i = 0; i < n15; ++i) {
                                        Object object2;
                                        int n16;
                                        int n17;
                                        bl3 = true;
                                        n14 = dataInputStream.readShort();
                                        n13 = dataInputStream.readShort();
                                        s = dataInputStream.readShort();
                                        n12 = dataInputStream.readInt();
                                        int n18 = dataInputStream.readInt();
                                        int n19 = dataInputStream.readInt();
                                        n11 = dataInputStream.readInt();
                                        n10 = dataInputStream.readShort();
                                        object = null;
                                        COI cOI2 = this.rhApp.OIList.getOIFromHandle(s);
                                        CObjectCommon cObjectCommon = null;
                                        if (cOI2 != null && (cObjectCommon = (CObjectCommon)cOI2.oiOC) != null) {
                                            object = cObjectCommon.ocFadeIn;
                                            if ((n10 & 8) == 0) {
                                                cObjectCommon.ocFadeIn = null;
                                            }
                                        }
                                        if ((n9 = this.f_CreateObject((short)n13, s, n12, n18, n11, (short)0, (short)n19, n14)) < 0) {
                                            n2 = 5;
                                            break;
                                        }
                                        cObject = this.rhObjectList[n14];
                                        if (cObjectCommon != null) {
                                            cObjectCommon.ocFadeIn = object;
                                        }
                                        cObject.hoFlags = (short)n10;
                                        cObject.hoCreationId = dataInputStream.readShort();
                                        cObject.hoX = dataInputStream.readInt();
                                        cObject.hoY = dataInputStream.readInt();
                                        cObject.hoCalculX = dataInputStream.readInt();
                                        cObject.hoCalculY = dataInputStream.readInt();
                                        cObject.hoImgXSpot = dataInputStream.readInt();
                                        cObject.hoImgYSpot = dataInputStream.readInt();
                                        cObject.hoImgWidth = dataInputStream.readInt();
                                        cObject.hoImgHeight = dataInputStream.readInt();
                                        cObject.hoRect.read(dataInputStream);
                                        cObject.hoOEFlags = dataInputStream.readInt();
                                        cObject.hoIdentifier = dataInputStream.readInt();
                                        int n20 = dataInputStream.readInt();
                                        if (n20 > 0) {
                                            cObject.hoBaseNoRepeat = new ArrayList();
                                            for (n5 = 0; n5 < n20; ++n5) {
                                                n17 = dataInputStream.readInt();
                                                cObject.hoBaseNoRepeat.add(new Integer(n17));
                                            }
                                        }
                                        n17 = dataInputStream.readInt();
                                        if (cObject.rom != null) {
                                            cObject.rom.rmMovement.rmAcc = dataInputStream.readInt();
                                            cObject.rom.rmMovement.rmDec = dataInputStream.readInt();
                                            cObject.rom.rmMovement.rmStopSpeed = dataInputStream.readInt();
                                            cObject.rom.rmMovement.rmAccValue = dataInputStream.readInt();
                                            cObject.rom.rmMovement.rmDecValue = dataInputStream.readInt();
                                            cObject.rom.rmEventFlags = dataInputStream.readShort();
                                            cObject.rom.rmReverse = dataInputStream.readInt();
                                            cObject.rom.rmBouncing = dataInputStream.readBoolean();
                                            cObject.rom.rmMvtNum = dataInputStream.readInt();
                                            if (n17 != 13 && n17 != 11) {
                                                cObject.rom.init(cObject.rom.rmMvtNum, cObject, cObject.hoCommon, null, -1);
                                            } else {
                                                cObject.rom.initSimple(cObject, n17, true);
                                            }
                                            if (n17 != cObject.roc.rcMovementType) {
                                                n2 = 5;
                                                break;
                                            }
                                            switch (cObject.roc.rcMovementType) {
                                                case 0: {
                                                    break;
                                                }
                                                case 1: {
                                                    CMoveMouse cMoveMouse = (CMoveMouse)cObject.rom.rmMovement;
                                                    cMoveMouse.MM_DXMouse = dataInputStream.readInt();
                                                    cMoveMouse.MM_DYMouse = dataInputStream.readInt();
                                                    cMoveMouse.MM_FXMouse = dataInputStream.readInt();
                                                    cMoveMouse.MM_FYMouse = dataInputStream.readInt();
                                                    cMoveMouse.MM_Stopped = dataInputStream.readInt();
                                                    cMoveMouse.MM_OldSpeed = dataInputStream.readInt();
                                                    break;
                                                }
                                                case 2: {
                                                    CMoveRace cMoveRace = (CMoveRace)cObject.rom.rmMovement;
                                                    cMoveRace.MR_Bounce = dataInputStream.readInt();
                                                    cMoveRace.MR_BounceMu = dataInputStream.readInt();
                                                    cMoveRace.MR_Speed = dataInputStream.readInt();
                                                    cMoveRace.MR_RotSpeed = dataInputStream.readInt();
                                                    cMoveRace.MR_RotCpt = dataInputStream.readInt();
                                                    cMoveRace.MR_RotPos = dataInputStream.readInt();
                                                    cMoveRace.MR_RotMask = dataInputStream.readInt();
                                                    cMoveRace.MR_OkReverse = dataInputStream.readInt();
                                                    cMoveRace.MR_OldJoy = dataInputStream.readInt();
                                                    cMoveRace.MR_LastBounce = dataInputStream.readInt();
                                                    break;
                                                }
                                                case 3: {
                                                    CMoveGeneric cMoveGeneric = (CMoveGeneric)cObject.rom.rmMovement;
                                                    cMoveGeneric.MG_Bounce = dataInputStream.readInt();
                                                    cMoveGeneric.MG_OkDirs = dataInputStream.readInt();
                                                    cMoveGeneric.MG_BounceMu = dataInputStream.readInt();
                                                    cMoveGeneric.MG_Speed = dataInputStream.readInt();
                                                    cMoveGeneric.MG_LastBounce = dataInputStream.readInt();
                                                    cMoveGeneric.MG_DirMask = dataInputStream.readInt();
                                                    break;
                                                }
                                                case 4: {
                                                    CMoveBall cMoveBall = (CMoveBall)cObject.rom.rmMovement;
                                                    cMoveBall.MB_StartDir = dataInputStream.readInt();
                                                    cMoveBall.MB_Angles = dataInputStream.readInt();
                                                    cMoveBall.MB_Securite = dataInputStream.readInt();
                                                    cMoveBall.MB_SecuCpt = dataInputStream.readInt();
                                                    cMoveBall.MB_Bounce = dataInputStream.readInt();
                                                    cMoveBall.MB_Speed = dataInputStream.readInt();
                                                    cMoveBall.MB_MaskBounce = dataInputStream.readInt();
                                                    cMoveBall.MB_LastBounce = dataInputStream.readInt();
                                                    cMoveBall.MB_Blocked = dataInputStream.readBoolean();
                                                    break;
                                                }
                                                case 5: {
                                                    CMovePath cMovePath = (CMovePath)cObject.rom.rmMovement;
                                                    cMovePath.MT_Speed = dataInputStream.readInt();
                                                    cMovePath.MT_Sinus = dataInputStream.readInt();
                                                    cMovePath.MT_Cosinus = dataInputStream.readInt();
                                                    cMovePath.MT_Longueur = dataInputStream.readInt();
                                                    cMovePath.MT_XOrigin = dataInputStream.readInt();
                                                    cMovePath.MT_YOrigin = dataInputStream.readInt();
                                                    cMovePath.MT_XDest = dataInputStream.readInt();
                                                    cMovePath.MT_YDest = dataInputStream.readInt();
                                                    cMovePath.MT_MoveNumber = dataInputStream.readInt();
                                                    cMovePath.MT_Direction = dataInputStream.readBoolean();
                                                    cMovePath.MT_Calculs = dataInputStream.readInt();
                                                    cMovePath.MT_XStart = dataInputStream.readInt();
                                                    cMovePath.MT_YStart = dataInputStream.readInt();
                                                    cMovePath.MT_Pause = dataInputStream.readInt();
                                                    string3 = dataInputStream.readUTF();
                                                    if (string3.length() == 0) break;
                                                    cMovePath.MT_GotoNode = string3;
                                                    break;
                                                }
                                                case 9: {
                                                    CMovePlatform cMovePlatform = (CMovePlatform)cObject.rom.rmMovement;
                                                    cMovePlatform.MP_Type = dataInputStream.readInt();
                                                    cMovePlatform.MP_Bounce = dataInputStream.readInt();
                                                    cMovePlatform.MP_BounceMu = dataInputStream.readInt();
                                                    cMovePlatform.MP_XSpeed = dataInputStream.readInt();
                                                    cMovePlatform.MP_Gravity = dataInputStream.readInt();
                                                    cMovePlatform.MP_Jump = dataInputStream.readInt();
                                                    cMovePlatform.MP_YSpeed = dataInputStream.readInt();
                                                    cMovePlatform.MP_XMB = dataInputStream.readInt();
                                                    cMovePlatform.MP_YMB = dataInputStream.readInt();
                                                    cMovePlatform.MP_HTFOOT = dataInputStream.readInt();
                                                    cMovePlatform.MP_JumpControl = dataInputStream.readInt();
                                                    cMovePlatform.MP_JumpStopped = dataInputStream.readInt();
                                                    cMovePlatform.MP_PreviousDir = dataInputStream.readInt();
                                                    n16 = dataInputStream.readInt();
                                                    if (n16 >= 0) {
                                                        cMovePlatform.MP_ObjectUnder = this.rhObjectList[n16];
                                                    }
                                                    cMovePlatform.MP_XObjectUnder = dataInputStream.readInt();
                                                    cMovePlatform.MP_YObjectUnder = dataInputStream.readInt();
                                                    break;
                                                }
                                                case 11: {
                                                    break;
                                                }
                                                case 12: {
                                                    break;
                                                }
                                                case 13: {
                                                    CMoveBullet cMoveBullet = (CMoveBullet)cObject.rom.rmMovement;
                                                    cMoveBullet.MBul_Wait = dataInputStream.readBoolean();
                                                    n16 = dataInputStream.readInt();
                                                    if (n16 < 0) break;
                                                    cMoveBullet.MBul_ShootObject = this.rhObjectList[n16];
                                                    break;
                                                }
                                                case 14: {
                                                    CMoveExtension cMoveExtension = (CMoveExtension)cObject.rom.rmMovement;
                                                    cMoveExtension.callLoadPosition(dataInputStream);
                                                }
                                            }
                                        }
                                        if (cObject.roc != null) {
                                            cObject.roc.rcPlayer = dataInputStream.readInt();
                                            cObject.roc.rcMovementType = dataInputStream.readInt();
                                            cObject.roc.rcAnim = dataInputStream.readInt();
                                            cObject.roc.rcImage = dataInputStream.readShort();
                                            cObject.roc.rcScaleX = dataInputStream.readFloat();
                                            cObject.roc.rcScaleY = dataInputStream.readFloat();
                                            cObject.roc.rcAngle = dataInputStream.readInt();
                                            cObject.roc.rcDir = dataInputStream.readInt();
                                            cObject.roc.rcSpeed = dataInputStream.readInt();
                                            cObject.roc.rcMinSpeed = dataInputStream.readInt();
                                            cObject.roc.rcMaxSpeed = dataInputStream.readInt();
                                            cObject.roc.rcOldX = dataInputStream.readInt();
                                            cObject.roc.rcOldY = dataInputStream.readInt();
                                            cObject.roc.rcOldImage = dataInputStream.readShort();
                                            cObject.roc.rcOldAngle = dataInputStream.readInt();
                                            cObject.roc.rcOldDir = dataInputStream.readInt();
                                            cObject.roc.rcOldX1 = dataInputStream.readInt();
                                            cObject.roc.rcOldY1 = dataInputStream.readInt();
                                            cObject.roc.rcOldX2 = dataInputStream.readInt();
                                            cObject.roc.rcOldX2 = dataInputStream.readInt();
                                        }
                                        if (cObject.roa != null) {
                                            cObject.roa.raAnimForced = dataInputStream.readInt();
                                            cObject.roa.raAnimDirForced = dataInputStream.readInt();
                                            cObject.roa.raAnimSpeedForced = dataInputStream.readInt();
                                            cObject.roa.raAnimStopped = dataInputStream.readBoolean();
                                            cObject.roa.raAnimOn = dataInputStream.readInt();
                                            cObject.roa.raAnimDir = dataInputStream.readInt();
                                            cObject.roa.raAnimPreviousDir = dataInputStream.readInt();
                                            cObject.roa.raAnimSpeed = dataInputStream.readInt();
                                            cObject.roa.raAnimMinSpeed = dataInputStream.readInt();
                                            cObject.roa.raAnimMaxSpeed = dataInputStream.readInt();
                                            cObject.roa.raAnimDeltaSpeed = dataInputStream.readInt();
                                            cObject.roa.raAnimCounter = dataInputStream.readInt();
                                            cObject.roa.raAnimDelta = dataInputStream.readInt();
                                            cObject.roa.raAnimRepeat = dataInputStream.readInt();
                                            cObject.roa.raAnimRepeatLoop = dataInputStream.readInt();
                                            cObject.roa.raAnimFrame = dataInputStream.readInt();
                                            cObject.roa.raAnimNumberOfFrame = dataInputStream.readInt();
                                            cObject.roa.raAnimFrameForced = dataInputStream.readInt();
                                            cObject.roa.raRoutineAnimation = dataInputStream.readInt();
                                            cObject.roa.raAnimOn = -1;
                                            cObject.roa.raAnimDir = -1;
                                        }
                                        n16 = 0;
                                        long l = 0L;
                                        long l2 = 0L;
                                        long l3 = 0L;
                                        int n21 = 0;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        boolean bl6 = false;
                                        if (cObject.ros != null) {
                                            cObject.ros.rsFlash = dataInputStream.readInt();
                                            cObject.ros.rsFlashCpt = dataInputStream.readInt();
                                            cObject.ros.rsLayer = dataInputStream.readShort();
                                            cObject.ros.rsZOrder = dataInputStream.readInt();
                                            cObject.ros.rsCreaFlags = dataInputStream.readInt();
                                            cObject.ros.rsBackColor = dataInputStream.readInt();
                                            cObject.ros.rsEffect = dataInputStream.readInt();
                                            cObject.ros.rsEffectParam = dataInputStream.readInt();
                                            cObject.ros.rsFlags = dataInputStream.readShort();
                                            cObject.ros.rsFadeCreaFlags = dataInputStream.readShort();
                                            cObject.ros.rsSpriteType = dataInputStream.readShort();
                                            cObject.ros.rsFlags = (short)(cObject.ros.rsFlags & 0xFFFFFFFB);
                                            if (dataInputStream.readByte() != 0) {
                                                l = dataInputStream.readLong();
                                                l2 = dataInputStream.readLong();
                                                l3 = dataInputStream.readLong();
                                                n21 = dataInputStream.readInt();
                                                bl4 = dataInputStream.readBoolean();
                                                bl5 = dataInputStream.readBoolean();
                                                bl6 = dataInputStream.readBoolean();
                                                n16 = 1;
                                            }
                                        }
                                        if (cObject.rov != null) {
                                            object2 = new CValue();
                                            for (n5 = 0; n5 < 26; ++n5) {
                                                ((CValue)object2).read(dataInputStream);
                                                if (((CValue)object2).type == 0 && (((CValue)object2).type != 0 || ((CValue)object2).intValue == 0)) continue;
                                                cObject.rov.rvValues[n5] = new CValue((CValue)object2);
                                            }
                                            for (n5 = 0; n5 < 10; ++n5) {
                                                string3 = dataInputStream.readUTF();
                                                if (string3.length() == 0) continue;
                                                cObject.rov.rvStrings[n5] = new String(string3);
                                            }
                                        }
                                        switch (cObject.hoType) {
                                            case 2: {
                                                break;
                                            }
                                            case 3: {
                                                object2 = (CText)cObject;
                                                ((CText)object2).rsFlag = dataInputStream.readShort();
                                                ((CText)object2).rsBoxCx = dataInputStream.readInt();
                                                ((CText)object2).rsBoxCy = dataInputStream.readInt();
                                                ((CText)object2).rsMaxi = dataInputStream.readInt();
                                                ((CText)object2).rsMini = dataInputStream.readInt();
                                                ((CText)object2).rsHidden = dataInputStream.readByte();
                                                ((CText)object2).rsTextBuffer = dataInputStream.readUTF();
                                                ((CText)object2).rsFont = dataInputStream.readShort();
                                                ((CText)object2).rsTextColor = dataInputStream.readInt();
                                                break;
                                            }
                                            case 4: {
                                                break;
                                            }
                                            case 5: {
                                                CScore cScore = (CScore)cObject;
                                                cScore.rsPlayer = dataInputStream.readShort();
                                                cScore.rsValue.read(dataInputStream);
                                                cScore.rsBoxCx = dataInputStream.readInt();
                                                cScore.rsBoxCy = dataInputStream.readInt();
                                                cScore.rsFont = dataInputStream.readShort();
                                                cScore.rsColor1 = dataInputStream.readInt();
                                                break;
                                            }
                                            case 6: {
                                                CLives cLives = (CLives)cObject;
                                                cLives.rsPlayer = dataInputStream.readShort();
                                                cLives.rsValue.read(dataInputStream);
                                                cLives.rsBoxCx = dataInputStream.readInt();
                                                cLives.rsBoxCy = dataInputStream.readInt();
                                                cLives.rsFont = dataInputStream.readShort();
                                                cLives.rsColor1 = dataInputStream.readInt();
                                                break;
                                            }
                                            case 7: {
                                                CCounter cCounter = (CCounter)cObject;
                                                cCounter.rsFlags = dataInputStream.readShort();
                                                cCounter.rsMini = dataInputStream.readInt();
                                                cCounter.rsMaxi = dataInputStream.readInt();
                                                cCounter.rsValue.read(dataInputStream);
                                                cCounter.rsBoxCx = dataInputStream.readInt();
                                                cCounter.rsBoxCy = dataInputStream.readInt();
                                                cCounter.rsMiniDouble = dataInputStream.readDouble();
                                                cCounter.rsMaxiDouble = dataInputStream.readDouble();
                                                cCounter.rsOldFrame = dataInputStream.readShort();
                                                cCounter.rsHidden = dataInputStream.readByte();
                                                cCounter.rsFont = dataInputStream.readShort();
                                                cCounter.rsColor1 = dataInputStream.readInt();
                                                cCounter.rsColor2 = dataInputStream.readInt();
                                                break;
                                            }
                                            case 8: {
                                                CRtf cRtf = (CRtf)cObject;
                                                cRtf.readPosition(dataInputStream);
                                                break;
                                            }
                                            case 9: {
                                                CCCA cCCA = (CCCA)cObject;
                                                cCCA.readPosition(dataInputStream);
                                                break;
                                            }
                                            default: {
                                                CExtension cExtension = (CExtension)cObject;
                                                if (cExtension.ext.loadRunObject(dataInputStream)) break;
                                                throw new IOException();
                                            }
                                        }
                                        if ((cObject.hoOEFlags & 0x200) != 0) {
                                            if ((cObject.ros.rsFlags & 1) != 0) {
                                                if (cObject.roc.rcSprite != null) {
                                                    this.spriteGen.showSprite(cObject.roc.rcSprite, false);
                                                }
                                            } else if (cObject.roc.rcSprite != null) {
                                                this.spriteGen.showSprite(cObject.roc.rcSprite, true);
                                            }
                                        }
                                        if (n16 == 0) continue;
                                        boolean bl7 = false;
                                        if ((cObject.hoFlags & 8) != 0) {
                                            bl7 = true;
                                        } else if ((cObject.hoFlags & 0x10) != 0) {
                                            cObject.hoFlags = (short)(cObject.hoFlags | 1);
                                            if ((cObject.hoOEFlags & 0x20) != 0 || (cObject.hoOEFlags & 0x200) != 0) {
                                                this.init_Disappear(cObject);
                                                bl7 = true;
                                            } else {
                                                cObject.hoCallRoutine = false;
                                                this.destroy_Add(cObject.hoNumber);
                                            }
                                        }
                                        if (!bl7) continue;
                                        cObject.ros.rsTrans.m_initTime = l + System.currentTimeMillis();
                                        cObject.ros.rsTrans.m_currentTime = l2 + System.currentTimeMillis();
                                        cObject.ros.rsTrans.m_endTime = l3 + System.currentTimeMillis();
                                        cObject.ros.rsTrans.m_duration = n21;
                                        cObject.ros.rsTrans.m_overflow = bl4;
                                        cObject.ros.rsTrans.m_running = bl5;
                                        cObject.ros.rsTrans.m_starting = bl6;
                                    }
                                    for (n14 = 0; n14 < this.rhFrame.nLayers; ++n14) {
                                        n13 = dataInputStream.readInt();
                                        for (n5 = 0; n5 < n13; ++n5) {
                                            s = dataInputStream.readShort();
                                            cObject = this.rhObjectList[s];
                                            if (cObject.ros == null || cObject.roc.rcSprite == null) continue;
                                            this.spriteGen.moveSpriteToFront(cObject.roc.rcSprite);
                                        }
                                    }
                                    n13 = dataInputStream.readShort();
                                    for (n11 = 0; n11 < this.rhOiList.length; ++n11) {
                                        CObjInfo cObjInfo = this.rhOiList[n11];
                                        s = dataInputStream.readShort();
                                        if (s < 0) continue;
                                        cObjInfo.oilObject = s;
                                        cObject = this.rhObjectList[s];
                                        cObject.hoNumPrev = (short)(n11 | 0x8000);
                                        cObject.hoNumNext = Short.MIN_VALUE;
                                        n12 = s;
                                        CObject cObject2 = cObject;
                                        s = dataInputStream.readShort();
                                        while (s >= 0) {
                                            cObject2.hoNumNext = s;
                                            cObject = this.rhObjectList[s];
                                            cObject.hoNumPrev = (short)n12;
                                            cObject.hoNumNext = Short.MIN_VALUE;
                                            n12 = s;
                                            cObject2 = cObject;
                                            s = dataInputStream.readShort();
                                        }
                                    }
                                    n10 = dataInputStream.readInt();
                                    if (n10 != 0) {
                                        this.rhApp.adGO = new ArrayList();
                                        for (n5 = 0; n5 < n10; ++n5) {
                                            object = new CSaveGlobal();
                                            this.rhApp.adGO.add((CSaveGlobal)object);
                                            ((CSaveGlobal)object).name = dataInputStream.readUTF();
                                            int n22 = dataInputStream.readInt();
                                            block51: for (int i = 0; i < n22; ++i) {
                                                n9 = dataInputStream.readByte();
                                                switch (n9) {
                                                    case 0: {
                                                        CSaveGlobalCounter cSaveGlobalCounter = new CSaveGlobalCounter();
                                                        cSaveGlobalCounter.read(dataInputStream);
                                                        ((CSaveGlobal)object).objects.add(cSaveGlobalCounter);
                                                        continue block51;
                                                    }
                                                    case 1: {
                                                        CSaveGlobalText cSaveGlobalText = new CSaveGlobalText();
                                                        cSaveGlobalText.read(dataInputStream);
                                                        ((CSaveGlobal)object).objects.add(cSaveGlobalText);
                                                        continue block51;
                                                    }
                                                    case 2: {
                                                        CSaveGlobalValues cSaveGlobalValues = new CSaveGlobalValues();
                                                        cSaveGlobalValues.read(dataInputStream);
                                                        ((CSaveGlobal)object).objects.add(cSaveGlobalValues);
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        this.rhApp.adGO = null;
                                    }
                                    if ((n8 = dataInputStream.readInt()) != this.rhEvtProg.events.length) {
                                        n2 = 5;
                                    } else {
                                        for (n5 = 0; n5 < n8; ++n5) {
                                            object = this.rhEvtProg.events[n5];
                                            ((CEventGroup)object).evgFlags = dataInputStream.readShort();
                                            ((CEventGroup)object).evgInhibit = dataInputStream.readShort();
                                            ((CEventGroup)object).evgInhibitCpt = dataInputStream.readShort();
                                            ((CEventGroup)object).evgIdentifier = dataInputStream.readShort();
                                            for (int i = 0; i < ((CEventGroup)object).evgNCond + ((CEventGroup)object).evgNAct; ++i) {
                                                CEvent cEvent = ((CEventGroup)object).evgEvents[i];
                                                cEvent.evtFlags = dataInputStream.readByte();
                                                cEvent.evtFlags2 = dataInputStream.readByte();
                                            }
                                        }
                                        n2 = 0;
                                        bl2 = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            n2 = 1;
        }
        catch (IOException iOException) {
            n2 = 1;
        }
        try {
            if (dataInputStream != null && bl) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reportError(n2);
        this.redrawLevel(null, 6);
        this.captureMouse();
        return bl2;
    }

    void reportError(int n) {
        if (n != 0) {
            new CMessageBox(this.rhApp.window, CResources.getString(7), CResources.getString(0 + n - 1), false, "OK");
            this.rhApp.window.requestFocus();
        }
    }
}

