/*
 * Decompiled with CFR 0.152.
 */
package OI;

import Banks.IEnum;
import OI.COI;
import Services.CChunk;
import Services.CFile;
import java.io.IOException;

public class COIList {
    public short oiMaxIndex;
    public COI[] ois;
    public short oiMaxHandle;
    public short[] oiHandleToIndex;
    public byte[] oiToLoad;
    public byte[] oiLoaded;
    int currentOI;

    public void preLoad(CFile cFile) throws IOException {
        int n;
        this.oiMaxIndex = (short)cFile.readAInt();
        this.ois = new COI[this.oiMaxIndex];
        this.oiMaxHandle = 0;
        for (n = 0; n < this.oiMaxIndex; ++n) {
            CChunk cChunk = new CChunk();
            while (cChunk.chID != CChunk.CHUNK_LAST) {
                cChunk.readHeader(cFile);
                if (cChunk.chSize == 0) continue;
                long l = cFile.getFilePointer() + (long)cChunk.chSize;
                switch (cChunk.chID) {
                    case 17476: {
                        this.ois[n] = new COI();
                        this.ois[n].loadHeader(cFile);
                        if (this.ois[n].oiHandle < this.oiMaxHandle) break;
                        this.oiMaxHandle = (short)(this.ois[n].oiHandle + 1);
                        break;
                    }
                    case 17477: {
                        this.ois[n].oiName = cFile.readAString();
                        break;
                    }
                    case 17478: {
                        this.ois[n].oiFileOffset = (int)cFile.getFilePointer();
                    }
                }
                cFile.seek(l);
            }
        }
        this.oiHandleToIndex = new short[this.oiMaxHandle];
        for (n = 0; n < this.oiMaxIndex; ++n) {
            this.oiHandleToIndex[this.ois[n].oiHandle] = (short)n;
        }
        this.oiToLoad = new byte[this.oiMaxHandle];
        this.oiLoaded = new byte[this.oiMaxHandle];
        for (int i = 0; i < this.oiMaxHandle; ++i) {
            this.oiToLoad[i] = 0;
            this.oiLoaded[i] = 0;
        }
    }

    public COI getOIFromHandle(short s) {
        return this.ois[this.oiHandleToIndex[s]];
    }

    public COI getOIFromIndex(short s) {
        return this.ois[s];
    }

    public void resetOICurrent() {
        for (int i = 0; i < this.oiMaxIndex; ++i) {
            this.ois[i].oiFlags = (short)(this.ois[i].oiFlags & 0xFFFFFFEF);
        }
    }

    public void setOICurrent(int n) {
        this.ois[this.oiHandleToIndex[n]].oiFlags = (short)(this.ois[this.oiHandleToIndex[n]].oiFlags | 0x10);
    }

    public COI getFirstOI() {
        for (int i = 0; i < this.oiMaxIndex; ++i) {
            if ((this.ois[i].oiFlags & 0x10) == 0) continue;
            this.currentOI = i;
            return this.ois[i];
        }
        return null;
    }

    public COI getNextOI() {
        if (this.currentOI < this.oiMaxIndex) {
            for (int i = this.currentOI + 1; i < this.oiMaxIndex; ++i) {
                if ((this.ois[i].oiFlags & 0x10) == 0) continue;
                this.currentOI = i;
                return this.ois[i];
            }
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.oiMaxHandle; ++i) {
            this.oiToLoad[i] = 0;
        }
    }

    public void setToLoad(int n) {
        this.oiToLoad[n] = 1;
    }

    public void load(CFile cFile) throws IOException {
        for (int i = 0; i < this.oiMaxHandle; ++i) {
            if (this.oiToLoad[i] != 0) {
                if (this.oiLoaded[i] != 0 && (this.oiLoaded[i] == 0 || (this.ois[this.oiHandleToIndex[i]].oiLoadFlags & 0x20) == 0)) continue;
                this.ois[this.oiHandleToIndex[i]].load(cFile);
                this.oiLoaded[i] = 1;
                continue;
            }
            if (this.oiLoaded[i] == 0) continue;
            this.ois[this.oiHandleToIndex[i]].unLoad();
            this.oiLoaded[i] = 0;
        }
        this.resetToLoad();
    }

    public void enumElements(IEnum iEnum, IEnum iEnum2) {
        for (int i = 0; i < this.oiMaxHandle; ++i) {
            if (this.oiLoaded[i] == 0) continue;
            this.ois[this.oiHandleToIndex[i]].enumElements(iEnum, iEnum2);
        }
    }
}

