/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Banks.CSound;
import Banks.IEnum;
import Services.CFile;
import java.io.IOException;

public class CSoundBank
implements IEnum {
    CFile file;
    public CSound[] sounds = null;
    public int nHandlesReel;
    public int nHandlesTotal;
    public int nSounds;
    int[] offsetsToSounds;
    short[] handleToIndex;
    short[] useCount;

    public void preLoad(CFile cFile) throws IOException {
        this.file = cFile;
        this.nHandlesReel = this.file.readAShort();
        this.offsetsToSounds = new int[this.nHandlesReel];
        int n = this.file.readAShort();
        CSound cSound = new CSound();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)this.file.getFilePointer();
            cSound.loadHandle(this.file);
            this.offsetsToSounds[cSound.handle] = n2;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.handleToIndex = null;
        this.nHandlesTotal = this.nHandlesReel;
        this.nSounds = 0;
        this.sounds = null;
    }

    public CSound getSoundFromHandle(short s) {
        if (s >= 0 && s < this.nHandlesTotal && this.handleToIndex[s] != -1) {
            return this.sounds[this.handleToIndex[s]];
        }
        return null;
    }

    public CSound getSoundFromIndex(short s) {
        if (s >= 0 && s < this.nSounds) {
            return this.sounds[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CFile cFile) throws IOException {
        int n;
        this.nSounds = 0;
        for (n = 0; n < this.nHandlesReel; ++n) {
            if (this.useCount[n] == 0) continue;
            ++this.nSounds;
        }
        CSound[] cSoundArray = new CSound[this.nSounds];
        int n2 = 0;
        for (int i = 0; i < this.nHandlesReel; ++i) {
            if (this.useCount[i] == 0) continue;
            if (this.sounds != null && this.handleToIndex[i] != -1 && this.sounds[this.handleToIndex[i]] != null) {
                cSoundArray[n2] = this.sounds[this.handleToIndex[i]];
            } else {
                cFile.seek(this.offsetsToSounds[i]);
                cSoundArray[n2] = new CSound();
                cSoundArray[n2].load(cFile);
            }
            ++n2;
        }
        this.sounds = cSoundArray;
        this.handleToIndex = new short[this.nHandlesReel];
        for (n = 0; n < this.nHandlesReel; ++n) {
            this.handleToIndex[n] = -1;
        }
        for (n = 0; n < this.nSounds; ++n) {
            this.handleToIndex[this.sounds[n].handle] = (short)n;
        }
        this.nHandlesTotal = this.nHandlesReel;
        this.resetToLoad();
    }
}

