/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Banks.CMusic;
import Banks.IEnum;
import Services.CFile;
import java.io.IOException;

public class CMusicBank
implements IEnum {
    CFile file;
    public CMusic[] musics = null;
    public int nHandlesReel;
    public int nHandlesTotal;
    public int nMusics;
    int[] offsetsToMusics;
    short[] handleToIndex;
    short[] useCount;

    public void preLoad(CFile cFile) throws IOException {
        this.file = cFile;
        this.nHandlesReel = this.file.readAShort();
        this.offsetsToMusics = new int[this.nHandlesReel];
        int n = this.file.readAShort();
        CMusic cMusic = new CMusic();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)this.file.getFilePointer();
            cMusic.loadHandle(this.file);
            this.offsetsToMusics[cMusic.handle] = n2;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.handleToIndex = null;
        this.nHandlesTotal = this.nHandlesReel;
        this.nMusics = 0;
        this.musics = null;
    }

    public CMusic getMusicFromHandle(short s) {
        if (s >= 0 && s < this.nHandlesTotal && this.handleToIndex[s] != -1) {
            return this.musics[this.handleToIndex[s]];
        }
        return null;
    }

    public CMusic getMusicFromIndex(short s) {
        if (s >= 0 && s < this.nMusics) {
            return this.musics[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CFile cFile) throws IOException {
        int n;
        this.nMusics = 0;
        for (n = 0; n < this.nHandlesReel; ++n) {
            if (this.useCount[n] == 0) continue;
            ++this.nMusics;
        }
        CMusic[] cMusicArray = new CMusic[this.nMusics];
        int n2 = 0;
        for (int i = 0; i < this.nHandlesReel; ++i) {
            if (this.useCount[i] == 0) continue;
            if (this.musics != null && this.handleToIndex[i] != -1 && this.musics[this.handleToIndex[i]] != null) {
                cMusicArray[n2] = this.musics[this.handleToIndex[i]];
            } else {
                cFile.seek(this.offsetsToMusics[i]);
                cMusicArray[n2] = new CMusic();
                cMusicArray[n2].load(cFile);
            }
            ++n2;
        }
        this.musics = cMusicArray;
        this.handleToIndex = new short[this.nHandlesReel];
        for (n = 0; n < this.nHandlesReel; ++n) {
            this.handleToIndex[n] = -1;
        }
        for (n = 0; n < this.nMusics; ++n) {
            this.handleToIndex[this.musics[n].handle] = (short)n;
        }
        this.nHandlesTotal = this.nHandlesReel;
        this.resetToLoad();
    }
}

