/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Services.CFile;
import Sprites.CMask;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.IOException;
import javax.swing.ImageIcon;

public class CImage {
    public short handle;
    public short width;
    public short height;
    public short xSpot;
    public short ySpot;
    public short xAP;
    public short yAP;
    public short useCount;
    public Image img;
    public CMask mask = null;
    public CMask maskPlatform = null;

    public void loadHandle(CFile cFile) throws IOException {
        this.handle = cFile.readAShort();
        cFile.skipBytes(12);
        int n = cFile.readAInt();
        cFile.skipBytes(n);
    }

    public void load(CFile cFile) throws IOException {
        this.handle = cFile.readAShort();
        this.width = cFile.readAShort();
        this.height = cFile.readAShort();
        this.xSpot = cFile.readAShort();
        this.ySpot = cFile.readAShort();
        this.xAP = cFile.readAShort();
        this.yAP = cFile.readAShort();
        int n = cFile.readAInt();
        byte[] byArray = new byte[n];
        cFile.read(byArray);
        ImageIcon imageIcon = new ImageIcon(byArray);
        this.img = imageIcon.getImage();
    }

    public CMask getMask(int n) {
        if ((n & CMask.GCMF_PLATFORM) == 0) {
            if (this.mask == null) {
                this.mask = new CMask();
                this.mask.createMask(this.img, n);
                this.mask.xSpot = this.xSpot;
                this.mask.ySpot = this.ySpot;
            }
            return this.mask;
        }
        if (this.maskPlatform == null) {
            this.maskPlatform = new CMask();
            this.maskPlatform.createMask(this.img, n);
            this.maskPlatform.xSpot = this.xSpot;
            this.maskPlatform.ySpot = this.ySpot;
        }
        return this.maskPlatform;
    }

    public void drawImage(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawImage(this.img, n, n2, null);
    }
}

