/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CClip;
import Application.CRunApp;
import Banks.CSound;

public class CSoundPlayer {
    public static final int nChannels = 32;
    CRunApp app;
    CClip[] clips = null;
    boolean bMultipleSounds = false;
    boolean bOn = true;

    public CSoundPlayer(CRunApp cRunApp) {
        this.app = cRunApp;
        this.clips = new CClip[32];
        for (int i = 0; i < 32; ++i) {
            this.clips[i] = null;
        }
    }

    public void setMultipleSounds(boolean bl) {
        this.bMultipleSounds = bl;
    }

    public void play(short s, int n, int n2, boolean bl) {
        if (!this.bOn) {
            return;
        }
        if (n2 < 0) {
            int n3;
            for (n3 = 0; n3 < 32; ++n3) {
                if (this.clips[n3] != null) {
                    if (this.clips[n3].bLocked || this.clips[n3].isPlaying()) continue;
                    n2 = n3;
                    break;
                }
                n2 = n3;
                break;
            }
            if (n3 == 32) {
                for (n3 = 0; n3 < 32; ++n3) {
                    if (this.clips[n3] == null || this.clips[n3].bLocked) continue;
                    this.clips[n3].stop();
                    n2 = n3;
                    break;
                }
                if (n3 == 32) {
                    return;
                }
            }
        }
        if (n2 < 0 || n2 >= 32) {
            return;
        }
        CSound cSound = this.app.soundBank.getSoundFromHandle(s);
        if (cSound != null) {
            if (this.clips[n2] != null) {
                this.clips[n2].stop();
            }
            if (this.clips[n2] == null) {
                this.clips[n2] = new CClip();
            }
            this.clips[n2].play(cSound.data, s, n, bl);
        }
    }

    public void keepCurrentSounds() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].clip == null) continue;
            this.app.soundBank.setToLoad(this.clips[i].handle);
        }
    }

    public void playFile(String string, int n, int n2, boolean bl) {
        if (!this.bOn) {
            return;
        }
        if (this.bMultipleSounds) {
            if (n2 < 0) {
                int n3;
                for (n3 = 0; n3 < 32; ++n3) {
                    if (this.clips[n3] != null) {
                        if (this.clips[n3].bLocked || this.clips[n3].isPlaying()) continue;
                        n2 = n3;
                        break;
                    }
                    n2 = n3;
                    break;
                }
                if (n3 == 32) {
                    for (n3 = 0; n3 < 32; ++n3) {
                        if (this.clips[n3] == null || this.clips[n3].bLocked) continue;
                        this.clips[n3].stop();
                        n2 = n3;
                        break;
                    }
                    if (n3 == 32) {
                        return;
                    }
                }
            }
        } else if (this.clips[0] != null && this.clips[0].isPlaying()) {
            if (this.clips[0].bPrio) {
                return;
            }
            this.clips[0].stop();
            n2 = 0;
        }
        if (n2 < 0 || n2 >= 32) {
            return;
        }
        if (this.clips[n2] == null) {
            this.clips[n2] = new CClip();
        }
        this.clips[n2].playFile(string, n, bl);
    }

    public void setOnOff(boolean bl) {
        if (bl != this.bOn) {
            this.bOn = bl;
            if (!this.bOn) {
                this.stopAllSounds();
            }
        }
    }

    public boolean getOnOff() {
        return this.bOn;
    }

    public void stopAllSounds() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null) continue;
            this.clips[i].stop();
        }
    }

    public void stop(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].handle != s) continue;
            this.clips[i].stop();
        }
    }

    public void setPosition(short s, int n) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].handle != s) continue;
            this.clips[i].setPosition(n);
        }
    }

    public void pause(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].handle != s) continue;
            this.clips[i].pause();
        }
    }

    public void resume(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].handle != s) continue;
            this.clips[i].resume();
        }
    }

    public void pause() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null) continue;
            this.clips[i].pause();
        }
    }

    public void resume() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null) continue;
            this.clips[i].resume();
        }
    }

    public void pauseAllChannels() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null) continue;
            this.clips[i].pause();
        }
    }

    public void resumeAllChannels() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null) continue;
            this.clips[i].resume();
        }
    }

    public void pauseChannel(int n) {
        if (n >= 0 && n < 32 && this.clips[n] != null) {
            this.clips[n].pause();
        }
    }

    public void resumeChannel(int n) {
        if (n >= 0 && n < 32 && this.clips[n] != null) {
            this.clips[n].resume();
        }
    }

    public void stopChannel(int n) {
        if (n >= 0 && n < 32 && this.clips[n] != null) {
            this.clips[n].stop();
        }
    }

    public void setPositionChannel(int n, int n2) {
        if (n >= 0 && n < 32 && this.clips[n] != null) {
            this.clips[n].setPosition(n2);
        }
    }

    public void lockChannel(int n) {
        if (n >= 0 && n < 32) {
            if (this.clips[n] == null) {
                this.clips[n] = new CClip();
            }
            this.clips[n].bLocked = true;
        }
    }

    public void unlockChannel(int n) {
        if (n >= 0 && n < 32 && this.clips[n] != null) {
            this.clips[n].bLocked = false;
        }
    }

    public boolean isSoundPlaying() {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].clip == null || this.clips[i].bPaused) continue;
            return true;
        }
        return false;
    }

    public boolean isChannelPlaying(int n) {
        return n >= 0 && n < 32 && this.clips[n] != null && this.clips[n].clip != null && !this.clips[n].bPaused;
    }

    public boolean isChannelPaused(int n) {
        return n >= 0 && n < 32 && this.clips[n] != null && this.clips[n].bPaused;
    }

    public boolean isSamplePlaying(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].clip == null || this.clips[i].bPaused || this.clips[i].handle != s) continue;
            return true;
        }
        return false;
    }

    public boolean isSamplePaused(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.clips[i] == null || this.clips[i].handle != s) continue;
            return this.clips[i].bPaused;
        }
        return false;
    }

    public int getChannelDuration(int n) {
        return 0;
    }

    public int getChannelPosition(int n) {
        return 0;
    }
}

