/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CRunApp;
import Banks.CMusic;
import java.io.FileInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

public class CMusicPlayer
implements MetaEventListener {
    private static final int END_OF_TRACK = 47;
    CRunApp app;
    CMusic currentMusic;
    Sequencer sequencer = null;
    int loopCount;
    boolean bPaused = false;
    boolean bOn = true;

    public CMusicPlayer(CRunApp cRunApp) {
        this.app = cRunApp;
        this.sequencer = null;
        if (!this.app.bMacOS || this.app.bMacOS && this.app.applet != null) {
            try {
                this.sequencer = MidiSystem.getSequencer();
                if (this.sequencer != null) {
                    this.sequencer.open();
                    this.sequencer.addMetaEventListener(this);
                    if (!(this.sequencer instanceof Synthesizer)) {
                        Synthesizer synthesizer = MidiSystem.getSynthesizer();
                        synthesizer.open();
                        Receiver receiver = synthesizer.getReceiver();
                        Transmitter transmitter = this.sequencer.getTransmitter();
                        transmitter.setReceiver(receiver);
                    }
                }
            }
            catch (MidiUnavailableException midiUnavailableException) {
                this.sequencer = null;
            }
        }
    }

    public void play(short s, int n) {
        if (this.sequencer == null) {
            return;
        }
        if (!this.bOn) {
            return;
        }
        this.stopCurrentMusic();
        this.currentMusic = this.app.musicBank.getMusicFromHandle(s);
        if (this.currentMusic != null) {
            try {
                this.sequencer.setSequence(this.currentMusic.music);
                this.sequencer.setTickPosition(0L);
                this.loopCount = n;
                this.sequencer.start();
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                this.currentMusic = null;
            }
        }
    }

    public void play(String string, int n) {
        if (this.sequencer == null) {
            return;
        }
        if (!this.bOn) {
            return;
        }
        this.stopCurrentMusic();
        FileInputStream fileInputStream = null;
        if (this.sequencer != null) {
            try {
                fileInputStream = new FileInputStream(string);
                this.currentMusic = new CMusic();
                this.currentMusic.music = MidiSystem.getSequence(fileInputStream);
                this.sequencer.setSequence(this.currentMusic.music);
                this.sequencer.setTickPosition(0L);
                this.loopCount = n;
                this.sequencer.start();
                fileInputStream.close();
                return;
            }
            catch (IOException iOException) {
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            this.currentMusic = null;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void keepCurrentMusic() {
        if (this.sequencer != null && this.currentMusic != null) {
            this.app.musicBank.setToLoad(this.currentMusic.handle);
        }
    }

    public void pause() {
        if (this.sequencer == null) {
            return;
        }
        if (!this.bPaused && this.sequencer != null && this.currentMusic != null && this.sequencer.isRunning()) {
            this.sequencer.stop();
            this.bPaused = true;
        }
    }

    public void resume() {
        if (this.sequencer == null) {
            return;
        }
        if (this.bPaused && this.sequencer != null && this.currentMusic != null) {
            this.sequencer.start();
            this.bPaused = false;
        }
    }

    public void stop() {
        this.stopCurrentMusic();
    }

    public void setOnOff(boolean bl) {
        if (this.sequencer == null) {
            return;
        }
        if (bl != this.bOn) {
            this.bOn = bl;
            if (!this.bOn) {
                this.stopCurrentMusic();
            }
        }
    }

    public boolean getOnOff() {
        return this.bOn;
    }

    public void stopCurrentMusic() {
        if (this.sequencer == null) {
            return;
        }
        if (this.currentMusic != null && this.sequencer != null) {
            this.sequencer.stop();
            this.currentMusic = null;
        }
    }

    public boolean isMusicPlaying() {
        if (this.sequencer == null) {
            return false;
        }
        return this.currentMusic != null;
    }

    public boolean isMusicPlaying(short s) {
        return this.sequencer != null && this.currentMusic != null && this.currentMusic.handle == s;
    }

    public boolean isMusicPaused() {
        if (this.sequencer != null && this.currentMusic != null) {
            return this.bPaused;
        }
        return false;
    }

    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47 && this.sequencer != null) {
            if (this.loopCount > 0) {
                --this.loopCount;
                if (this.loopCount == 0) {
                    this.currentMusic = null;
                } else {
                    this.sequencer.setTickPosition(0L);
                    this.sequencer.start();
                }
            } else {
                this.sequencer.setTickPosition(0L);
                this.sequencer.start();
            }
        }
    }
}

