/*
 * Decompiled with CFR 0.152.
 */
package Transitions;

import Application.CRunApp;
import Extensions.CExtClassLoader;
import Objects.CExtension;
import Objects.CObject;
import Transitions.CTrans;
import Transitions.CTransitionData;
import Transitions.CTransitions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CTransitionManager {
    CRunApp app;

    public CTransitionManager(CRunApp cRunApp) {
        this.app = cRunApp;
    }

    public CTrans startObjectFade(CObject cObject, boolean bl) {
        CTransitionData cTransitionData = cObject.hoCommon.ocFadeIn;
        if (bl) {
            cTransitionData = cObject.hoCommon.ocFadeOut;
        }
        Image image = null;
        if ((cObject.hoOEFlags & 0x20) != 0) {
            image = cObject.hoAdRunHeader.rhApp.imageBank.getImageFromHandle((short)cObject.roc.rcImage).img;
            if (!(cObject.roc.rcSprite == null || cObject.roc.rcAngle == 0 && (double)cObject.roc.rcScaleX == 1.0 && (double)cObject.roc.rcScaleY == 1.0 || cObject.roc.rcSprite.sprSf == null && cObject.roc.rcSprite.sprTempSf == null)) {
                image = cObject.roc.rcSprite.sprSf != null ? cObject.roc.rcSprite.sprSf : cObject.roc.rcSprite.sprTempSf;
            }
        } else if (cObject.hoType >= 32) {
            CExtension cExtension = (CExtension)cObject;
            image = cExtension.ext.getRunObjectSurface();
        }
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        if (bl) {
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            if ((cTransitionData.transFlags & 1) != 0) {
                this.copyColorMask(bufferedImage3, image, cTransitionData.transColor);
            } else {
                graphics2D = bufferedImage3.createGraphics();
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.dispose();
            }
        } else {
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            if ((cTransitionData.transFlags & 1) != 0) {
                this.copyColorMask(bufferedImage2, image, cTransitionData.transColor);
            } else {
                graphics2D = bufferedImage2.createGraphics();
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.dispose();
            }
        }
        CTrans cTrans = null;
        try {
            cTrans = this.createTransition(cTransitionData, bufferedImage, bufferedImage2, bufferedImage3);
            int n3 = 0;
            n3 = (cObject.hoFlags & 0x10) != 0 ? (n3 |= 2) : (n3 |= 1);
            cTrans.stepDraw(n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cTrans;
    }

    void copyColorMask(BufferedImage bufferedImage, Image image, int n) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int[] nArray = new int[n2 * n3];
        bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
        int n4 = n & 0xFFFFFF;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = nArray[i * n2 + j] & 0xFF000000;
                if (n5 == 0) continue;
                nArray[i * n2 + j] = n5 | n4;
            }
        }
        bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
    }

    public CTrans createTransition(CTransitionData cTransitionData, BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3) throws IOException {
        String string = "CTransition" + cTransitionData.dllName;
        try {
            Class<?> clazz;
            Object object;
            if (this.app.extPathname == null) {
                object = this.getClass().getClassLoader();
                clazz = Class.forName(string, false, (ClassLoader)object);
            } else {
                object = new CExtClassLoader(this.app.extPathname);
                clazz = Class.forName(string, false, (ClassLoader)object);
            }
            object = (CTransitions)clazz.newInstance();
            CTrans cTrans = ((CTransitions)object).getTrans(cTransitionData);
            this.app.file.seek(cTransitionData.dataOffset);
            cTrans.init(cTransitionData, this.app.file, bufferedImage, bufferedImage2, bufferedImage3);
            return cTrans;
        }
        catch (LinkageError linkageError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }
}

