/*
 * Decompiled with CFR 0.152.
 */
package Sprites;

import Sprites.CMask;

public class CColMask {
    public static final short CM_TEST_OBSTACLE = 0;
    public static final short CM_TEST_PLATFORM = 1;
    public static final int CM_OBSTACLE = 1;
    public static final int CM_PLATFORM = 2;
    public static final int COLMASK_XMARGIN = 64;
    public static final int COLMASK_YMARGIN = 16;
    public static int HEIGHT_PLATFORM = 6;
    static final short[] lMask = new short[]{-1, Short.MAX_VALUE, 16383, 8191, 4095, 2047, 1023, 511, 255, 127, 63, 31, 15, 7, 3, 1};
    static final short[] rMask = new short[]{0, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};
    public short[] obstacle = null;
    public short[] platform = null;
    public int lineWidth;
    public int width;
    public int height;
    public int mX1;
    public int mX2;
    public int mY1;
    public int mY2;
    public int mX1Clip;
    public int mX2Clip;
    public int mY1Clip;
    public int mY2Clip;
    public int mDxScroll;
    public int mDyScroll;

    public static CColMask create(int n, int n2, int n3, int n4, int n5) {
        CColMask cColMask = new CColMask();
        cColMask.mDxScroll = 0;
        cColMask.mDyScroll = 0;
        cColMask.mX1 = cColMask.mX1Clip = n;
        cColMask.mY1 = cColMask.mY1Clip = n2;
        cColMask.mX2 = cColMask.mX2Clip = n3;
        cColMask.mY2 = cColMask.mY2Clip = n4;
        cColMask.width = n3 - n;
        cColMask.height = n4 - n2;
        cColMask.lineWidth = (cColMask.width + 15 & 0xFFFFFFF0) / 16;
        if ((n5 & 1) != 0) {
            cColMask.obstacle = new short[cColMask.lineWidth * cColMask.height];
        }
        if ((n5 & 2) != 0) {
            cColMask.platform = new short[cColMask.lineWidth * cColMask.height];
        }
        return cColMask;
    }

    public void setOrigin(int n, int n2) {
        this.mDxScroll = n;
        this.mDyScroll = n2;
    }

    public void fill(short s) {
        int n;
        int n2 = this.lineWidth * this.height;
        if (this.obstacle != null) {
            for (n = 0; n < n2; ++n) {
                this.obstacle[n] = s;
            }
        }
        if (this.platform != null) {
            for (n = 0; n < n2; ++n) {
                this.platform[n] = s;
            }
        }
    }

    public void fillRectangle(int n, int n2, int n3, int n4, int n5) {
        n3 += this.mDxScroll;
        n2 += this.mDyScroll;
        n4 += this.mDyScroll;
        if ((n += this.mDxScroll) < this.mX1Clip) {
            n = this.mX1Clip;
        }
        if (n3 > this.mX2Clip) {
            n3 = this.mX2Clip;
        }
        if (n >= n3) {
            return;
        }
        if (n2 < this.mY1Clip) {
            n2 = this.mY1Clip;
        }
        if (n4 > this.mY2Clip) {
            n4 = this.mY2Clip;
        }
        if (n2 >= n4) {
            return;
        }
        n -= this.mX1;
        n3 -= this.mX1;
        n2 -= this.mY1;
        n4 -= this.mY1;
        if (this.obstacle != null) {
            this.fillRect(this.obstacle, n, n2, n3, n4, n5 & 1);
        }
        if (this.platform != null) {
            this.fillRect(this.platform, n, n2, n3, n4, n5 >>> 1 & 1);
        }
    }

    void fillRect(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 * this.lineWidth + (n & 0xFFFFFFF0) / 16;
        int n7 = n4 - n2;
        int n8 = n3 / 16 - n / 16 + 1;
        if (n8 > 1) {
            if (n5 == 0) {
                short s = ~lMask[n & 0xF];
                short s2 = ~rMask[n3 & 0xF];
                for (int i = 0; i < n7; ++i) {
                    int n9;
                    int n10;
                    int n11 = n10 = n6 + i * this.lineWidth;
                    sArray[n11] = (short)(sArray[n11] & s);
                    for (n9 = 1; n9 < n8 - 1; ++n9) {
                        sArray[n10 + n9] = 0;
                    }
                    if (n9 != n8 - 1) continue;
                    int n12 = n10 + n9;
                    sArray[n12] = (short)(sArray[n12] & s2);
                }
            } else {
                short s = lMask[n & 0xF];
                short s3 = rMask[n3 & 0xF];
                for (int i = 0; i < n7; ++i) {
                    int n13;
                    int n14;
                    int n15 = n14 = n6 + i * this.lineWidth;
                    sArray[n15] = (short)(sArray[n15] | s);
                    for (n13 = 1; n13 < n8 - 1; ++n13) {
                        sArray[n14 + n13] = -1;
                    }
                    if (n13 != n8 - 1) continue;
                    int n16 = n14 + n13;
                    sArray[n16] = (short)(sArray[n16] | s3);
                }
            }
        } else if (n5 == 0) {
            short s = (short)(~(lMask[n & 0xF] & rMask[n3 & 0xF]));
            for (int i = 0; i < n7; ++i) {
                int n17;
                int n18 = n17 = n6 + i * this.lineWidth;
                sArray[n18] = (short)(sArray[n18] & s);
            }
        } else {
            short s = (short)(lMask[n & 0xF] & rMask[n3 & 0xF]);
            for (int i = 0; i < n7; ++i) {
                int n19;
                int n20 = n19 = n6 + i * this.lineWidth;
                sArray[n20] = (short)(sArray[n20] | s);
            }
        }
    }

    public void orMask(CMask cMask, int n, int n2, int n3, int n4) {
        if ((n3 & 1) != 0 && this.obstacle != null) {
            this.orIt(this.obstacle, cMask, n, n2, (n4 & 1) != 0);
        }
        if ((n3 & 2) != 0 && this.platform != null) {
            this.orIt(this.platform, cMask, n, n2, (n4 >> 1 & 1) != 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void orIt(short[] var1_1, CMask var2_2, int var3_3, int var4_4, boolean var5_5) {
        block46: {
            block45: {
                var6_6 = var3_3;
                var7_7 = var4_4;
                var6_6 += this.mDxScroll;
                var7_7 += this.mDyScroll;
                var8_8 = var3_3 + var2_2.width;
                var9_9 = var4_4 + var2_2.height;
                var10_10 = 0;
                var11_11 = 0;
                var12_12 = var2_2.width;
                var13_13 = var2_2.height;
                if (var6_6 < this.mX1Clip) {
                    var10_10 = this.mX1Clip - var6_6;
                    if (var10_10 > var2_2.width) {
                        return;
                    }
                    var6_6 = this.mX1Clip;
                }
                if (var8_8 > this.mX2Clip) {
                    var12_12 = var2_2.width - (var8_8 - this.mX2Clip);
                    if (var12_12 < 0) {
                        return;
                    }
                    var8_8 = this.mX2Clip;
                }
                if (var7_7 < this.mY1Clip) {
                    var11_11 = this.mY1Clip - var7_7;
                    if (var11_11 > var2_2.height) {
                        return;
                    }
                    var7_7 = this.mY1Clip;
                }
                if (var9_9 > this.mY2Clip) {
                    var13_13 = var2_2.height - (var9_9 - this.mY2Clip);
                    if (var13_13 < 0) {
                        return;
                    }
                    var9_9 = this.mY2Clip;
                }
                var6_6 -= this.mX1;
                var8_8 -= this.mX1;
                var7_7 -= this.mY1;
                var9_9 -= this.mY1;
                var14_14 = var13_13 - var11_11;
                var15_15 = var12_12 / 16 - var10_10 / 16 + 1;
                var21_16 = var6_6 & 15;
                if (var21_16 == 0) break block45;
                block0 : switch (var15_15) {
                    case 1: {
                        if (var5_5) {
                            for (var17_17 = 0; var17_17 < var14_14; ++var17_17) {
                                var19_29 = (var7_7 + var17_17) * this.lineWidth + var6_6 / 16;
                                var22_39 = var2_2.mask[(var11_11 + var17_17) * var2_2.lineWidth + var10_10 / 16] & CColMask.lMask[var10_10 & 15] & CColMask.rMask[var12_12 & 15] & 65535;
                                v0 = var19_29++;
                                var1_1[v0] = (short)(var1_1[v0] | (short)(var22_39 >>> var21_16));
                                if (var6_6 / 16 + 1 >= this.lineWidth) continue;
                                v1 = var19_29;
                                var1_1[v1] = (short)(var1_1[v1] | (short)(var22_39 << 15 - var21_16));
                            }
                        } else {
                            for (var17_18 = 0; var17_18 < var14_14; ++var17_18) {
                                var19_30 = (var7_7 + var17_18) * this.lineWidth + var6_6 / 16;
                                var22_40 = var2_2.mask[(var11_11 + var17_18) * var2_2.lineWidth + var10_10 / 16] & CColMask.lMask[var10_10 & 15] & CColMask.rMask[var12_12 & 15] & 65535;
                                v2 = var19_30++;
                                var1_1[v2] = (short)(var1_1[v2] & ~((short)(var22_40 >>> var21_16)));
                                if (var6_6 / 16 + 1 >= this.lineWidth) continue;
                                v3 = ++var19_30;
                                var1_1[v3] = (short)(var1_1[v3] & ~((short)(var22_40 << 15 - var21_16)));
                            }
                        }
                        break block46;
                    }
                    case 2: {
                        if (var5_5) {
                            for (var17_19 = 0; var17_19 < var14_14; ++var17_19) {
                                var19_31 = (var7_7 + var17_19) * this.lineWidth + var6_6 / 16;
                                var20_45 = (var11_11 + var17_19) * var2_2.lineWidth + var10_10 / 16;
                                var22_41 = var2_2.mask[var20_45] & CColMask.lMask[var10_10 & 15] & 65535;
                                v4 = var19_31++;
                                var1_1[v4] = (short)(var1_1[v4] | (short)(var22_41 >>> var21_16));
                                v5 = var19_31;
                                var1_1[v5] = (short)(var1_1[v5] | (short)(var22_41 << 16 - var21_16));
                                var22_41 = (short)(var2_2.mask[var20_45 + 1] & CColMask.rMask[var12_12 & 15]) & 65535;
                                v6 = var19_31++;
                                var1_1[v6] = (short)(var1_1[v6] | (short)(var22_41 >>> var21_16));
                                if (var6_6 / 16 + 2 >= this.lineWidth) continue;
                                v7 = var19_31;
                                var1_1[v7] = (short)(var1_1[v7] | (short)(var22_41 << 16 - var21_16));
                            }
                        } else {
                            for (var17_20 = 0; var17_20 < var14_14; ++var17_20) {
                                var19_32 = (var7_7 + var17_20) * this.lineWidth + var6_6 / 16;
                                var20_46 = (var11_11 + var17_20) * var2_2.lineWidth + var10_10 / 16;
                                var22_42 = var2_2.mask[var20_46] & CColMask.lMask[var10_10 & 15] & 65535;
                                v8 = var19_32++;
                                var1_1[v8] = (short)(var1_1[v8] & ~((short)(var22_42 >>> var21_16)));
                                v9 = var19_32;
                                var1_1[v9] = (short)(var1_1[v9] & ~((short)(var22_42 << 16 - var21_16)));
                                var22_42 = var2_2.mask[var20_46 + 1] & CColMask.rMask[var12_12 & 15] & 65535;
                                v10 = var19_32++;
                                var1_1[v10] = (short)(var1_1[v10] & ~((short)(var22_42 >>> var21_16)));
                                if (var6_6 / 16 + 2 >= this.lineWidth) continue;
                                v11 = var19_32;
                                var1_1[v11] = (short)(var1_1[v11] & ~((short)(var22_42 << 16 - var21_16)));
                            }
                        }
                        break block46;
                    }
                    default: {
                        if (var5_5) {
                            for (var17_21 = 0; var17_21 < var14_14; ++var17_21) {
                                var19_33 = (var7_7 + var17_21) * this.lineWidth + var6_6 / 16;
                                var20_47 = (var11_11 + var17_21) * var2_2.lineWidth + var10_10 / 16;
                                var22_43 = var2_2.mask[var20_47] & CColMask.lMask[var10_10 & 15] & 65535;
                                v12 = var19_33++;
                                var1_1[v12] = (short)(var1_1[v12] | (short)(var22_43 >>> var21_16));
                                v13 = var19_33;
                                var1_1[v13] = (short)(var1_1[v13] | (short)(var22_43 << 16 - var21_16));
                                for (var16_53 = 1; var16_53 < var15_15 - 1; ++var16_53) {
                                    var22_43 = var2_2.mask[var20_47 + var16_53] & 65535;
                                    v14 = var19_33++;
                                    var1_1[v14] = (short)(var1_1[v14] | (short)(var22_43 >>> var21_16));
                                    v15 = var19_33;
                                    var1_1[v15] = (short)(var1_1[v15] | (short)(var22_43 << 16 - var21_16));
                                }
                                var22_43 = var2_2.mask[var20_47 + var16_53] & CColMask.rMask[var12_12 & 15] & 65535;
                                v16 = var19_33++;
                                var1_1[v16] = (short)(var1_1[v16] | (short)(var22_43 >>> var21_16));
                                if (var6_6 / 16 + var16_53 >= this.lineWidth) continue;
                                v17 = var19_33;
                                var1_1[v17] = (short)(var1_1[v17] | (short)(var22_43 << 16 - var21_16));
                            }
                        } else {
                            var17_22 = 0;
lbl122:
                            // 1 sources

                            while (var17_22 < var14_14) {
                                var19_34 = (var7_7 + var17_22) * this.lineWidth + var6_6 / 16;
                                var20_48 = (var11_11 + var17_22) * var2_2.lineWidth + var10_10 / 16;
                                var22_44 = var2_2.mask[var20_48] & CColMask.lMask[var10_10 & 15] & 65535;
                                v18 = var19_34++;
                                var1_1[v18] = (short)(var1_1[v18] & ~((short)(var22_44 >>> var21_16)));
                                v19 = var19_34;
                                var1_1[v19] = (short)(var1_1[v19] & ~((short)(var22_44 << 16 - var21_16)));
                                for (var16_54 = 1; var16_54 < var15_15 - 1; ++var16_54) {
                                    var22_44 = var2_2.mask[var20_48 + var16_54] & 65535;
                                    v20 = var19_34++;
                                    var1_1[v20] = (short)(var1_1[v20] & ~((short)(var22_44 >>> var21_16)));
                                    v21 = var19_34;
                                    var1_1[v21] = (short)(var1_1[v21] & ~((short)(var22_44 << 16 - var21_16)));
                                }
                                var22_44 = var2_2.mask[var20_48 + var16_54] & CColMask.rMask[var12_12 & 15] & 65535;
                                v22 = var19_34++;
                                var1_1[v22] = (short)(var1_1[v22] & ~((short)(var22_44 >>> var21_16)));
                                if (var6_6 / 16 + var16_54 < this.lineWidth) {
                                    v23 = var19_34;
                                    var1_1[v23] = (short)(var1_1[v23] & ~((short)(var22_44 << 16 - var21_16)));
                                }
                                ++var17_22;
                                break block0;
                            }
                        }
                        break block46;
                    }
                }
                ** GOTO lbl122
            }
            switch (var15_15) {
                case 1: {
                    if (var5_5) {
                        for (var17_23 = 0; var17_23 < var14_14; ++var17_23) {
                            var18_57 = (short)(var2_2.mask[(var11_11 + var17_23) * var2_2.lineWidth + var10_10 / 16] & CColMask.lMask[var10_10 & 15] & CColMask.rMask[var12_12 & 15]);
                            v24 = (var7_7 + var17_23) * this.lineWidth + var6_6 / 16;
                            var1_1[v24] = (short)(var1_1[v24] | var18_57);
                        }
                    } else {
                        for (var17_24 = 0; var17_24 < var14_14; ++var17_24) {
                            var18_58 = (short)(var2_2.mask[(var11_11 + var17_24) * var2_2.lineWidth + var10_10 / 16] & CColMask.lMask[var10_10 & 15] & CColMask.rMask[var12_12 & 15]);
                            v25 = (var7_7 + var17_24) * this.lineWidth + var6_6 / 16;
                            var1_1[v25] = (short)(var1_1[v25] & ~var18_58);
                        }
                    }
                    break;
                }
                case 2: {
                    if (var5_5) {
                        for (var17_25 = 0; var17_25 < var14_14; ++var17_25) {
                            var19_35 = (var7_7 + var17_25) * this.lineWidth + var6_6 / 16;
                            var20_49 = (var11_11 + var17_25) * var2_2.lineWidth + var10_10 / 16;
                            var18_59 = (short)(var2_2.mask[var20_49] & CColMask.lMask[var10_10 & 15]);
                            v26 = var19_35;
                            var1_1[v26] = (short)(var1_1[v26] | var18_59);
                            var18_59 = (short)(var2_2.mask[var20_49 + 1] & CColMask.rMask[var12_12 & 15]);
                            v27 = var19_35 + 1;
                            var1_1[v27] = (short)(var1_1[v27] | var18_59);
                        }
                    } else {
                        for (var17_26 = 0; var17_26 < var14_14; ++var17_26) {
                            var19_36 = (var7_7 + var17_26) * this.lineWidth + var6_6 / 16;
                            var20_50 = (var11_11 + var17_26) * var2_2.lineWidth + var10_10 / 16;
                            var18_60 = (short)(var2_2.mask[var20_50] & CColMask.lMask[var10_10 & 15]);
                            v28 = var19_36;
                            var1_1[v28] = (short)(var1_1[v28] & ~var18_60);
                            var18_60 = (short)(var2_2.mask[var20_50 + 1] & CColMask.rMask[var12_12 & 15]);
                            v29 = var19_36 + 1;
                            var1_1[v29] = (short)(var1_1[v29] & ~var18_60);
                        }
                    }
                    break;
                }
                default: {
                    if (var5_5) {
                        for (var17_27 = 0; var17_27 < var14_14; ++var17_27) {
                            var19_37 = (var7_7 + var17_27) * this.lineWidth + var6_6 / 16;
                            var20_51 = (var11_11 + var17_27) * var2_2.lineWidth + var10_10 / 16;
                            var18_61 = (short)(var2_2.mask[var20_51] & CColMask.lMask[var10_10 & 15]);
                            v30 = var19_37;
                            var1_1[v30] = (short)(var1_1[v30] | var18_61);
                            for (var16_55 = 1; var16_55 < var15_15 - 1; ++var16_55) {
                                var18_61 = var2_2.mask[var20_51 + var16_55];
                                v31 = var19_37 + var16_55;
                                var1_1[v31] = (short)(var1_1[v31] | var18_61);
                            }
                            if ((var12_12 & 16) <= 0) continue;
                            var18_61 = (short)(var2_2.mask[var20_51 + var16_55] & CColMask.rMask[var12_12 & 15]);
                            v32 = var19_37 + var16_55;
                            var1_1[v32] = (short)(var1_1[v32] | var18_61);
                        }
                    } else {
                        for (var17_28 = 0; var17_28 < var14_14; ++var17_28) {
                            var19_38 = (var7_7 + var17_28) * this.lineWidth + var6_6 / 16;
                            var20_52 = (var11_11 + var17_28) * var2_2.lineWidth + var10_10 / 16;
                            var18_62 = (short)(var2_2.mask[var20_52] & CColMask.lMask[var10_10 & 15]);
                            v33 = var19_38;
                            var1_1[v33] = (short)(var1_1[v33] & ~var18_62);
                            for (var16_56 = 1; var16_56 < var15_15 - 1; ++var16_56) {
                                var18_62 = var2_2.mask[var20_52 + var16_56];
                                v34 = var19_38 + var16_56;
                                var1_1[v34] = (short)(var1_1[v34] & ~var18_62);
                            }
                            if ((var12_12 & 16) <= 0) continue;
                            var18_62 = (short)(var2_2.mask[var20_52 + var16_56] & CColMask.rMask[var12_12 & 15]);
                            v35 = var19_38 + var16_56;
                            var1_1[v35] = (short)(var1_1[v35] & ~var18_62);
                        }
                    }
                    break;
                }
            }
        }
    }

    public void orPlatformMask(CMask cMask, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        n3 += this.mDxScroll;
        n4 += this.mDyScroll;
        int n5 = n + cMask.width;
        int n6 = n2 + cMask.height;
        int n7 = 0;
        int n8 = 0;
        int n9 = cMask.width;
        int n10 = cMask.height;
        if (n3 < this.mX1Clip) {
            n7 = this.mX1Clip - n3;
            if (n7 > cMask.width) {
                return;
            }
            n3 = this.mX1Clip;
        }
        if (n5 > this.mX2Clip) {
            n9 = cMask.width - (n5 - this.mX2Clip);
            if (n9 < 0) {
                return;
            }
            n5 = this.mX2Clip;
        }
        if (n4 < this.mY1Clip) {
            n8 = this.mY1Clip - n4;
            if (n8 > cMask.height) {
                return;
            }
            n4 = this.mY1Clip;
        }
        if (n6 > this.mY2Clip) {
            n10 = cMask.height - (n6 - this.mY2Clip);
            if (n10 < 0) {
                return;
            }
            n6 = this.mY2Clip;
        }
        n3 -= this.mX1;
        n5 -= this.mX1;
        n4 -= this.mY1;
        n6 -= this.mY1;
        int n11 = n10 - n8;
        int n12 = n9 - n7;
        short[] sArray = cMask.mask;
        for (int i = 0; i < n12; ++i) {
            int n13;
            int n14 = (n7 + i) / 16;
            short s = (short)(32768 >>> (n7 + i & 0xF));
            for (n13 = 0; n13 < n11 && (sArray[(n8 + n13) * cMask.lineWidth + n14] & s) == 0; ++n13) {
            }
            if (n13 >= n11) continue;
            int n15 = Math.min(n13 + HEIGHT_PLATFORM, n11);
            int n16 = (n3 + i) / 16;
            short s2 = (short)(32768 >>> (n3 + i & 0xF));
            while (n13 < n15) {
                if ((sArray[(n8 + n13) * cMask.lineWidth + n14] & s) != 0) {
                    int n17 = (n4 + n13) * this.lineWidth + n16;
                    this.platform[n17] = (short)(this.platform[n17] | s2);
                }
                ++n13;
            }
        }
    }

    public boolean testPoint(int n, int n2, int n3) {
        if (n3 == 0 && this.obstacle != null && this.testPt(this.obstacle, n, n2)) {
            return true;
        }
        return n3 == 1 && (this.platform != null ? this.testPt(this.platform, n, n2) : this.obstacle != null && this.testPt(this.obstacle, n, n2));
    }

    boolean testPt(short[] sArray, int n, int n2) {
        short s;
        n2 += this.mDyScroll;
        if ((n += this.mDxScroll) < this.mX1Clip || n > this.mX2Clip) {
            return false;
        }
        if (n2 < this.mY1Clip || n2 > this.mY2Clip) {
            return false;
        }
        int n3 = (n2 -= this.mY1) * this.lineWidth + (n -= this.mX1) / 16;
        return (sArray[n3] & (s = (short)(32768 >>> (n & 0xF)))) != 0;
    }

    public boolean testRect(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 0 && this.obstacle != null && this.testRc(this.obstacle, n, n2, n3, n4)) {
            return true;
        }
        return n5 == 1 && (this.platform != null ? this.testRc(this.platform, n, n2, n3, n4) : this.obstacle != null && this.testRc(this.obstacle, n, n2, n3, n4));
    }

    boolean testRc(short[] sArray, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = (n5 += this.mDxScroll) + n3;
        int n8 = (n6 += this.mDyScroll) + n4;
        if (n5 < this.mX1Clip) {
            n5 = this.mX1Clip;
        }
        if (n7 > this.mX2Clip) {
            n7 = this.mX2Clip;
        }
        if (n6 < this.mY1Clip) {
            n6 = this.mY1Clip;
        }
        if (n8 > this.mY2Clip) {
            n8 = this.mY2Clip;
        }
        if (n7 <= n5 || n8 <= n6) {
            return false;
        }
        int n9 = (n8 -= this.mY1) - (n6 -= this.mY1);
        int n10 = ((n7 -= this.mX1) - 1) / 16 - (n5 -= this.mX1) / 16 + 1;
        switch (n10) {
            case 1: {
                short s = (short)(lMask[n5 & 0xF] & rMask[n7 - 1 & 0xF]);
                for (int i = 0; i < n9; ++i) {
                    int n11 = (n6 + i) * this.lineWidth + n5 / 16;
                    if ((sArray[n11] & s) == 0) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n9; ++i) {
                    int n12 = (n6 + i) * this.lineWidth + n5 / 16;
                    if ((sArray[n12] & lMask[n5 & 0xF]) != 0) {
                        return true;
                    }
                    if ((sArray[n12 + 1] & rMask[n7 - 1 & 0xF]) == 0) continue;
                    return true;
                }
                break;
            }
            default: {
                for (int i = 0; i < n9; ++i) {
                    int n13;
                    int n14 = (n6 + i) * this.lineWidth + n5 / 16;
                    if ((sArray[n14] & lMask[n5 & 0xF]) != 0) {
                        return true;
                    }
                    for (n13 = 1; n13 < n10 - 1; ++n13) {
                        if (sArray[n14 + n13] == 0) continue;
                        return true;
                    }
                    if ((sArray[n14 + n13] & rMask[n7 - 1 & 0xF]) == 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean testMask(CMask cMask, int n, int n2, int n3, int n4) {
        if (n4 == 0 && this.obstacle != null && this.testIt(this.obstacle, cMask, n, n2, n3)) {
            return true;
        }
        return n4 == 1 && (this.platform != null ? this.testIt(this.platform, cMask, n, n2, n3) : this.obstacle != null && this.testIt(this.obstacle, cMask, n, n2, n3));
    }

    public boolean testIt(short[] sArray, CMask cMask, int n, int n2, int n3) {
        block37: {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            block36: {
                n10 = n2;
                n9 = n3;
                int n11 = (n10 += this.mDxScroll) + cMask.width;
                int n12 = (n9 += this.mDyScroll) + cMask.height;
                n8 = 0;
                n7 = n;
                n6 = cMask.width;
                int n13 = cMask.height;
                if (n10 < this.mX1Clip) {
                    n8 = this.mX1Clip - n10;
                    if (n8 > cMask.width) {
                        return false;
                    }
                    n10 = this.mX1Clip;
                }
                if (n11 > this.mX2Clip) {
                    n6 = cMask.width - (n11 - this.mX2Clip);
                    if (n6 < 0) {
                        return false;
                    }
                    n11 = this.mX2Clip;
                }
                if (n9 < this.mY1Clip) {
                    n7 = this.mY1Clip - n9;
                    if (n7 > cMask.height) {
                        return false;
                    }
                    n9 = this.mY1Clip;
                }
                if (n12 > this.mY2Clip) {
                    n13 = cMask.height - (n12 - this.mY2Clip);
                    if (n13 < 0) {
                        return false;
                    }
                    n12 = this.mY2Clip;
                }
                if (n6 <= n8) {
                    return false;
                }
                n10 -= this.mX1;
                n11 -= this.mX1;
                n9 -= this.mY1;
                n12 -= this.mY1;
                n5 = n13 - n7;
                n4 = (n6 - n8 + 15) / 16;
                int n14 = n10 & 0xF;
                if (n14 == 0) break block36;
                block0 : switch (n4) {
                    case 1: {
                        for (int i = 0; i < n5; ++i) {
                            int n15 = (n9 + i) * this.lineWidth + n10 / 16;
                            int n16 = cMask.mask[(n7 + i) * cMask.lineWidth + n8 / 16] & lMask[n8 & 0xF] & rMask[n6 - 1 & 0xF] & 0xFFFF;
                            if ((sArray[n15] & (short)(n16 >>> n14)) != 0) {
                                return true;
                            }
                            if (n10 / 16 + 1 >= this.lineWidth || (sArray[++n15] & (short)(n16 << 15 - n14)) == 0) continue;
                            return true;
                        }
                        break block37;
                    }
                    case 2: {
                        for (int i = 0; i < n5; ++i) {
                            int n17 = (n9 + i) * this.lineWidth + n10 / 16;
                            int n18 = (n7 + i) * cMask.lineWidth + n8 / 16;
                            int n19 = cMask.mask[n18] & lMask[n8 & 0xF] & 0xFFFF;
                            if ((sArray[n17] & (short)(n19 >>> n14)) != 0) {
                                return true;
                            }
                            if ((sArray[++n17] & (short)(n19 << 16 - n14)) != 0) {
                                return true;
                            }
                            n19 = (short)(cMask.mask[n18 + 1] & rMask[n6 - 1 & 0xF]) & 0xFFFF;
                            if ((sArray[n17] & (short)(n19 >>> n14)) != 0) {
                                return true;
                            }
                            if (n10 / 16 + 2 >= this.lineWidth || (sArray[++n17] & (short)(n19 << 16 - n14)) == 0) continue;
                            return true;
                        }
                        break block37;
                    }
                    default: {
                        int n20 = 0;
                        while (n20 < n5) {
                            int n21;
                            int n22 = (n9 + n20) * this.lineWidth + n10 / 16;
                            int n23 = (n7 + n20) * cMask.lineWidth + n8 / 16;
                            int n24 = cMask.mask[n23] & lMask[n8 & 0xF] & 0xFFFF;
                            if ((sArray[n22] & (short)(n24 >>> n14)) != 0) {
                                return true;
                            }
                            if ((sArray[++n22] & (short)(n24 << 16 - n14)) != 0) {
                                return true;
                            }
                            for (n21 = 1; n21 < n4 - 1; ++n21) {
                                n24 = cMask.mask[n23 + n21] & 0xFFFF;
                                if ((sArray[n22] & (short)(n24 >>> n14)) != 0) {
                                    return true;
                                }
                                if ((sArray[++n22] & (short)(n24 << 16 - n14)) == 0) continue;
                                return true;
                            }
                            n24 = cMask.mask[n23 + n21] & rMask[n6 - 1 & 0xF] & 0xFFFF;
                            if ((sArray[n22] & (short)(n24 >>> n14)) != 0) {
                                return true;
                            }
                            if (n10 / 16 + n21 < this.lineWidth && (sArray[++n22] & (short)(n24 << 16 - n14)) != 0) {
                                return true;
                            }
                            ++n20;
                            break block0;
                        }
                        break block37;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            switch (n4) {
                case 1: {
                    for (int i = 0; i < n5; ++i) {
                        short s = (short)(cMask.mask[(n7 + i) * cMask.lineWidth + n8 / 16] & lMask[n8 & 0xF] & rMask[n6 - 1 & 0xF]);
                        if ((sArray[(n9 + i) * this.lineWidth + n10 / 16] & s) == 0) continue;
                        return true;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n5; ++i) {
                        int n25 = (n9 + i) * this.lineWidth + n10 / 16;
                        int n26 = (n7 + i) * cMask.lineWidth + n8 / 16;
                        short s = (short)(cMask.mask[n26] & lMask[n8 & 0xF]);
                        if ((sArray[n25] & s) != 0) {
                            return true;
                        }
                        s = (short)(cMask.mask[n26 + 1] & rMask[n6 - 1 & 0xF]);
                        if ((sArray[n25 + 1] & s) == 0) continue;
                        return true;
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < n5; ++i) {
                        int n27;
                        int n28 = (n9 + i) * this.lineWidth + n10 / 16;
                        int n29 = (n7 + i) * cMask.lineWidth + n8 / 16;
                        short s = (short)(cMask.mask[n29] & lMask[n8 & 0xF]);
                        if ((sArray[n28] & s) != 0) {
                            return true;
                        }
                        for (n27 = 1; n27 < n4 - 1; ++n27) {
                            s = cMask.mask[n29 + n27];
                            if ((sArray[n28 + n27] & s) == 0) continue;
                            return true;
                        }
                        s = (short)(cMask.mask[n29 + n27] & rMask[n6 - 1 & 0xF]);
                        if ((sArray[n28 + n27] & s) == 0) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

