/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Application.CRunApp;
import Banks.CImage;
import Banks.IEnum;
import Services.CFile;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;

public class CImageBank
implements IEnum {
    public CRunApp app;
    CFile file;
    public CImage[] images;
    public int nHandlesReel;
    public int nHandlesTotal;
    public int nImages;
    int[] offsetsToImage;
    short[] handleToIndex;
    short[] useCount;

    public CImageBank(CRunApp cRunApp) {
        this.app = cRunApp;
    }

    public void preLoad(CFile cFile) throws IOException {
        this.file = cFile;
        this.nHandlesReel = this.file.readAShort();
        this.offsetsToImage = new int[this.nHandlesReel];
        int n = this.file.readAShort();
        CImage cImage = new CImage();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)this.file.getFilePointer();
            cImage.loadHandle(this.file);
            this.offsetsToImage[cImage.handle] = n2;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.handleToIndex = null;
        this.nHandlesTotal = this.nHandlesReel;
        this.nImages = 0;
        this.images = null;
    }

    public CImage getImageFromHandle(short s) {
        if (s >= 0 && s < this.nHandlesTotal && this.handleToIndex[s] != -1) {
            return this.images[this.handleToIndex[s]];
        }
        return null;
    }

    public CImage getImageFromIndex(short s) {
        if (s >= 0 && s < this.nImages) {
            return this.images[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CFile cFile) throws IOException {
        int n;
        this.nImages = 0;
        for (n = 0; n < this.nHandlesReel; ++n) {
            if (this.useCount[n] == 0) continue;
            ++this.nImages;
        }
        CImage[] cImageArray = new CImage[this.nImages];
        int n2 = 0;
        for (int i = 0; i < this.nHandlesReel; ++i) {
            if (this.useCount[i] == 0) continue;
            if (this.images != null && this.handleToIndex[i] != -1 && this.images[this.handleToIndex[i]] != null) {
                cImageArray[n2] = this.images[this.handleToIndex[i]];
                cImageArray[n2].useCount = this.useCount[i];
            } else {
                cImageArray[n2] = new CImage();
                cFile.seek(this.offsetsToImage[i]);
                cImageArray[n2].load(cFile);
                cImageArray[n2].useCount = this.useCount[i];
            }
            ++n2;
        }
        this.images = cImageArray;
        this.handleToIndex = new short[this.nHandlesReel];
        for (n = 0; n < this.nHandlesReel; ++n) {
            this.handleToIndex[n] = -1;
        }
        for (n = 0; n < this.nImages; ++n) {
            this.handleToIndex[this.images[n].handle] = (short)n;
        }
        this.nHandlesTotal = this.nHandlesReel;
        this.resetToLoad();
    }

    public void delImage(short s) {
        CImage cImage = this.getImageFromHandle(s);
        if (cImage != null) {
            cImage.useCount = (short)(cImage.useCount - 1);
            if (cImage.useCount <= 0) {
                for (int i = 0; i < this.nImages; ++i) {
                    if (this.images[i] != cImage) continue;
                    this.images[i] = null;
                    this.handleToIndex[s] = -1;
                    break;
                }
            }
        }
    }

    public short addImageCompare(Image image, short s, short s2, short s3, short s4) {
        int[] nArray = null;
        for (int i = 0; i < this.nImages; ++i) {
            Object object;
            if (this.images[i] == null || this.images[i].xSpot != s || this.images[i].ySpot != s2 || this.images[i].xAP != s3 || this.images[i].yAP != s4) continue;
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n != this.images[i].img.getWidth(null) || n2 != this.images[i].img.getHeight(null)) continue;
            if (nArray == null) {
                nArray = new int[n * n2];
                object = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
                try {
                    ((PixelGrabber)object).grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(this.images[i].img, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = true;
            block5: for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    if (nArray[j * n + k] == object[j * n + k]) continue;
                    bl = false;
                    continue block5;
                }
            }
            if (!bl) continue;
            this.images[i].useCount = (short)(this.images[i].useCount + 1);
            return this.images[i].handle;
        }
        return this.addImage(image, s, s2, s3, s4, (short)1);
    }

    public short addImage(Image image, short s, short s2, short s3, short s4, short s5) {
        int n;
        int n2;
        short s6 = -1;
        for (n2 = this.nHandlesReel; n2 < this.nHandlesTotal; ++n2) {
            if (this.handleToIndex[n2] != -1) continue;
            s6 = (short)n2;
            break;
        }
        if (s6 == -1) {
            short[] sArray = new short[this.nHandlesTotal + 10];
            for (n2 = 0; n2 < this.nHandlesTotal; ++n2) {
                sArray[n2] = this.handleToIndex[n2];
            }
            while (n2 < this.nHandlesTotal + 10) {
                sArray[n2] = -1;
                ++n2;
            }
            s6 = (short)this.nHandlesTotal;
            this.nHandlesTotal += 10;
            this.handleToIndex = sArray;
        }
        int n3 = -1;
        for (n = 0; n < this.nImages; ++n) {
            if (this.images[n] != null) continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            CImage[] cImageArray = new CImage[this.nImages + 10];
            for (n = 0; n < this.nImages; ++n) {
                cImageArray[n] = this.images[n];
            }
            while (n < this.nImages + 10) {
                cImageArray[n] = null;
                ++n;
            }
            n3 = this.nImages;
            this.nImages += 10;
            this.images = cImageArray;
        }
        this.handleToIndex[s6] = (short)n3;
        this.images[n3] = new CImage();
        this.images[n3].handle = s6;
        this.images[n3].img = image;
        this.images[n3].xSpot = s;
        this.images[n3].ySpot = s2;
        this.images[n3].xAP = s3;
        this.images[n3].yAP = s4;
        this.images[n3].useCount = s5;
        this.images[n3].width = (short)image.getWidth(null);
        this.images[n3].height = (short)image.getHeight(null);
        return s6;
    }

    public void loadImageList(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            int n;
            if (sArray[i] < 0 || sArray[i] >= this.nHandlesTotal || this.offsetsToImage[sArray[i]] == 0 || this.getImageFromHandle(sArray[i]) != null) continue;
            int n2 = -1;
            for (n = 0; n < this.nImages; ++n) {
                if (this.images[n] != null) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                CImage[] cImageArray = new CImage[this.nImages + 10];
                for (n = 0; n < this.nImages; ++n) {
                    cImageArray[n] = this.images[n];
                }
                while (n < this.nImages + 10) {
                    cImageArray[n] = null;
                    ++n;
                }
                n2 = this.nImages;
                this.nImages += 10;
                this.images = cImageArray;
            }
            this.handleToIndex[sArray[i]] = (short)n2;
            this.images[n2] = new CImage();
            this.images[n2].useCount = 1;
            try {
                this.file.seek(this.offsetsToImage[sArray[i]]);
                this.images[n2].load(this.file);
                continue;
            }
            catch (IOException iOException) {
                this.images[n2] = null;
            }
        }
    }

    public CImage getImageInfoEx(short s, int n, float f, float f2) {
        CImage cImage = new CImage();
        CImage cImage2 = this.getImageFromHandle(s);
        if (cImage2 != null) {
            int n2 = cImage2.width;
            int n3 = cImage2.height;
            int n4 = cImage2.xSpot;
            int n5 = cImage2.ySpot;
            int n6 = cImage2.xAP;
            int n7 = cImage2.yAP;
            if (n == 0) {
                if (f != 1.0f) {
                    n4 = (int)((float)n4 * f);
                    n6 = (int)((float)n6 * f);
                    n2 = (int)((float)n2 * f);
                }
                if (f2 != 1.0f) {
                    n5 = (int)((float)n5 * f2);
                    n7 = (int)((float)n7 * f2);
                    n3 = (int)((float)n3 * f2);
                }
            } else {
                int n8;
                int n9;
                int n10;
                int n11;
                float f3;
                float f4;
                if (f != 1.0f) {
                    n4 = (int)((float)n4 * f);
                    n6 = (int)((float)n6 * f);
                    n2 = (int)((float)n2 * f);
                }
                if (f2 != 1.0f) {
                    n5 = (int)((float)n5 * f);
                    n7 = (int)((float)n7 * f2);
                    n3 = (int)((float)n3 * f);
                }
                switch (n) {
                    case 90: {
                        f4 = 0.0f;
                        f3 = 1.0f;
                        break;
                    }
                    case 270: {
                        f4 = 0.0f;
                        f3 = -1.0f;
                        break;
                    }
                    default: {
                        double d = (double)n * Math.PI / 180.0;
                        f4 = (float)Math.cos(d);
                        f3 = (float)Math.sin(d);
                    }
                }
                if (f3 >= 0.0f) {
                    n11 = (int)((float)n3 * f3 + 0.5f);
                    n10 = -((int)((float)n2 * f3 + 0.5f));
                } else {
                    n11 = (int)((float)n3 * f3 - 0.5f);
                    n10 = -((int)((float)n2 * f3 - 0.5f));
                }
                if (f4 == 0.0f) {
                    n9 = 0;
                    n8 = 0;
                } else if (f4 > 0.0f) {
                    n9 = (int)((float)n3 * f4 + 0.5f);
                    n8 = (int)((float)n2 * f4 + 0.5f);
                } else {
                    n9 = (int)((float)n3 * f4 - 0.5f);
                    n8 = (int)((float)n2 * f4 - 0.5f);
                }
                int n12 = n11 + n8;
                int n13 = n9 + n10;
                int n14 = (int)((float)n4 * f4 + (float)n5 * f3);
                int n15 = (int)((float)n5 * f4 - (float)n4 * f3);
                int n16 = (int)((float)n6 * f4 + (float)n7 * f3);
                int n17 = (int)((float)n7 * f4 - (float)n6 * f3);
                int n18 = 0;
                int n19 = 0;
                int n20 = Math.min(n18, n11);
                n20 = Math.min(n20, n12);
                n20 = Math.min(n20, n8);
                int n21 = Math.max(n18, n11);
                n21 = Math.max(n21, n12);
                n21 = Math.max(n21, n8);
                int n22 = Math.min(n19, n9);
                n22 = Math.min(n22, n13);
                n22 = Math.min(n22, n10);
                int n23 = Math.max(n19, n9);
                n23 = Math.max(n23, n13);
                n23 = Math.max(n23, n10);
                n2 = n21 - n20;
                n3 = n23 - n22;
                n4 = -(n20 - n14);
                n5 = -(n22 - n15);
                n6 = -(n20 - n16);
                n7 = -(n22 - n17);
            }
            cImage.width = (short)n2;
            cImage.height = (short)n3;
            cImage.xSpot = (short)n4;
            cImage.ySpot = (short)n5;
            cImage.xAP = (short)n6;
            cImage.yAP = (short)n7;
            return cImage;
        }
        return null;
    }
}

