/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Banks.CFont;
import Banks.IEnum;
import Services.CFile;
import Services.CFontInfo;
import java.io.IOException;

public class CFontBank
implements IEnum {
    CFile file;
    public CFont[] fonts = null;
    int[] offsetsToFonts;
    int nFonts = 0;
    short[] handleToIndex;
    int maxHandlesReel = 0;
    int maxHandlesTotal = 0;
    short[] useCount;
    CFont nullFont = null;

    public void preLoad(CFile cFile) throws IOException {
        int n;
        int n2 = cFile.readAInt();
        this.maxHandlesReel = 0;
        long l = cFile.getFilePointer();
        CFont cFont = new CFont();
        for (n = 0; n < n2; ++n) {
            cFont.loadHandle(cFile);
            this.maxHandlesReel = Math.max(this.maxHandlesReel, cFont.handle + 1);
        }
        cFile.seek(l);
        this.offsetsToFonts = new int[this.maxHandlesReel];
        for (n = 0; n < n2; ++n) {
            l = cFile.getFilePointer();
            cFont.loadHandle(cFile);
            this.offsetsToFonts[cFont.handle] = (int)l;
        }
        this.useCount = new short[this.maxHandlesReel];
        this.resetToLoad();
        this.handleToIndex = null;
        this.maxHandlesTotal = this.maxHandlesReel;
        this.nFonts = 0;
        this.fonts = null;
    }

    public void load(CFile cFile) throws IOException {
        int n;
        this.nFonts = 0;
        for (n = 0; n < this.maxHandlesReel; ++n) {
            if (this.useCount[n] == 0) continue;
            ++this.nFonts;
        }
        CFont[] cFontArray = new CFont[this.nFonts];
        int n2 = 0;
        for (int i = 0; i < this.maxHandlesReel; ++i) {
            if (this.useCount[i] == 0) continue;
            if (this.fonts != null && this.handleToIndex[i] != -1 && this.fonts[this.handleToIndex[i]] != null) {
                cFontArray[n2] = this.fonts[this.handleToIndex[i]];
                cFontArray[n2].useCount = this.useCount[i];
            } else {
                cFontArray[n2] = new CFont();
                cFile.seek(this.offsetsToFonts[i]);
                cFontArray[n2].load(cFile);
                cFontArray[n2].useCount = this.useCount[i];
            }
            ++n2;
        }
        this.fonts = cFontArray;
        this.handleToIndex = new short[this.maxHandlesReel];
        for (n = 0; n < this.maxHandlesReel; ++n) {
            this.handleToIndex[n] = -1;
        }
        for (n = 0; n < this.nFonts; ++n) {
            this.handleToIndex[this.fonts[n].handle] = (short)n;
        }
        this.maxHandlesTotal = this.maxHandlesReel;
        this.resetToLoad();
    }

    public CFont getFontFromHandle(short s) {
        if (s == -1) {
            return this.nullFont;
        }
        if (s >= 0 && s < this.maxHandlesTotal && this.handleToIndex[s] != -1) {
            return this.fonts[this.handleToIndex[s]];
        }
        return null;
    }

    public CFont getFontFromIndex(short s) {
        if (s >= 0 && s < this.nFonts) {
            return this.fonts[s];
        }
        return null;
    }

    public CFontInfo getFontInfoFromHandle(short s) {
        CFont cFont = this.getFontFromHandle(s);
        return cFont.getFontInfo();
    }

    public void resetToLoad() {
        for (int i = 0; i < this.maxHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        if (s == -1) {
            if (this.nullFont == null) {
                this.nullFont = new CFont();
                this.nullFont.createDefaultFont();
            }
            return;
        }
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public short addFont(CFontInfo cFontInfo) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.nFonts && (this.fonts[n3] == null || this.fonts[n3].lfHeight != cFontInfo.lfHeight || this.fonts[n3].lfWeight != cFontInfo.lfWeight || this.fonts[n3].lfItalic != cFontInfo.lfItalic || this.fonts[n3].lfUnderline != cFontInfo.lfUnderline || this.fonts[n3].lfStrikeOut != cFontInfo.lfStrikeOut || this.fonts[n3].lfFaceName.compareToIgnoreCase(cFontInfo.lfFaceName) != 0); ++n3) {
        }
        if (n3 < this.nFonts) {
            return this.fonts[n3].handle;
        }
        short s = -1;
        for (n2 = this.maxHandlesReel; n2 < this.maxHandlesTotal; ++n2) {
            if (this.handleToIndex[n2] != -1) continue;
            s = (short)n2;
            break;
        }
        if (s == -1) {
            short[] sArray = new short[this.maxHandlesTotal + 10];
            for (n2 = 0; n2 < this.maxHandlesTotal; ++n2) {
                sArray[n2] = this.handleToIndex[n2];
            }
            while (n2 < this.maxHandlesTotal + 10) {
                sArray[n2] = -1;
                ++n2;
            }
            s = (short)this.maxHandlesTotal;
            this.maxHandlesTotal += 10;
            this.handleToIndex = sArray;
        }
        int n4 = -1;
        for (n = 0; n < this.nFonts; ++n) {
            if (this.fonts[n] != null) continue;
            n4 = n;
            break;
        }
        if (n4 == -1) {
            CFont[] cFontArray = new CFont[this.nFonts + 10];
            for (n = 0; n < this.nFonts; ++n) {
                cFontArray[n] = this.fonts[n];
            }
            while (n < this.nFonts + 10) {
                cFontArray[n] = null;
                ++n;
            }
            n4 = this.nFonts;
            this.nFonts += 10;
            this.fonts = cFontArray;
        }
        this.handleToIndex[s] = (short)n4;
        this.fonts[n4] = new CFont();
        this.fonts[n4].handle = s;
        this.fonts[n4].lfHeight = cFontInfo.lfHeight;
        this.fonts[n4].lfWeight = cFontInfo.lfWeight;
        this.fonts[n4].lfItalic = cFontInfo.lfItalic;
        this.fonts[n4].lfUnderline = cFontInfo.lfUnderline;
        this.fonts[n4].lfStrikeOut = cFontInfo.lfStrikeOut;
        this.fonts[n4].lfFaceName = new String(cFontInfo.lfFaceName);
        return s;
    }
}

