/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Services.CFile;
import Services.CFontInfo;
import java.awt.Font;
import java.io.IOException;

public class CFont {
    public short useCount = 0;
    public short handle = 0;
    public int lfHeight = 0;
    public int lfWidth = 0;
    public int lfEscapement = 0;
    public int lfOrientation = 0;
    public int lfWeight = 0;
    public byte lfItalic = 0;
    public byte lfUnderline = 0;
    public byte lfStrikeOut = 0;
    public byte lfCharSet = 0;
    public byte lfOutPrecision = 0;
    public byte lfClipPrecision = 0;
    public byte lfQuality = 0;
    public byte lfPitchAndFamily = 0;
    public String lfFaceName = null;
    public Font font = null;

    public void loadHandle(CFile cFile) throws IOException {
        this.handle = (short)cFile.readAInt();
        cFile.skipBytes(72);
    }

    public void load(CFile cFile) throws IOException {
        this.handle = (short)cFile.readAInt();
        cFile.skipBytes(12);
        long l = cFile.getFilePointer();
        this.lfHeight = cFile.readAInt();
        if (this.lfHeight < 0) {
            this.lfHeight = -this.lfHeight;
        }
        this.lfWidth = cFile.readAInt();
        this.lfEscapement = cFile.readAInt();
        this.lfOrientation = cFile.readAInt();
        this.lfWeight = cFile.readAInt();
        this.lfItalic = cFile.readByte();
        this.lfUnderline = cFile.readByte();
        this.lfStrikeOut = cFile.readByte();
        this.lfCharSet = cFile.readByte();
        this.lfOutPrecision = cFile.readByte();
        this.lfClipPrecision = cFile.readByte();
        this.lfQuality = cFile.readByte();
        this.lfPitchAndFamily = cFile.readByte();
        this.lfFaceName = cFile.readAString();
        cFile.seek(l + 60L);
        this.font = null;
    }

    public Font createFont() {
        if (this.font == null) {
            int n = 0;
            if (this.lfItalic != 0) {
                n = 2;
            }
            this.font = new Font(this.lfFaceName, n, this.lfHeight);
        }
        return this.font;
    }

    public CFontInfo getFontInfo() {
        CFontInfo cFontInfo = new CFontInfo();
        cFontInfo.lfHeight = this.lfHeight;
        cFontInfo.lfWeight = this.lfWeight;
        cFontInfo.lfItalic = this.lfItalic;
        cFontInfo.lfUnderline = this.lfUnderline;
        cFontInfo.lfStrikeOut = this.lfStrikeOut;
        cFontInfo.lfFaceName = new String(this.lfFaceName);
        return cFontInfo;
    }

    public static CFont createFromFontInfo(CFontInfo cFontInfo) {
        CFont cFont = new CFont();
        cFont.lfHeight = cFontInfo.lfHeight;
        cFont.lfWeight = cFontInfo.lfWeight;
        cFont.lfItalic = cFontInfo.lfItalic;
        cFont.lfUnderline = cFontInfo.lfUnderline;
        cFont.lfStrikeOut = cFontInfo.lfStrikeOut;
        cFont.lfFaceName = cFontInfo.lfFaceName;
        return cFont;
    }

    public void createDefaultFont() {
        this.lfHeight = 12;
        this.lfWeight = 400;
        this.lfItalic = 0;
        this.lfUnderline = 0;
        this.lfStrikeOut = 0;
        this.lfFaceName = "Arial";
    }
}

