/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CCheckBoxMenuItem;
import Application.CKeyConvert;
import Application.CMenuDefItem;
import Application.CMenuItem;
import Application.CRunApp;
import Services.CFile;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CMenuDef {
    ArrayList<CMenuDefItem> menuItems = new ArrayList();
    short[] accelsKey;
    short[] accelsID;
    byte[] accelsShift;

    public void load(CFile cFile) throws IOException {
        long l = cFile.getFilePointer();
        cFile.skipBytes(4);
        int n = cFile.readAInt();
        cFile.skipBytes(4);
        int n2 = cFile.readAInt();
        int n3 = cFile.readAInt();
        cFile.seek(l + (long)n);
        cFile.skipBytes(4);
        this.loadItems(cFile);
        this.accelsKey = new short[n3 / 8];
        this.accelsID = new short[n3 / 8];
        this.accelsShift = new byte[n3 / 8];
        cFile.seek(l + (long)n2);
        for (int i = 0; i < n3 / 8; ++i) {
            this.accelsShift[i] = cFile.readByte();
            cFile.skipBytes(1);
            this.accelsKey[i] = cFile.readAShort();
            this.accelsID[i] = cFile.readAShort();
            cFile.skipBytes(2);
        }
    }

    public void loadItems(CFile cFile) throws IOException {
        CMenuDefItem cMenuDefItem;
        do {
            cMenuDefItem = new CMenuDefItem();
            cMenuDefItem.load(cFile);
            this.menuItems.add(cMenuDefItem);
            if ((cMenuDefItem.flags & 0x10) == 0) continue;
            this.loadItems(cFile);
        } while ((cMenuDefItem.flags & 0x80) == 0);
    }

    public void deleteItem(int n, boolean bl) {
        for (int i = 0; i < this.menuItems.size(); ++i) {
            CMenuDefItem cMenuDefItem = this.menuItems.get(i);
            if (cMenuDefItem.id != n) continue;
            CMenuDefItem cMenuDefItem2 = this.menuItems.get(i - 1);
            if ((cMenuDefItem.flags & 0x80) != 0) {
                cMenuDefItem2.flags = (short)(cMenuDefItem2.flags | 0x80);
            }
            this.menuItems.remove(i);
            if (cMenuDefItem2.name.length() == 0 && bl) {
                if ((cMenuDefItem2.flags & 0x80) != 0) {
                    this.menuItems.get((int)(i - 2)).flags = (short)(this.menuItems.get((int)(i - 2)).flags | 0x80);
                }
                this.menuItems.remove(i - 1);
            }
            return;
        }
    }

    public int getMenuIDFromKey(CRunApp cRunApp) {
        for (int i = 0; i < this.accelsID.length; ++i) {
            short s;
            if ((this.accelsShift[i] & 0x10) != 0 && cRunApp.keyBuffer[18] == 0 || (this.accelsShift[i] & 8) != 0 && cRunApp.keyBuffer[17] == 0 || (this.accelsShift[i] & 4) != 0 && cRunApp.keyBuffer[16] == 0 || cRunApp.keyBuffer[s = CKeyConvert.getJavaKey(this.accelsKey[i])] == 0) continue;
            return this.accelsID[i];
        }
        return -1;
    }

    public JMenuBar createMenu(CRunApp cRunApp) {
        int n = 0;
        JMenuBar jMenuBar = new JMenuBar();
        this.createItems(n, jMenuBar, null, cRunApp);
        return jMenuBar;
    }

    public int createItems(int n, JMenuBar jMenuBar, JMenu jMenu, CRunApp cRunApp) {
        CMenuDefItem cMenuDefItem;
        do {
            KeyStroke keyStroke;
            JMenuItem jMenuItem;
            cMenuDefItem = this.menuItems.get(n++);
            if ((cMenuDefItem.flags & 0x10) != 0) {
                jMenuItem = new JMenu(cMenuDefItem.name);
                if (cMenuDefItem.mnemonic != -1) {
                    jMenuItem.setMnemonic(cMenuDefItem.mnemonic);
                }
                if (jMenuBar != null) {
                    jMenuBar.add((JMenu)jMenuItem);
                } else {
                    jMenu.add(jMenuItem);
                }
                jMenuItem.addActionListener(cRunApp);
                n = this.createItems(n, null, (JMenu)jMenuItem, cRunApp);
                continue;
            }
            if (cMenuDefItem.name.length() == 0) {
                if (jMenu == null) continue;
                jMenu.addSeparator();
                continue;
            }
            if (cMenuDefItem.id == 1020 || cMenuDefItem.id == 1021) {
                jMenuItem = new CCheckBoxMenuItem(cMenuDefItem.name, cMenuDefItem.id);
                if (cMenuDefItem.mnemonic != -1) {
                    jMenuItem.setMnemonic(cMenuDefItem.mnemonic);
                }
                if ((keyStroke = this.getAccelerator(cMenuDefItem.id)) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
                jMenuItem.addActionListener(cRunApp);
                if (jMenuBar != null) {
                    jMenuBar.add(jMenuItem);
                    continue;
                }
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new CMenuItem(cMenuDefItem.name, cMenuDefItem.id);
            if (cMenuDefItem.mnemonic != -1) {
                jMenuItem.setMnemonic(cMenuDefItem.mnemonic);
            }
            if ((keyStroke = this.getAccelerator(cMenuDefItem.id)) != null) {
                jMenuItem.setAccelerator(keyStroke);
            }
            jMenuItem.addActionListener(cRunApp);
            if (jMenuBar != null) {
                jMenuBar.add(jMenuItem);
                continue;
            }
            jMenu.add(jMenuItem);
        } while ((cMenuDefItem.flags & 0x80) == 0);
        return n;
    }

    KeyStroke getAccelerator(short s) {
        for (int i = 0; i < this.accelsID.length; ++i) {
            if (s != this.accelsID[i]) continue;
            int n = 0;
            if ((this.accelsShift[i] & 0x10) != 0) {
                n |= 8;
            }
            if ((this.accelsShift[i] & 8) != 0) {
                n |= 2;
            }
            if ((this.accelsShift[i] & 4) != 0) {
                n |= 1;
            }
            char c = (char)CKeyConvert.getJavaKey(this.accelsKey[i]);
            return KeyStroke.getKeyStroke((int)c, n);
        }
        return null;
    }
}

